package io.fabric8.kubernetes.api.model.authorization.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SelfSubjectAccessReviewSpecFluent<A extends SelfSubjectAccessReviewSpecFluent<A>> extends BaseFluent<A>{
  public SelfSubjectAccessReviewSpecFluent() {
  }
  
  public SelfSubjectAccessReviewSpecFluent(SelfSubjectAccessReviewSpec instance) {
    this.copyInstance(instance);
  }
  private NonResourceAttributesBuilder nonResourceAttributes;
  private ResourceAttributesBuilder resourceAttributes;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SelfSubjectAccessReviewSpec instance) {
    instance = (instance != null ? instance : new SelfSubjectAccessReviewSpec());
    if (instance != null) {
          this.withNonResourceAttributes(instance.getNonResourceAttributes());
          this.withResourceAttributes(instance.getResourceAttributes());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public NonResourceAttributes buildNonResourceAttributes() {
    return this.nonResourceAttributes != null ? this.nonResourceAttributes.build() : null;
  }
  
  public A withNonResourceAttributes(NonResourceAttributes nonResourceAttributes) {
    this._visitables.remove("nonResourceAttributes");
    if (nonResourceAttributes != null) {
        this.nonResourceAttributes = new NonResourceAttributesBuilder(nonResourceAttributes);
        this._visitables.get("nonResourceAttributes").add(this.nonResourceAttributes);
    } else {
        this.nonResourceAttributes = null;
        this._visitables.get("nonResourceAttributes").remove(this.nonResourceAttributes);
    }
    return (A) this;
  }
  
  public boolean hasNonResourceAttributes() {
    return this.nonResourceAttributes != null;
  }
  
  public A withNewNonResourceAttributes(String path,String verb) {
    return (A)withNonResourceAttributes(new NonResourceAttributes(path, verb));
  }
  
  public NonResourceAttributesNested<A> withNewNonResourceAttributes() {
    return new NonResourceAttributesNested(null);
  }
  
  public NonResourceAttributesNested<A> withNewNonResourceAttributesLike(NonResourceAttributes item) {
    return new NonResourceAttributesNested(item);
  }
  
  public NonResourceAttributesNested<A> editNonResourceAttributes() {
    return withNewNonResourceAttributesLike(java.util.Optional.ofNullable(buildNonResourceAttributes()).orElse(null));
  }
  
  public NonResourceAttributesNested<A> editOrNewNonResourceAttributes() {
    return withNewNonResourceAttributesLike(java.util.Optional.ofNullable(buildNonResourceAttributes()).orElse(new NonResourceAttributesBuilder().build()));
  }
  
  public NonResourceAttributesNested<A> editOrNewNonResourceAttributesLike(NonResourceAttributes item) {
    return withNewNonResourceAttributesLike(java.util.Optional.ofNullable(buildNonResourceAttributes()).orElse(item));
  }
  
  public ResourceAttributes buildResourceAttributes() {
    return this.resourceAttributes != null ? this.resourceAttributes.build() : null;
  }
  
  public A withResourceAttributes(ResourceAttributes resourceAttributes) {
    this._visitables.remove("resourceAttributes");
    if (resourceAttributes != null) {
        this.resourceAttributes = new ResourceAttributesBuilder(resourceAttributes);
        this._visitables.get("resourceAttributes").add(this.resourceAttributes);
    } else {
        this.resourceAttributes = null;
        this._visitables.get("resourceAttributes").remove(this.resourceAttributes);
    }
    return (A) this;
  }
  
  public boolean hasResourceAttributes() {
    return this.resourceAttributes != null;
  }
  
  public ResourceAttributesNested<A> withNewResourceAttributes() {
    return new ResourceAttributesNested(null);
  }
  
  public ResourceAttributesNested<A> withNewResourceAttributesLike(ResourceAttributes item) {
    return new ResourceAttributesNested(item);
  }
  
  public ResourceAttributesNested<A> editResourceAttributes() {
    return withNewResourceAttributesLike(java.util.Optional.ofNullable(buildResourceAttributes()).orElse(null));
  }
  
  public ResourceAttributesNested<A> editOrNewResourceAttributes() {
    return withNewResourceAttributesLike(java.util.Optional.ofNullable(buildResourceAttributes()).orElse(new ResourceAttributesBuilder().build()));
  }
  
  public ResourceAttributesNested<A> editOrNewResourceAttributesLike(ResourceAttributes item) {
    return withNewResourceAttributesLike(java.util.Optional.ofNullable(buildResourceAttributes()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SelfSubjectAccessReviewSpecFluent that = (SelfSubjectAccessReviewSpecFluent) o;
    if (!java.util.Objects.equals(nonResourceAttributes, that.nonResourceAttributes)) return false;
    if (!java.util.Objects.equals(resourceAttributes, that.resourceAttributes)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(nonResourceAttributes,  resourceAttributes,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (nonResourceAttributes != null) { sb.append("nonResourceAttributes:"); sb.append(nonResourceAttributes + ","); }
    if (resourceAttributes != null) { sb.append("resourceAttributes:"); sb.append(resourceAttributes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class NonResourceAttributesNested<N> extends NonResourceAttributesFluent<NonResourceAttributesNested<N>> implements Nested<N>{
    NonResourceAttributesNested(NonResourceAttributes item) {
      this.builder = new NonResourceAttributesBuilder(this, item);
    }
    NonResourceAttributesBuilder builder;
    
    public N and() {
      return (N) SelfSubjectAccessReviewSpecFluent.this.withNonResourceAttributes(builder.build());
    }
    
    public N endNonResourceAttributes() {
      return and();
    }
    
  
  }
  public class ResourceAttributesNested<N> extends ResourceAttributesFluent<ResourceAttributesNested<N>> implements Nested<N>{
    ResourceAttributesNested(ResourceAttributes item) {
      this.builder = new ResourceAttributesBuilder(this, item);
    }
    ResourceAttributesBuilder builder;
    
    public N and() {
      return (N) SelfSubjectAccessReviewSpecFluent.this.withResourceAttributes(builder.build());
    }
    
    public N endResourceAttributes() {
      return and();
    }
    
  
  }

}