/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.admissionregistration.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.RuleWithOperations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RuleWithOperationsFluent<A extends RuleWithOperationsFluent<A>>
extends BaseFluent<A> {
    private List<String> apiGroups = new ArrayList<String>();
    private List<String> apiVersions = new ArrayList<String>();
    private List<String> operations = new ArrayList<String>();
    private List<String> resources = new ArrayList<String>();
    private String scope;
    private Map<String, Object> additionalProperties;

    public RuleWithOperationsFluent() {
    }

    public RuleWithOperationsFluent(RuleWithOperations instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RuleWithOperations instance) {
        RuleWithOperations ruleWithOperations = instance = instance != null ? instance : new RuleWithOperations();
        if (instance != null) {
            this.withApiGroups(instance.getApiGroups());
            this.withApiVersions(instance.getApiVersions());
            this.withOperations(instance.getOperations());
            this.withResources(instance.getResources());
            this.withScope(instance.getScope());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToApiGroups(int index, String item) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        this.apiGroups.add(index, item);
        return (A)((Object)this);
    }

    public A setToApiGroups(int index, String item) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        this.apiGroups.set(index, item);
        return (A)((Object)this);
    }

    public A addToApiGroups(String ... items) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiGroups.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToApiGroups(Collection<String> items) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiGroups.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromApiGroups(String ... items) {
        if (this.apiGroups == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.apiGroups.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromApiGroups(Collection<String> items) {
        if (this.apiGroups == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.apiGroups.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getApiGroups() {
        return this.apiGroups;
    }

    public String getApiGroup(int index) {
        return this.apiGroups.get(index);
    }

    public String getFirstApiGroup() {
        return this.apiGroups.get(0);
    }

    public String getLastApiGroup() {
        return this.apiGroups.get(this.apiGroups.size() - 1);
    }

    public String getMatchingApiGroup(Predicate<String> predicate) {
        for (String item : this.apiGroups) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingApiGroup(Predicate<String> predicate) {
        for (String item : this.apiGroups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withApiGroups(List<String> apiGroups) {
        if (apiGroups != null) {
            this.apiGroups = new ArrayList<String>();
            for (String item : apiGroups) {
                this.addToApiGroups(item);
            }
        } else {
            this.apiGroups = null;
        }
        return (A)((Object)this);
    }

    public A withApiGroups(String ... apiGroups) {
        if (this.apiGroups != null) {
            this.apiGroups.clear();
            this._visitables.remove((Object)"apiGroups");
        }
        if (apiGroups != null) {
            for (String item : apiGroups) {
                this.addToApiGroups(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasApiGroups() {
        return this.apiGroups != null && !this.apiGroups.isEmpty();
    }

    public A addToApiVersions(int index, String item) {
        if (this.apiVersions == null) {
            this.apiVersions = new ArrayList<String>();
        }
        this.apiVersions.add(index, item);
        return (A)((Object)this);
    }

    public A setToApiVersions(int index, String item) {
        if (this.apiVersions == null) {
            this.apiVersions = new ArrayList<String>();
        }
        this.apiVersions.set(index, item);
        return (A)((Object)this);
    }

    public A addToApiVersions(String ... items) {
        if (this.apiVersions == null) {
            this.apiVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiVersions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToApiVersions(Collection<String> items) {
        if (this.apiVersions == null) {
            this.apiVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiVersions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromApiVersions(String ... items) {
        if (this.apiVersions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.apiVersions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromApiVersions(Collection<String> items) {
        if (this.apiVersions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.apiVersions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getApiVersions() {
        return this.apiVersions;
    }

    public String getApiVersion(int index) {
        return this.apiVersions.get(index);
    }

    public String getFirstApiVersion() {
        return this.apiVersions.get(0);
    }

    public String getLastApiVersion() {
        return this.apiVersions.get(this.apiVersions.size() - 1);
    }

    public String getMatchingApiVersion(Predicate<String> predicate) {
        for (String item : this.apiVersions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingApiVersion(Predicate<String> predicate) {
        for (String item : this.apiVersions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withApiVersions(List<String> apiVersions) {
        if (apiVersions != null) {
            this.apiVersions = new ArrayList<String>();
            for (String item : apiVersions) {
                this.addToApiVersions(item);
            }
        } else {
            this.apiVersions = null;
        }
        return (A)((Object)this);
    }

    public A withApiVersions(String ... apiVersions) {
        if (this.apiVersions != null) {
            this.apiVersions.clear();
            this._visitables.remove((Object)"apiVersions");
        }
        if (apiVersions != null) {
            for (String item : apiVersions) {
                this.addToApiVersions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasApiVersions() {
        return this.apiVersions != null && !this.apiVersions.isEmpty();
    }

    public A addToOperations(int index, String item) {
        if (this.operations == null) {
            this.operations = new ArrayList<String>();
        }
        this.operations.add(index, item);
        return (A)((Object)this);
    }

    public A setToOperations(int index, String item) {
        if (this.operations == null) {
            this.operations = new ArrayList<String>();
        }
        this.operations.set(index, item);
        return (A)((Object)this);
    }

    public A addToOperations(String ... items) {
        if (this.operations == null) {
            this.operations = new ArrayList<String>();
        }
        for (String item : items) {
            this.operations.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToOperations(Collection<String> items) {
        if (this.operations == null) {
            this.operations = new ArrayList<String>();
        }
        for (String item : items) {
            this.operations.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromOperations(String ... items) {
        if (this.operations == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.operations.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOperations(Collection<String> items) {
        if (this.operations == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.operations.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getOperations() {
        return this.operations;
    }

    public String getOperation(int index) {
        return this.operations.get(index);
    }

    public String getFirstOperation() {
        return this.operations.get(0);
    }

    public String getLastOperation() {
        return this.operations.get(this.operations.size() - 1);
    }

    public String getMatchingOperation(Predicate<String> predicate) {
        for (String item : this.operations) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingOperation(Predicate<String> predicate) {
        for (String item : this.operations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOperations(List<String> operations) {
        if (operations != null) {
            this.operations = new ArrayList<String>();
            for (String item : operations) {
                this.addToOperations(item);
            }
        } else {
            this.operations = null;
        }
        return (A)((Object)this);
    }

    public A withOperations(String ... operations) {
        if (this.operations != null) {
            this.operations.clear();
            this._visitables.remove((Object)"operations");
        }
        if (operations != null) {
            for (String item : operations) {
                this.addToOperations(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasOperations() {
        return this.operations != null && !this.operations.isEmpty();
    }

    public A addToResources(int index, String item) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(index, item);
        return (A)((Object)this);
    }

    public A setToResources(int index, String item) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.set(index, item);
        return (A)((Object)this);
    }

    public A addToResources(String ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        for (String item : items) {
            this.resources.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToResources(Collection<String> items) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        for (String item : items) {
            this.resources.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromResources(String ... items) {
        if (this.resources == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.resources.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromResources(Collection<String> items) {
        if (this.resources == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.resources.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getResources() {
        return this.resources;
    }

    public String getResource(int index) {
        return this.resources.get(index);
    }

    public String getFirstResource() {
        return this.resources.get(0);
    }

    public String getLastResource() {
        return this.resources.get(this.resources.size() - 1);
    }

    public String getMatchingResource(Predicate<String> predicate) {
        for (String item : this.resources) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingResource(Predicate<String> predicate) {
        for (String item : this.resources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResources(List<String> resources) {
        if (resources != null) {
            this.resources = new ArrayList<String>();
            for (String item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)((Object)this);
    }

    public A withResources(String ... resources) {
        if (this.resources != null) {
            this.resources.clear();
            this._visitables.remove((Object)"resources");
        }
        if (resources != null) {
            for (String item : resources) {
                this.addToResources(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    public String getScope() {
        return this.scope;
    }

    public A withScope(String scope) {
        this.scope = scope;
        return (A)((Object)this);
    }

    public boolean hasScope() {
        return this.scope != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RuleWithOperationsFluent that = (RuleWithOperationsFluent)((Object)o);
        if (!Objects.equals(this.apiGroups, that.apiGroups)) {
            return false;
        }
        if (!Objects.equals(this.apiVersions, that.apiVersions)) {
            return false;
        }
        if (!Objects.equals(this.operations, that.operations)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals(this.scope, that.scope)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apiGroups, this.apiVersions, this.operations, this.resources, this.scope, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiGroups != null && !this.apiGroups.isEmpty()) {
            sb.append("apiGroups:");
            sb.append(this.apiGroups + ",");
        }
        if (this.apiVersions != null && !this.apiVersions.isEmpty()) {
            sb.append("apiVersions:");
            sb.append(this.apiVersions + ",");
        }
        if (this.operations != null && !this.operations.isEmpty()) {
            sb.append("operations:");
            sb.append(this.operations + ",");
        }
        if (this.resources != null && !this.resources.isEmpty()) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.scope != null) {
            sb.append("scope:");
            sb.append(this.scope + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

