package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DeploymentStatusBuilder extends DeploymentStatusFluent<DeploymentStatusBuilder> implements VisitableBuilder<DeploymentStatus,DeploymentStatusBuilder>{
  public DeploymentStatusBuilder() {
    this(new DeploymentStatus());
  }
  
  public DeploymentStatusBuilder(DeploymentStatusFluent<?> fluent) {
    this(fluent, new DeploymentStatus());
  }
  
  public DeploymentStatusBuilder(DeploymentStatusFluent<?> fluent,DeploymentStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DeploymentStatusBuilder(DeploymentStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DeploymentStatusFluent<?> fluent;
  
  public DeploymentStatus build() {
    DeploymentStatus buildable = new DeploymentStatus(fluent.getAvailableReplicas(),fluent.getCollisionCount(),fluent.buildConditions(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getReplicas(),fluent.getUnavailableReplicas(),fluent.getUpdatedReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}