/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.batch.v1.PodFailurePolicy;
import io.fabric8.kubernetes.api.model.batch.v1.PodFailurePolicyRule;
import io.fabric8.kubernetes.api.model.batch.v1.PodFailurePolicyRuleBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.PodFailurePolicyRuleFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PodFailurePolicyFluent<A extends PodFailurePolicyFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<PodFailurePolicyRuleBuilder> rules = new ArrayList();

    public PodFailurePolicyFluent() {
    }

    public PodFailurePolicyFluent(PodFailurePolicy instance) {
        this.copyInstance(instance);
    }

    public A addAllToRules(Collection<PodFailurePolicyRule> items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (PodFailurePolicyRule item : items) {
            PodFailurePolicyRuleBuilder builder = new PodFailurePolicyRuleBuilder(item);
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        }
        return (A)((Object)this);
    }

    public RulesNested<A> addNewRule() {
        return new RulesNested(-1, null);
    }

    public RulesNested<A> addNewRuleLike(PodFailurePolicyRule item) {
        return new RulesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToRules(PodFailurePolicyRule ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (PodFailurePolicyRule item : items) {
            PodFailurePolicyRuleBuilder builder = new PodFailurePolicyRuleBuilder(item);
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToRules(int index, PodFailurePolicyRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        PodFailurePolicyRuleBuilder builder = new PodFailurePolicyRuleBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(index, builder);
        }
        return (A)((Object)this);
    }

    public PodFailurePolicyRule buildFirstRule() {
        return this.rules.get(0).build();
    }

    public PodFailurePolicyRule buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    public PodFailurePolicyRule buildMatchingRule(Predicate<PodFailurePolicyRuleBuilder> predicate) {
        for (PodFailurePolicyRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public PodFailurePolicyRule buildRule(int index) {
        return this.rules.get(index).build();
    }

    public List<PodFailurePolicyRule> buildRules() {
        return this.rules != null ? PodFailurePolicyFluent.build(this.rules) : null;
    }

    protected void copyInstance(PodFailurePolicy instance) {
        PodFailurePolicy podFailurePolicy = instance = instance != null ? instance : new PodFailurePolicy();
        if (instance != null) {
            this.withRules(instance.getRules());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "rules"));
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    public RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "rules"));
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public RulesNested<A> editMatchingRule(Predicate<PodFailurePolicyRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.test(this.rules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "rules"));
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public RulesNested<A> editRule(int index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "rules"));
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodFailurePolicyFluent that = (PodFailurePolicyFluent)((Object)o);
        if (!Objects.equals(this.rules, that.rules)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMatchingRule(Predicate<PodFailurePolicyRuleBuilder> predicate) {
        for (PodFailurePolicyRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.rules, this.additionalProperties);
    }

    public A removeAllFromRules(Collection<PodFailurePolicyRule> items) {
        if (this.rules == null) {
            return (A)((Object)this);
        }
        for (PodFailurePolicyRule item : items) {
            PodFailurePolicyRuleBuilder builder = new PodFailurePolicyRuleBuilder(item);
            this._visitables.get((Object)"rules").remove((Object)builder);
            this.rules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromRules(PodFailurePolicyRule ... items) {
        if (this.rules == null) {
            return (A)((Object)this);
        }
        for (PodFailurePolicyRule item : items) {
            PodFailurePolicyRuleBuilder builder = new PodFailurePolicyRuleBuilder(item);
            this._visitables.get((Object)"rules").remove((Object)builder);
            this.rules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRules(Predicate<PodFailurePolicyRuleBuilder> predicate) {
        if (this.rules == null) {
            return (A)((Object)this);
        }
        Iterator<PodFailurePolicyRuleBuilder> each = this.rules.iterator();
        List visitables = this._visitables.get((Object)"rules");
        while (each.hasNext()) {
            PodFailurePolicyRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public RulesNested<A> setNewRuleLike(int index, PodFailurePolicyRule item) {
        return new RulesNested(index, item);
    }

    public A setToRules(int index, PodFailurePolicyRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        PodFailurePolicyRuleBuilder builder = new PodFailurePolicyRuleBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get((Object)"rules").add(builder);
            this.rules.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.rules != null && !this.rules.isEmpty()) {
            sb.append("rules:");
            sb.append(this.rules);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withRules(List<PodFailurePolicyRule> rules) {
        if (this.rules != null) {
            this._visitables.get((Object)"rules").clear();
        }
        if (rules != null) {
            this.rules = new ArrayList();
            for (PodFailurePolicyRule item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)((Object)this);
    }

    public A withRules(PodFailurePolicyRule ... rules) {
        if (this.rules != null) {
            this.rules.clear();
            this._visitables.remove((Object)"rules");
        }
        if (rules != null) {
            for (PodFailurePolicyRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)((Object)this);
    }

    public class RulesNested<N>
    extends PodFailurePolicyRuleFluent<RulesNested<N>>
    implements Nested<N> {
        PodFailurePolicyRuleBuilder builder;
        int index;

        RulesNested(int index, PodFailurePolicyRule item) {
            this.index = index;
            this.builder = new PodFailurePolicyRuleBuilder(this, item);
        }

        public N and() {
            return (N)PodFailurePolicyFluent.this.setToRules(this.index, this.builder.build());
        }

        public N endRule() {
            return this.and();
        }
    }
}

