/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.flowcontrol.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.flowcontrol.v1.ExemptPriorityLevelConfiguration;
import io.fabric8.kubernetes.api.model.flowcontrol.v1.ExemptPriorityLevelConfigurationBuilder;
import io.fabric8.kubernetes.api.model.flowcontrol.v1.ExemptPriorityLevelConfigurationFluent;
import io.fabric8.kubernetes.api.model.flowcontrol.v1.LimitedPriorityLevelConfiguration;
import io.fabric8.kubernetes.api.model.flowcontrol.v1.LimitedPriorityLevelConfigurationBuilder;
import io.fabric8.kubernetes.api.model.flowcontrol.v1.LimitedPriorityLevelConfigurationFluent;
import io.fabric8.kubernetes.api.model.flowcontrol.v1.PriorityLevelConfigurationSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PriorityLevelConfigurationSpecFluent<A extends PriorityLevelConfigurationSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ExemptPriorityLevelConfigurationBuilder exempt;
    private LimitedPriorityLevelConfigurationBuilder limited;
    private String type;

    public PriorityLevelConfigurationSpecFluent() {
    }

    public PriorityLevelConfigurationSpecFluent(PriorityLevelConfigurationSpec instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public ExemptPriorityLevelConfiguration buildExempt() {
        return this.exempt != null ? this.exempt.build() : null;
    }

    public LimitedPriorityLevelConfiguration buildLimited() {
        return this.limited != null ? this.limited.build() : null;
    }

    protected void copyInstance(PriorityLevelConfigurationSpec instance) {
        PriorityLevelConfigurationSpec priorityLevelConfigurationSpec = instance = instance != null ? instance : new PriorityLevelConfigurationSpec();
        if (instance != null) {
            this.withExempt(instance.getExempt());
            this.withLimited(instance.getLimited());
            this.withType(instance.getType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ExemptNested<A> editExempt() {
        return this.withNewExemptLike(Optional.ofNullable(this.buildExempt()).orElse(null));
    }

    public LimitedNested<A> editLimited() {
        return this.withNewLimitedLike(Optional.ofNullable(this.buildLimited()).orElse(null));
    }

    public ExemptNested<A> editOrNewExempt() {
        return this.withNewExemptLike(Optional.ofNullable(this.buildExempt()).orElse(new ExemptPriorityLevelConfigurationBuilder().build()));
    }

    public ExemptNested<A> editOrNewExemptLike(ExemptPriorityLevelConfiguration item) {
        return this.withNewExemptLike(Optional.ofNullable(this.buildExempt()).orElse(item));
    }

    public LimitedNested<A> editOrNewLimited() {
        return this.withNewLimitedLike(Optional.ofNullable(this.buildLimited()).orElse(new LimitedPriorityLevelConfigurationBuilder().build()));
    }

    public LimitedNested<A> editOrNewLimitedLike(LimitedPriorityLevelConfiguration item) {
        return this.withNewLimitedLike(Optional.ofNullable(this.buildLimited()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PriorityLevelConfigurationSpecFluent that = (PriorityLevelConfigurationSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.exempt, (Object)that.exempt)) {
            return false;
        }
        if (!Objects.equals((Object)this.limited, (Object)that.limited)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getType() {
        return this.type;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasExempt() {
        return this.exempt != null;
    }

    public boolean hasLimited() {
        return this.limited != null;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.exempt, this.limited, this.type, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.exempt != null) {
            sb.append("exempt:");
            sb.append((Object)this.exempt);
            sb.append(",");
        }
        if (this.limited != null) {
            sb.append("limited:");
            sb.append((Object)this.limited);
            sb.append(",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withExempt(ExemptPriorityLevelConfiguration exempt) {
        this._visitables.remove((Object)"exempt");
        if (exempt != null) {
            this.exempt = new ExemptPriorityLevelConfigurationBuilder(exempt);
            this._visitables.get((Object)"exempt").add(this.exempt);
        } else {
            this.exempt = null;
            this._visitables.get((Object)"exempt").remove((Object)this.exempt);
        }
        return (A)((Object)this);
    }

    public A withLimited(LimitedPriorityLevelConfiguration limited) {
        this._visitables.remove((Object)"limited");
        if (limited != null) {
            this.limited = new LimitedPriorityLevelConfigurationBuilder(limited);
            this._visitables.get((Object)"limited").add(this.limited);
        } else {
            this.limited = null;
            this._visitables.get((Object)"limited").remove((Object)this.limited);
        }
        return (A)((Object)this);
    }

    public ExemptNested<A> withNewExempt() {
        return new ExemptNested(null);
    }

    public A withNewExempt(Integer lendablePercent, Integer nominalConcurrencyShares) {
        return this.withExempt(new ExemptPriorityLevelConfiguration(lendablePercent, nominalConcurrencyShares));
    }

    public ExemptNested<A> withNewExemptLike(ExemptPriorityLevelConfiguration item) {
        return new ExemptNested(item);
    }

    public LimitedNested<A> withNewLimited() {
        return new LimitedNested(null);
    }

    public LimitedNested<A> withNewLimitedLike(LimitedPriorityLevelConfiguration item) {
        return new LimitedNested(item);
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public class LimitedNested<N>
    extends LimitedPriorityLevelConfigurationFluent<LimitedNested<N>>
    implements Nested<N> {
        LimitedPriorityLevelConfigurationBuilder builder;

        LimitedNested(LimitedPriorityLevelConfiguration item) {
            this.builder = new LimitedPriorityLevelConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)PriorityLevelConfigurationSpecFluent.this.withLimited(this.builder.build());
        }

        public N endLimited() {
            return this.and();
        }
    }

    public class ExemptNested<N>
    extends ExemptPriorityLevelConfigurationFluent<ExemptNested<N>>
    implements Nested<N> {
        ExemptPriorityLevelConfigurationBuilder builder;

        ExemptNested(ExemptPriorityLevelConfiguration item) {
            this.builder = new ExemptPriorityLevelConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)PriorityLevelConfigurationSpecFluent.this.withExempt(this.builder.build());
        }

        public N endExempt() {
            return this.and();
        }
    }
}

