package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.ParentReference;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.ParentReferenceBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.ParentReferenceFluent;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PolicyAncestorStatusFluent<A extends PolicyAncestorStatusFluent<A>> extends BaseFluent<A>{
  public PolicyAncestorStatusFluent() {
  }
  
  public PolicyAncestorStatusFluent(PolicyAncestorStatus instance) {
    this.copyInstance(instance);
  }
  private ParentReferenceBuilder ancestorRef;
  private List<Condition> conditions = new ArrayList<Condition>();
  private String controllerName;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PolicyAncestorStatus instance) {
    instance = (instance != null ? instance : new PolicyAncestorStatus());
    if (instance != null) {
          this.withAncestorRef(instance.getAncestorRef());
          this.withConditions(instance.getConditions());
          this.withControllerName(instance.getControllerName());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ParentReference buildAncestorRef() {
    return this.ancestorRef != null ? this.ancestorRef.build() : null;
  }
  
  public A withAncestorRef(ParentReference ancestorRef) {
    this._visitables.remove("ancestorRef");
    if (ancestorRef != null) {
        this.ancestorRef = new ParentReferenceBuilder(ancestorRef);
        this._visitables.get("ancestorRef").add(this.ancestorRef);
    } else {
        this.ancestorRef = null;
        this._visitables.get("ancestorRef").remove(this.ancestorRef);
    }
    return (A) this;
  }
  
  public boolean hasAncestorRef() {
    return this.ancestorRef != null;
  }
  
  public AncestorRefNested<A> withNewAncestorRef() {
    return new AncestorRefNested(null);
  }
  
  public AncestorRefNested<A> withNewAncestorRefLike(ParentReference item) {
    return new AncestorRefNested(item);
  }
  
  public AncestorRefNested<A> editAncestorRef() {
    return withNewAncestorRefLike(java.util.Optional.ofNullable(buildAncestorRef()).orElse(null));
  }
  
  public AncestorRefNested<A> editOrNewAncestorRef() {
    return withNewAncestorRefLike(java.util.Optional.ofNullable(buildAncestorRef()).orElse(new ParentReferenceBuilder().build()));
  }
  
  public AncestorRefNested<A> editOrNewAncestorRefLike(ParentReference item) {
    return withNewAncestorRefLike(java.util.Optional.ofNullable(buildAncestorRef()).orElse(item));
  }
  
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<Condition> items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public List<Condition> getConditions() {
    return this.conditions;
  }
  
  public Condition getCondition(int index) {
    return this.conditions.get(index);
  }
  
  public Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  
  public Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  
  public Condition getMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<Condition> conditions) {
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (Condition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (Condition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public String getControllerName() {
    return this.controllerName;
  }
  
  public A withControllerName(String controllerName) {
    this.controllerName = controllerName;
    return (A) this;
  }
  
  public boolean hasControllerName() {
    return this.controllerName != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PolicyAncestorStatusFluent that = (PolicyAncestorStatusFluent) o;
    if (!java.util.Objects.equals(ancestorRef, that.ancestorRef)) return false;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(controllerName, that.controllerName)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(ancestorRef,  conditions,  controllerName,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ancestorRef != null) { sb.append("ancestorRef:"); sb.append(ancestorRef + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (controllerName != null) { sb.append("controllerName:"); sb.append(controllerName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AncestorRefNested<N> extends ParentReferenceFluent<AncestorRefNested<N>> implements Nested<N>{
    AncestorRefNested(ParentReference item) {
      this.builder = new ParentReferenceBuilder(this, item);
    }
    ParentReferenceBuilder builder;
    
    public N and() {
      return (N) PolicyAncestorStatusFluent.this.withAncestorRef(builder.build());
    }
    
    public N endAncestorRef() {
      return and();
    }
    
  
  }

}