/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.resource.v1.DeviceRequestAllocationResult;
import io.fabric8.kubernetes.api.model.resource.v1.DeviceToleration;
import io.fabric8.kubernetes.api.model.resource.v1.DeviceTolerationBuilder;
import io.fabric8.kubernetes.api.model.resource.v1.DeviceTolerationFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DeviceRequestAllocationResultFluent<A extends DeviceRequestAllocationResultFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Boolean adminAccess;
    private List<String> bindingConditions = new ArrayList<String>();
    private List<String> bindingFailureConditions = new ArrayList<String>();
    private Map<String, Quantity> consumedCapacity;
    private String device;
    private String driver;
    private String pool;
    private String request;
    private String shareID;
    private ArrayList<DeviceTolerationBuilder> tolerations = new ArrayList();

    public DeviceRequestAllocationResultFluent() {
    }

    public DeviceRequestAllocationResultFluent(DeviceRequestAllocationResult instance) {
        this.copyInstance(instance);
    }

    public A addAllToBindingConditions(Collection<String> items) {
        if (this.bindingConditions == null) {
            this.bindingConditions = new ArrayList<String>();
        }
        for (String item : items) {
            this.bindingConditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToBindingFailureConditions(Collection<String> items) {
        if (this.bindingFailureConditions == null) {
            this.bindingFailureConditions = new ArrayList<String>();
        }
        for (String item : items) {
            this.bindingFailureConditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTolerations(Collection<DeviceToleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        for (DeviceToleration item : items) {
            DeviceTolerationBuilder builder = new DeviceTolerationBuilder(item);
            this._visitables.get((Object)"tolerations").add(builder);
            this.tolerations.add(builder);
        }
        return (A)((Object)this);
    }

    public TolerationsNested<A> addNewToleration() {
        return new TolerationsNested(-1, null);
    }

    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new DeviceToleration(effect, key, operator, tolerationSeconds, value));
    }

    public TolerationsNested<A> addNewTolerationLike(DeviceToleration item) {
        return new TolerationsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToBindingConditions(String ... items) {
        if (this.bindingConditions == null) {
            this.bindingConditions = new ArrayList<String>();
        }
        for (String item : items) {
            this.bindingConditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addToBindingConditions(int index, String item) {
        if (this.bindingConditions == null) {
            this.bindingConditions = new ArrayList<String>();
        }
        this.bindingConditions.add(index, item);
        return (A)((Object)this);
    }

    public A addToBindingFailureConditions(String ... items) {
        if (this.bindingFailureConditions == null) {
            this.bindingFailureConditions = new ArrayList<String>();
        }
        for (String item : items) {
            this.bindingFailureConditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addToBindingFailureConditions(int index, String item) {
        if (this.bindingFailureConditions == null) {
            this.bindingFailureConditions = new ArrayList<String>();
        }
        this.bindingFailureConditions.add(index, item);
        return (A)((Object)this);
    }

    public A addToConsumedCapacity(Map<String, Quantity> map) {
        if (this.consumedCapacity == null && map != null) {
            this.consumedCapacity = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.consumedCapacity.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToConsumedCapacity(String key, Quantity value) {
        if (this.consumedCapacity == null && key != null && value != null) {
            this.consumedCapacity = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.consumedCapacity.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToTolerations(DeviceToleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        for (DeviceToleration item : items) {
            DeviceTolerationBuilder builder = new DeviceTolerationBuilder(item);
            this._visitables.get((Object)"tolerations").add(builder);
            this.tolerations.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToTolerations(int index, DeviceToleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        DeviceTolerationBuilder builder = new DeviceTolerationBuilder(item);
        if (index < 0 || index >= this.tolerations.size()) {
            this._visitables.get((Object)"tolerations").add(builder);
            this.tolerations.add(builder);
        } else {
            this._visitables.get((Object)"tolerations").add(builder);
            this.tolerations.add(index, builder);
        }
        return (A)((Object)this);
    }

    public DeviceToleration buildFirstToleration() {
        return this.tolerations.get(0).build();
    }

    public DeviceToleration buildLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1).build();
    }

    public DeviceToleration buildMatchingToleration(Predicate<DeviceTolerationBuilder> predicate) {
        for (DeviceTolerationBuilder item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public DeviceToleration buildToleration(int index) {
        return this.tolerations.get(index).build();
    }

    public List<DeviceToleration> buildTolerations() {
        return this.tolerations != null ? DeviceRequestAllocationResultFluent.build(this.tolerations) : null;
    }

    protected void copyInstance(DeviceRequestAllocationResult instance) {
        DeviceRequestAllocationResult deviceRequestAllocationResult = instance = instance != null ? instance : new DeviceRequestAllocationResult();
        if (instance != null) {
            this.withAdminAccess(instance.getAdminAccess());
            this.withBindingConditions(instance.getBindingConditions());
            this.withBindingFailureConditions(instance.getBindingFailureConditions());
            this.withConsumedCapacity(instance.getConsumedCapacity());
            this.withDevice(instance.getDevice());
            this.withDriver(instance.getDriver());
            this.withPool(instance.getPool());
            this.withRequest(instance.getRequest());
            this.withShareID(instance.getShareID());
            this.withTolerations(instance.getTolerations());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public TolerationsNested<A> editFirstToleration() {
        if (this.tolerations.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "tolerations"));
        }
        return this.setNewTolerationLike(0, this.buildToleration(0));
    }

    public TolerationsNested<A> editLastToleration() {
        int index = this.tolerations.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "tolerations"));
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    public TolerationsNested<A> editMatchingToleration(Predicate<DeviceTolerationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tolerations.size(); ++i) {
            if (!predicate.test(this.tolerations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "tolerations"));
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    public TolerationsNested<A> editToleration(int index) {
        if (this.tolerations.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "tolerations"));
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeviceRequestAllocationResultFluent that = (DeviceRequestAllocationResultFluent)((Object)o);
        if (!Objects.equals(this.adminAccess, that.adminAccess)) {
            return false;
        }
        if (!Objects.equals(this.bindingConditions, that.bindingConditions)) {
            return false;
        }
        if (!Objects.equals(this.bindingFailureConditions, that.bindingFailureConditions)) {
            return false;
        }
        if (!Objects.equals(this.consumedCapacity, that.consumedCapacity)) {
            return false;
        }
        if (!Objects.equals(this.device, that.device)) {
            return false;
        }
        if (!Objects.equals(this.driver, that.driver)) {
            return false;
        }
        if (!Objects.equals(this.pool, that.pool)) {
            return false;
        }
        if (!Objects.equals(this.request, that.request)) {
            return false;
        }
        if (!Objects.equals(this.shareID, that.shareID)) {
            return false;
        }
        if (!Objects.equals(this.tolerations, that.tolerations)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Boolean getAdminAccess() {
        return this.adminAccess;
    }

    public String getBindingCondition(int index) {
        return this.bindingConditions.get(index);
    }

    public List<String> getBindingConditions() {
        return this.bindingConditions;
    }

    public String getBindingFailureCondition(int index) {
        return this.bindingFailureConditions.get(index);
    }

    public List<String> getBindingFailureConditions() {
        return this.bindingFailureConditions;
    }

    public Map<String, Quantity> getConsumedCapacity() {
        return this.consumedCapacity;
    }

    public String getDevice() {
        return this.device;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getFirstBindingCondition() {
        return this.bindingConditions.get(0);
    }

    public String getFirstBindingFailureCondition() {
        return this.bindingFailureConditions.get(0);
    }

    public String getLastBindingCondition() {
        return this.bindingConditions.get(this.bindingConditions.size() - 1);
    }

    public String getLastBindingFailureCondition() {
        return this.bindingFailureConditions.get(this.bindingFailureConditions.size() - 1);
    }

    public String getMatchingBindingCondition(Predicate<String> predicate) {
        for (String item : this.bindingConditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getMatchingBindingFailureCondition(Predicate<String> predicate) {
        for (String item : this.bindingFailureConditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getPool() {
        return this.pool;
    }

    public String getRequest() {
        return this.request;
    }

    public String getShareID() {
        return this.shareID;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAdminAccess() {
        return this.adminAccess != null;
    }

    public boolean hasBindingConditions() {
        return this.bindingConditions != null && !this.bindingConditions.isEmpty();
    }

    public boolean hasBindingFailureConditions() {
        return this.bindingFailureConditions != null && !this.bindingFailureConditions.isEmpty();
    }

    public boolean hasConsumedCapacity() {
        return this.consumedCapacity != null;
    }

    public boolean hasDevice() {
        return this.device != null;
    }

    public boolean hasDriver() {
        return this.driver != null;
    }

    public boolean hasMatchingBindingCondition(Predicate<String> predicate) {
        for (String item : this.bindingConditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingBindingFailureCondition(Predicate<String> predicate) {
        for (String item : this.bindingFailureConditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingToleration(Predicate<DeviceTolerationBuilder> predicate) {
        for (DeviceTolerationBuilder item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPool() {
        return this.pool != null;
    }

    public boolean hasRequest() {
        return this.request != null;
    }

    public boolean hasShareID() {
        return this.shareID != null;
    }

    public boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.adminAccess, this.bindingConditions, this.bindingFailureConditions, this.consumedCapacity, this.device, this.driver, this.pool, this.request, this.shareID, this.tolerations, this.additionalProperties);
    }

    public A removeAllFromBindingConditions(Collection<String> items) {
        if (this.bindingConditions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.bindingConditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBindingFailureConditions(Collection<String> items) {
        if (this.bindingFailureConditions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.bindingFailureConditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTolerations(Collection<DeviceToleration> items) {
        if (this.tolerations == null) {
            return (A)((Object)this);
        }
        for (DeviceToleration item : items) {
            DeviceTolerationBuilder builder = new DeviceTolerationBuilder(item);
            this._visitables.get((Object)"tolerations").remove((Object)builder);
            this.tolerations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromBindingConditions(String ... items) {
        if (this.bindingConditions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.bindingConditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromBindingFailureConditions(String ... items) {
        if (this.bindingFailureConditions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.bindingFailureConditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromConsumedCapacity(String key) {
        if (this.consumedCapacity == null) {
            return (A)((Object)this);
        }
        if (key != null && this.consumedCapacity != null) {
            this.consumedCapacity.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromConsumedCapacity(Map<String, Quantity> map) {
        if (this.consumedCapacity == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.consumedCapacity == null) continue;
                this.consumedCapacity.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromTolerations(DeviceToleration ... items) {
        if (this.tolerations == null) {
            return (A)((Object)this);
        }
        for (DeviceToleration item : items) {
            DeviceTolerationBuilder builder = new DeviceTolerationBuilder(item);
            this._visitables.get((Object)"tolerations").remove((Object)builder);
            this.tolerations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTolerations(Predicate<DeviceTolerationBuilder> predicate) {
        if (this.tolerations == null) {
            return (A)((Object)this);
        }
        Iterator<DeviceTolerationBuilder> each = this.tolerations.iterator();
        List visitables = this._visitables.get((Object)"tolerations");
        while (each.hasNext()) {
            DeviceTolerationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public TolerationsNested<A> setNewTolerationLike(int index, DeviceToleration item) {
        return new TolerationsNested(index, item);
    }

    public A setToBindingConditions(int index, String item) {
        if (this.bindingConditions == null) {
            this.bindingConditions = new ArrayList<String>();
        }
        this.bindingConditions.set(index, item);
        return (A)((Object)this);
    }

    public A setToBindingFailureConditions(int index, String item) {
        if (this.bindingFailureConditions == null) {
            this.bindingFailureConditions = new ArrayList<String>();
        }
        this.bindingFailureConditions.set(index, item);
        return (A)((Object)this);
    }

    public A setToTolerations(int index, DeviceToleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        DeviceTolerationBuilder builder = new DeviceTolerationBuilder(item);
        if (index < 0 || index >= this.tolerations.size()) {
            this._visitables.get((Object)"tolerations").add(builder);
            this.tolerations.add(builder);
        } else {
            this._visitables.get((Object)"tolerations").add(builder);
            this.tolerations.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.adminAccess != null) {
            sb.append("adminAccess:");
            sb.append(this.adminAccess);
            sb.append(",");
        }
        if (this.bindingConditions != null && !this.bindingConditions.isEmpty()) {
            sb.append("bindingConditions:");
            sb.append(this.bindingConditions);
            sb.append(",");
        }
        if (this.bindingFailureConditions != null && !this.bindingFailureConditions.isEmpty()) {
            sb.append("bindingFailureConditions:");
            sb.append(this.bindingFailureConditions);
            sb.append(",");
        }
        if (this.consumedCapacity != null && !this.consumedCapacity.isEmpty()) {
            sb.append("consumedCapacity:");
            sb.append(this.consumedCapacity);
            sb.append(",");
        }
        if (this.device != null) {
            sb.append("device:");
            sb.append(this.device);
            sb.append(",");
        }
        if (this.driver != null) {
            sb.append("driver:");
            sb.append(this.driver);
            sb.append(",");
        }
        if (this.pool != null) {
            sb.append("pool:");
            sb.append(this.pool);
            sb.append(",");
        }
        if (this.request != null) {
            sb.append("request:");
            sb.append(this.request);
            sb.append(",");
        }
        if (this.shareID != null) {
            sb.append("shareID:");
            sb.append(this.shareID);
            sb.append(",");
        }
        if (this.tolerations != null && !this.tolerations.isEmpty()) {
            sb.append("tolerations:");
            sb.append(this.tolerations);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAdminAccess() {
        return this.withAdminAccess(true);
    }

    public A withAdminAccess(Boolean adminAccess) {
        this.adminAccess = adminAccess;
        return (A)((Object)this);
    }

    public A withBindingConditions(List<String> bindingConditions) {
        if (bindingConditions != null) {
            this.bindingConditions = new ArrayList<String>();
            for (String item : bindingConditions) {
                this.addToBindingConditions(item);
            }
        } else {
            this.bindingConditions = null;
        }
        return (A)((Object)this);
    }

    public A withBindingConditions(String ... bindingConditions) {
        if (this.bindingConditions != null) {
            this.bindingConditions.clear();
            this._visitables.remove((Object)"bindingConditions");
        }
        if (bindingConditions != null) {
            for (String item : bindingConditions) {
                this.addToBindingConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public A withBindingFailureConditions(List<String> bindingFailureConditions) {
        if (bindingFailureConditions != null) {
            this.bindingFailureConditions = new ArrayList<String>();
            for (String item : bindingFailureConditions) {
                this.addToBindingFailureConditions(item);
            }
        } else {
            this.bindingFailureConditions = null;
        }
        return (A)((Object)this);
    }

    public A withBindingFailureConditions(String ... bindingFailureConditions) {
        if (this.bindingFailureConditions != null) {
            this.bindingFailureConditions.clear();
            this._visitables.remove((Object)"bindingFailureConditions");
        }
        if (bindingFailureConditions != null) {
            for (String item : bindingFailureConditions) {
                this.addToBindingFailureConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public <K, V> A withConsumedCapacity(Map<String, Quantity> consumedCapacity) {
        this.consumedCapacity = consumedCapacity == null ? null : new LinkedHashMap<String, Quantity>(consumedCapacity);
        return (A)((Object)this);
    }

    public A withDevice(String device) {
        this.device = device;
        return (A)((Object)this);
    }

    public A withDriver(String driver) {
        this.driver = driver;
        return (A)((Object)this);
    }

    public A withPool(String pool) {
        this.pool = pool;
        return (A)((Object)this);
    }

    public A withRequest(String request) {
        this.request = request;
        return (A)((Object)this);
    }

    public A withShareID(String shareID) {
        this.shareID = shareID;
        return (A)((Object)this);
    }

    public A withTolerations(List<DeviceToleration> tolerations) {
        if (this.tolerations != null) {
            this._visitables.get((Object)"tolerations").clear();
        }
        if (tolerations != null) {
            this.tolerations = new ArrayList();
            for (DeviceToleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)((Object)this);
    }

    public A withTolerations(DeviceToleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
            this._visitables.remove((Object)"tolerations");
        }
        if (tolerations != null) {
            for (DeviceToleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)((Object)this);
    }

    public class TolerationsNested<N>
    extends DeviceTolerationFluent<TolerationsNested<N>>
    implements Nested<N> {
        DeviceTolerationBuilder builder;
        int index;

        TolerationsNested(int index, DeviceToleration item) {
            this.index = index;
            this.builder = new DeviceTolerationBuilder(this, item);
        }

        public N and() {
            return (N)DeviceRequestAllocationResultFluent.this.setToTolerations(this.index, this.builder.build());
        }

        public N endToleration() {
            return this.and();
        }
    }
}

