package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class VolumeAttachmentSourceBuilder extends VolumeAttachmentSourceFluent<VolumeAttachmentSourceBuilder> implements VisitableBuilder<VolumeAttachmentSource,VolumeAttachmentSourceBuilder>{
  public VolumeAttachmentSourceBuilder() {
    this(new VolumeAttachmentSource());
  }
  
  public VolumeAttachmentSourceBuilder(VolumeAttachmentSourceFluent<?> fluent) {
    this(fluent, new VolumeAttachmentSource());
  }
  
  public VolumeAttachmentSourceBuilder(VolumeAttachmentSourceFluent<?> fluent,VolumeAttachmentSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public VolumeAttachmentSourceBuilder(VolumeAttachmentSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  VolumeAttachmentSourceFluent<?> fluent;
  
  public VolumeAttachmentSource build() {
    VolumeAttachmentSource buildable = new VolumeAttachmentSource(fluent.getInlineVolumeSpec(),fluent.getPersistentVolumeName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}