/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.lombok.tasks;

import io.freefair.gradle.plugins.lombok.tasks.LombokTask;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.UnionFileTree;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.GUtil;

@CacheableTask
public class Delombok
extends DefaultTask
implements LombokTask {
    @Console
    private final Property<Boolean> verbose = this.getProject().getObjects().property(Boolean.class);
    @Input
    private Map<String, String> format = new HashMap<String, String>();
    @Console
    private final Property<Boolean> quiet = this.getProject().getObjects().property(Boolean.class);
    @Input
    @Optional
    private final Property<String> encoding = this.getProject().getObjects().property(String.class);
    @Input
    @Optional
    private final Property<Boolean> print = this.getProject().getObjects().property(Boolean.class);
    @OutputDirectory
    private final DirectoryProperty target = this.getProject().getObjects().directoryProperty();
    @Classpath
    @Optional
    private final ConfigurableFileCollection classpath = this.getProject().files(new Object[0]);
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    private final ConfigurableFileCollection sourcepath = this.getProject().files(new Object[0]);
    @Classpath
    @Optional
    private final ConfigurableFileCollection bootclasspath = this.getProject().files(new Object[0]);
    @Classpath
    @Optional
    private final ConfigurableFileCollection modulePath = this.getProject().files(new Object[0]);
    @Input
    @Optional
    private final Property<Boolean> nocopy = this.getProject().getObjects().property(Boolean.class);
    @Classpath
    private final ConfigurableFileCollection lombokClasspath = this.getProject().files(new Object[0]);
    @Internal
    private final ConfigurableFileCollection input = this.getProject().files(new Object[0]);

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @SkipWhenEmpty
    protected FileTree getFilteredInput() {
        List collect = this.input.getFiles().stream().filter(File::isDirectory).map(dir -> this.getProject().fileTree(dir)).map(FileTreeInternal.class::cast).collect(Collectors.toList());
        return new UnionFileTree("actual " + this.getName() + " input", collect);
    }

    @TaskAction
    public void delombok() throws IOException {
        this.getProject().delete(new Object[]{this.getTarget().getAsFile().get()});
        LinkedList<String> args = new LinkedList<String>();
        if (((Boolean)this.verbose.getOrElse((Object)false)).booleanValue()) {
            args.add("--verbose");
        }
        this.getFormat().forEach((key, value) -> {
            String formatValue = key + (GUtil.isTrue((Object)value) ? ":" + value : "");
            args.add("--format=" + formatValue);
        });
        if (((Boolean)this.quiet.getOrElse((Object)false)).booleanValue()) {
            args.add("--quiet");
        }
        if (this.getEncoding().isPresent()) {
            args.add("--encoding=" + (String)this.getEncoding().get());
        }
        if (((Boolean)this.print.getOrElse((Object)false)).booleanValue()) {
            args.add("--print");
        }
        if (this.target.isPresent()) {
            args.add("--target=" + Delombok.escape(((File)this.getTarget().getAsFile().get()).getAbsolutePath()));
        }
        if (!this.classpath.isEmpty()) {
            args.add("--classpath=" + Delombok.escape(this.getClasspath().getAsPath()));
        }
        if (!this.sourcepath.isEmpty()) {
            args.add("--sourcepath=" + Delombok.escape(this.getSourcepath().getAsPath()));
        }
        if (!this.bootclasspath.isEmpty()) {
            args.add("--bootclasspath=" + Delombok.escape(this.getBootclasspath().getAsPath()));
        }
        if (!this.modulePath.isEmpty()) {
            args.add("--module-path=" + Delombok.escape(this.getModulePath().getAsPath()));
        }
        if (((Boolean)this.nocopy.getOrElse((Object)false)).booleanValue()) {
            args.add("--nocopy");
        }
        File optionsFile = new File(this.getTemporaryDir(), "delombok.options");
        Files.write(optionsFile.toPath(), args, new OpenOption[0]);
        this.getProject().javaexec(delombok -> {
            delombok.setClasspath((FileCollection)this.getLombokClasspath());
            delombok.setMain("lombok.launch.Main");
            delombok.args(new Object[]{"delombok"});
            delombok.args(new Object[]{"@" + optionsFile});
            delombok.args((Iterable)this.input.getFiles().stream().filter(File::isDirectory).collect(Collectors.toList()));
        });
    }

    private static String escape(String path) {
        return path.replace("\\", "\\\\").replace(" ", "\\ ");
    }

    @Generated
    public Property<Boolean> getVerbose() {
        return this.verbose;
    }

    @Generated
    public Map<String, String> getFormat() {
        return this.format;
    }

    @Generated
    public Property<Boolean> getQuiet() {
        return this.quiet;
    }

    @Generated
    public Property<String> getEncoding() {
        return this.encoding;
    }

    @Generated
    public Property<Boolean> getPrint() {
        return this.print;
    }

    @Generated
    public DirectoryProperty getTarget() {
        return this.target;
    }

    @Generated
    public ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    @Generated
    public ConfigurableFileCollection getSourcepath() {
        return this.sourcepath;
    }

    @Generated
    public ConfigurableFileCollection getBootclasspath() {
        return this.bootclasspath;
    }

    @Generated
    public ConfigurableFileCollection getModulePath() {
        return this.modulePath;
    }

    @Generated
    public Property<Boolean> getNocopy() {
        return this.nocopy;
    }

    @Override
    @Generated
    public ConfigurableFileCollection getLombokClasspath() {
        return this.lombokClasspath;
    }

    @Generated
    public ConfigurableFileCollection getInput() {
        return this.input;
    }

    @Generated
    public void setFormat(Map<String, String> format) {
        this.format = format;
    }
}

