/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal.report;

import io.spring.gradle.dependencymanagement.internal.DependencyManagementContainer;
import io.spring.gradle.dependencymanagement.internal.report.DependencyManagementReportRenderer;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.TaskAction;

public class DependencyManagementReportTask
extends DefaultTask {
    private DependencyManagementContainer dependencyManagementContainer;
    private DependencyManagementReportRenderer renderer = new DependencyManagementReportRenderer();

    void setRenderer(DependencyManagementReportRenderer renderer) {
        this.renderer = renderer;
    }

    public void setDependencyManagementContainer(DependencyManagementContainer dependencyManagementContainer) {
        this.dependencyManagementContainer = dependencyManagementContainer;
    }

    @TaskAction
    public void report() {
        this.renderer.startProject(this.getProject());
        Map<String, String> globalManagedVersions = this.dependencyManagementContainer.getManagedVersionsForConfiguration(null);
        this.renderer.renderGlobalManagedVersions(globalManagedVersions);
        TreeSet<Configuration> configurations = new TreeSet<Configuration>(new Comparator<Configuration>(){

            @Override
            public int compare(Configuration one, Configuration two) {
                return one.getName().compareTo(two.getName());
            }
        });
        configurations.addAll((Collection<Configuration>)this.getProject().getConfigurations());
        for (Configuration configuration : configurations) {
            Map<String, String> managedVersions = this.dependencyManagementContainer.getManagedVersionsForConfiguration(configuration);
            this.renderer.renderConfigurationManagedVersions(managedVersions, configuration, globalManagedVersions);
        }
    }
}

