/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal.report;

import java.io.PrintWriter;
import java.util.Map;
import java.util.TreeMap;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;

class DependencyManagementReportRenderer {
    private final PrintWriter output;

    DependencyManagementReportRenderer() {
        this(new PrintWriter(System.out));
    }

    DependencyManagementReportRenderer(PrintWriter writer) {
        this.output = writer;
    }

    void startProject(Project project) {
        String heading;
        this.output.println();
        this.output.println("------------------------------------------------------------");
        String string = heading = project.getRootProject().equals(project) ? "Root project" : "Project " + project.getPath();
        if (project.getDescription() != null) {
            heading = heading + " - " + project.getDescription();
        }
        this.output.println(heading);
        this.output.println("------------------------------------------------------------");
        this.output.println();
    }

    void renderGlobalManagedVersions(Map<String, String> globalManagedVersions) {
        this.renderDependencyManagementHeader("global", "Default dependency management for all configurations");
        if (globalManagedVersions != null && !globalManagedVersions.isEmpty()) {
            this.renderManagedVersions(globalManagedVersions);
        } else {
            this.output.println("No dependency management");
            this.output.println();
        }
        this.output.flush();
    }

    private void renderDependencyManagementHeader(String identifier, String description) {
        this.output.println(identifier + " - " + description);
    }

    private void renderManagedVersions(Map<String, String> managedVersions) {
        TreeMap<String, String> sortedVersions = new TreeMap<String, String>((one, two) -> {
            String[] twoComponents;
            String[] oneComponents = one.split(":");
            int result = oneComponents[0].compareTo((twoComponents = two.split(":"))[0]);
            if (result == 0) {
                result = oneComponents[1].compareTo(twoComponents[1]);
            }
            return result;
        });
        sortedVersions.putAll(managedVersions);
        sortedVersions.forEach((key, value) -> this.output.println("\t" + key + " " + value));
        this.output.println();
    }

    void renderConfigurationManagedVersions(Map<String, String> managedVersions, Configuration configuration, Map<String, String> globalManagedVersions) {
        this.renderDependencyManagementHeader(configuration.getName(), "Dependency management for the " + configuration.getName() + " configuration");
        if (managedVersions != null && !managedVersions.isEmpty()) {
            if (!managedVersions.equals(globalManagedVersions)) {
                this.renderManagedVersions(managedVersions);
            } else {
                this.output.println("No configuration-specific dependency management");
                this.output.println();
            }
        } else {
            this.output.println("No dependency management");
            this.output.println();
        }
        this.output.flush();
    }
}

