/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model.visitors;

import io.sundr.builder.Builder;
import io.sundr.builder.Visitor;
import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.ClassRefFluent;
import io.sundr.model.MethodBuilder;
import io.sundr.model.PropertyBuilder;
import io.sundr.model.StringStatementBuilder;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import io.sundr.model.TypeRef;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class ReplaceType
implements Visitor<Builder> {
    private final ClassRef target;
    private final ClassRef replacement;
    private final Visitor<ClassRefFluent<?>> visitor;

    public ReplaceType(final ClassRef target, final ClassRef replacement) {
        this.target = target;
        this.replacement = replacement;
        this.visitor = new Visitor<ClassRefFluent<?>>(){

            public void visit(ClassRefFluent<?> ref) {
                if (ref.getFullyQualifiedName().equals(target.getFullyQualifiedName())) {
                    ref.withFullyQualifiedName(replacement.getFullyQualifiedName());
                }
            }
        };
    }

    public void visit(Builder builder) {
        if (builder instanceof TypeDefBuilder) {
            this.visitTypeDefBuilder((TypeDefBuilder)builder);
        } else if (builder instanceof ClassRefBuilder) {
            this.visitClassRefBuilder((ClassRefBuilder)builder);
        } else if (builder instanceof PropertyBuilder) {
            this.visitPropertyBuilder((PropertyBuilder)builder);
        } else if (builder instanceof MethodBuilder) {
            this.visitMethodBuilder((MethodBuilder)builder);
        } else if (builder instanceof StringStatementBuilder) {
            this.visitStringStatementBuilder((StringStatementBuilder)builder);
        }
    }

    private void visitMethodBuilder(MethodBuilder builder) {
        if (builder.buildReturnType() instanceof ClassRef) {
            ClassRefBuilder classRefBuilder = new ClassRefBuilder((ClassRef)builder.buildReturnType());
            builder.withReturnType((TypeRef)((ClassRefBuilder)classRefBuilder.accept(new Visitor[]{this.visitor, this})).build());
        }
    }

    private void visitStringStatementBuilder(StringStatementBuilder builder) {
        String text = (String)builder.build().getSupplier().get();
        String updatedText = text.replaceAll("(?<![a-zA-Z0-9])" + Pattern.quote(this.target.getFullyQualifiedName()) + "(?![a-zA-Z0-9])", this.replacement.getFullyQualifiedName()).replaceAll("(?<![a-zA-Z0-9])" + Pattern.quote(this.target.getName()) + "(?![a-zA-Z0-9])", this.replacement.getName());
        builder.withSupplier(() -> updatedText);
    }

    private void visitPropertyBuilder(PropertyBuilder builder) {
        if (builder.buildTypeRef() instanceof ClassRef) {
            ClassRefBuilder classRefBuilder = new ClassRefBuilder((ClassRef)builder.buildTypeRef());
            builder.withTypeRef((TypeRef)((ClassRefBuilder)classRefBuilder.accept(new Visitor[]{this.visitor, this})).build());
        }
    }

    private void visitClassRefBuilder(ClassRefBuilder builder) {
        builder.accept(new Visitor[]{this.visitor});
        ArrayList<Object> updatedArguments = new ArrayList<Object>();
        for (TypeRef arg : builder.buildArguments()) {
            if (this.target.equals((Object)arg)) {
                updatedArguments.add(this.replacement);
                continue;
            }
            updatedArguments.add(arg);
        }
        builder.withArguments(updatedArguments);
    }

    private void visitTypeDefBuilder(TypeDefBuilder builder) {
        if (builder.getAttributes().containsKey(TypeDef.ALSO_IMPORT)) {
            LinkedHashSet<ClassRef> updatedImports = new LinkedHashSet<ClassRef>();
            for (ClassRef classRef : (Set)builder.getAttributes().get(TypeDef.ALSO_IMPORT)) {
                if (this.target.equals((Object)classRef)) {
                    updatedImports.add(this.replacement);
                    continue;
                }
                updatedImports.add(classRef);
            }
            builder.getAttributes().put(TypeDef.ALSO_IMPORT, updatedImports);
        }
    }
}

