/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.builder.Nested;
import io.sundr.model.AttributeSupportFluent;
import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.ClassRefFluent;
import io.sundr.model.TypeParamDef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class TypeParamDefFluent<A extends TypeParamDefFluent<A>>
extends AttributeSupportFluent<A> {
    private ArrayList<ClassRefBuilder> bounds = new ArrayList();
    private String name;

    public TypeParamDefFluent() {
    }

    public TypeParamDefFluent(TypeParamDef instance) {
        this.copyInstance(instance);
    }

    public A addAllToBounds(Collection<ClassRef> items) {
        if (this.bounds == null) {
            this.bounds = new ArrayList();
        }
        for (ClassRef item : items) {
            ClassRefBuilder builder = new ClassRefBuilder(item);
            this._visitables.get((Object)"bounds").add(builder);
            this.bounds.add(builder);
        }
        return (A)((Object)this);
    }

    public BoundsNested<A> addNewBound() {
        return new BoundsNested(-1, null);
    }

    public BoundsNested<A> addNewBoundLike(ClassRef item) {
        return new BoundsNested(-1, item);
    }

    public A addToBounds(ClassRef ... items) {
        if (this.bounds == null) {
            this.bounds = new ArrayList();
        }
        for (ClassRef item : items) {
            ClassRefBuilder builder = new ClassRefBuilder(item);
            this._visitables.get((Object)"bounds").add(builder);
            this.bounds.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToBounds(int index, ClassRef item) {
        if (this.bounds == null) {
            this.bounds = new ArrayList();
        }
        ClassRefBuilder builder = new ClassRefBuilder(item);
        if (index < 0 || index >= this.bounds.size()) {
            this._visitables.get((Object)"bounds").add(builder);
            this.bounds.add(builder);
        } else {
            this._visitables.get((Object)"bounds").add(builder);
            this.bounds.add(index, builder);
        }
        return (A)((Object)this);
    }

    public ClassRef buildBound(int index) {
        return this.bounds.get(index).build();
    }

    public List<ClassRef> buildBounds() {
        return this.bounds != null ? TypeParamDefFluent.build(this.bounds) : null;
    }

    public ClassRef buildFirstBound() {
        return this.bounds.get(0).build();
    }

    public ClassRef buildLastBound() {
        return this.bounds.get(this.bounds.size() - 1).build();
    }

    public ClassRef buildMatchingBound(Predicate<ClassRefBuilder> predicate) {
        for (ClassRefBuilder item : this.bounds) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(TypeParamDef instance) {
        if (instance != null) {
            this.withName(instance.getName());
            this.withBounds(instance.getBounds());
            this.withAttributes(instance.getAttributes());
        }
    }

    public BoundsNested<A> editBound(int index) {
        if (this.bounds.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "bounds"));
        }
        return this.setNewBoundLike(index, this.buildBound(index));
    }

    public BoundsNested<A> editFirstBound() {
        if (this.bounds.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "bounds"));
        }
        return this.setNewBoundLike(0, this.buildBound(0));
    }

    public BoundsNested<A> editLastBound() {
        int index = this.bounds.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "bounds"));
        }
        return this.setNewBoundLike(index, this.buildBound(index));
    }

    public BoundsNested<A> editMatchingBound(Predicate<ClassRefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.bounds.size(); ++i) {
            if (!predicate.test(this.bounds.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "bounds"));
        }
        return this.setNewBoundLike(index, this.buildBound(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TypeParamDefFluent that = (TypeParamDefFluent)((Object)o);
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.bounds, that.bounds);
    }

    public String getName() {
        return this.name;
    }

    public boolean hasBounds() {
        return this.bounds != null && !this.bounds.isEmpty();
    }

    public boolean hasMatchingBound(Predicate<ClassRefBuilder> predicate) {
        for (ClassRefBuilder item : this.bounds) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasName() {
        return this.name != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.bounds);
    }

    public A removeAllFromBounds(Collection<ClassRef> items) {
        if (this.bounds == null) {
            return (A)((Object)this);
        }
        for (ClassRef item : items) {
            ClassRefBuilder builder = new ClassRefBuilder(item);
            this._visitables.get((Object)"bounds").remove((Object)builder);
            this.bounds.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromBounds(ClassRef ... items) {
        if (this.bounds == null) {
            return (A)((Object)this);
        }
        for (ClassRef item : items) {
            ClassRefBuilder builder = new ClassRefBuilder(item);
            this._visitables.get((Object)"bounds").remove((Object)builder);
            this.bounds.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromBounds(Predicate<ClassRefBuilder> predicate) {
        if (this.bounds == null) {
            return (A)((Object)this);
        }
        Iterator<ClassRefBuilder> each = this.bounds.iterator();
        List visitables = this._visitables.get((Object)"bounds");
        while (each.hasNext()) {
            ClassRefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public BoundsNested<A> setNewBoundLike(int index, ClassRef item) {
        return new BoundsNested(index, item);
    }

    public A setToBounds(int index, ClassRef item) {
        if (this.bounds == null) {
            this.bounds = new ArrayList();
        }
        ClassRefBuilder builder = new ClassRefBuilder(item);
        if (index < 0 || index >= this.bounds.size()) {
            this._visitables.get((Object)"bounds").add(builder);
            this.bounds.add(builder);
        } else {
            this._visitables.get((Object)"bounds").add(builder);
            this.bounds.set(index, builder);
        }
        return (A)((Object)this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.bounds != null && !this.bounds.isEmpty()) {
            sb.append("bounds:");
            sb.append(this.bounds);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withBounds(List<ClassRef> bounds) {
        if (this.bounds != null) {
            this._visitables.get((Object)"bounds").clear();
        }
        if (bounds != null) {
            this.bounds = new ArrayList();
            for (ClassRef item : bounds) {
                this.addToBounds(item);
            }
        } else {
            this.bounds = null;
        }
        return (A)((Object)this);
    }

    public A withBounds(ClassRef ... bounds) {
        if (this.bounds != null) {
            this.bounds.clear();
            this._visitables.remove((Object)"bounds");
        }
        if (bounds != null) {
            for (ClassRef item : bounds) {
                this.addToBounds(item);
            }
        }
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public class BoundsNested<N>
    extends ClassRefFluent<BoundsNested<N>>
    implements Nested<N> {
        ClassRefBuilder builder;
        int index;

        BoundsNested(int index, ClassRef item) {
            this.index = index;
            this.builder = new ClassRefBuilder(this, item);
        }

        public N and() {
            return (N)TypeParamDefFluent.this.setToBounds(this.index, this.builder.build());
        }

        public N endBound() {
            return this.and();
        }
    }
}

