/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.reckon.gradle;

import javax.inject.Inject;
import org.ajoberstar.grgit.Grgit;
import org.ajoberstar.grgit.gradle.GrgitService;
import org.ajoberstar.reckon.core.Version;
import org.ajoberstar.reckon.core.VersionTagWriter;
import org.gradle.api.DefaultTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;

@UntrackedTask(because="Git tracks the state")
public class ReckonCreateTagTask
extends DefaultTask {
    private Property<GrgitService> grgitService;
    private Property<Version> version;
    private Property<VersionTagWriter> tagWriter;
    private Property<String> tagMessage;

    @Inject
    public ReckonCreateTagTask(ObjectFactory objectFactory) {
        this.grgitService = objectFactory.property(GrgitService.class);
        this.version = objectFactory.property(Version.class);
        this.tagWriter = objectFactory.property(VersionTagWriter.class);
        this.tagMessage = objectFactory.property(String.class);
    }

    @TaskAction
    public void create() {
        Grgit git = ((GrgitService)this.grgitService.get()).getGrgit();
        String tagName = ((VersionTagWriter)this.tagWriter.get()).write((Version)this.version.get());
        boolean alreadyTagged = git.getTag().list().stream().anyMatch(tag -> tag.getName().equals(tagName));
        if (alreadyTagged || !((Version)this.version.get()).isSignificant()) {
            this.setDidWork(false);
        } else {
            git.getTag().add(op -> {
                op.setName(tagName);
                op.setMessage((String)this.tagMessage.get());
            });
            this.setDidWork(true);
        }
    }

    @Internal
    public Property<GrgitService> getGrgitService() {
        return this.grgitService;
    }

    @Input
    public Property<Version> getVersion() {
        return this.version;
    }

    @Input
    public Property<VersionTagWriter> getTagWriter() {
        return this.tagWriter;
    }

    @Input
    public Property<String> getTagMessage() {
        return this.tagMessage;
    }
}

