/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.texttree.api;

import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.barfuin.texttree.api.CycleProtection;
import org.barfuin.texttree.api.IdentityScheme;
import org.barfuin.texttree.api.color.ColorScheme;
import org.barfuin.texttree.api.color.DefaultColorScheme;
import org.barfuin.texttree.api.color.NoColorScheme;
import org.barfuin.texttree.api.style.AnnotationPosition;
import org.barfuin.texttree.api.style.TreeStyle;
import org.barfuin.texttree.api.style.TreeStyles;

public final class TreeOptions {
    private static final IdentityScheme DEFAULT_IDENTITY_SCHEME = IdentityScheme.ByIdentity;
    private static final TreeStyle DEFAULT_TREE_STYLE = TreeStyles.ASCII_ROUNDED;
    private static final CycleProtection DEFAULT_CYCLE_PROTECTION = CycleProtection.On;
    private static final ColorScheme NO_COLOR_SCHEME = new NoColorScheme();
    private static final AnnotationPosition DEFAULT_ANNOT_POS = AnnotationPosition.NextLine;
    private static final int DEFAULT_MAX_DEPTH = 100;
    private IdentityScheme identityScheme = DEFAULT_IDENTITY_SCHEME;
    private String padding = " ";
    private TreeStyle style = DEFAULT_TREE_STYLE;
    private CycleProtection cycleProtection = DEFAULT_CYCLE_PROTECTION;
    private ColorScheme colorScheme = NO_COLOR_SCHEME;
    private AnnotationPosition annotationPosition = DEFAULT_ANNOT_POS;
    private int maxDepth = 100;
    private boolean cycleAsPruned = false;

    @Nonnull
    public IdentityScheme getIdentityScheme() {
        return this.identityScheme;
    }

    public void setIdentityScheme(@Nullable IdentityScheme pIdentityScheme) {
        this.identityScheme = pIdentityScheme != null ? pIdentityScheme : DEFAULT_IDENTITY_SCHEME;
    }

    public int getPadding() {
        return this.padding.length();
    }

    @Nonnull
    public String getPaddingStr() {
        return this.padding;
    }

    public void setPadding(int pLenPadding) {
        if (pLenPadding < 0) {
            throw new IllegalArgumentException("padding must be 0 or positive, but was: " + pLenPadding);
        }
        this.padding = Stream.generate(() -> " ").limit(pLenPadding).collect(Collectors.joining());
    }

    @Nonnull
    public TreeStyle getStyle() {
        return this.style;
    }

    public void setStyle(@Nullable TreeStyle pStyle) {
        this.style = pStyle != null ? pStyle : DEFAULT_TREE_STYLE;
    }

    @Nonnull
    public CycleProtection getCycleProtection() {
        return this.cycleProtection;
    }

    public void setCycleProtection(@Nullable CycleProtection pCycleProtection) {
        this.cycleProtection = pCycleProtection != null ? pCycleProtection : DEFAULT_CYCLE_PROTECTION;
    }

    public void setEnableDefaultColoring(boolean pEnableDefaultColoring) {
        this.colorScheme = pEnableDefaultColoring ? new DefaultColorScheme() : NO_COLOR_SCHEME;
    }

    @Nonnull
    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public void setColorScheme(@Nullable ColorScheme pColorScheme) {
        this.colorScheme = pColorScheme != null ? pColorScheme : NO_COLOR_SCHEME;
    }

    @Nonnull
    public AnnotationPosition getAnnotationPosition() {
        return this.annotationPosition;
    }

    public void setAnnotationPosition(@Nullable AnnotationPosition pAnnotationPosition) {
        this.annotationPosition = pAnnotationPosition != null ? pAnnotationPosition : DEFAULT_ANNOT_POS;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int pMaxDepth) {
        if (pMaxDepth < 0) {
            throw new IllegalArgumentException("max depth cannot be negative");
        }
        this.maxDepth = pMaxDepth;
    }

    public boolean isCycleAsPruned() {
        return this.cycleAsPruned;
    }

    public void setCycleAsPruned(boolean pCycleAsPruned) {
        this.cycleAsPruned = pCycleAsPruned;
    }

    public static TreeOptions copyOf(@Nonnull TreeOptions pTreeOptions) {
        Objects.requireNonNull(pTreeOptions, "pTreeOptions must not be null");
        TreeOptions result = new TreeOptions();
        result.setIdentityScheme(pTreeOptions.getIdentityScheme());
        result.setPadding(pTreeOptions.getPadding());
        result.setStyle(pTreeOptions.getStyle());
        result.setCycleProtection(pTreeOptions.getCycleProtection());
        result.setColorScheme(pTreeOptions.getColorScheme());
        result.setAnnotationPosition(pTreeOptions.getAnnotationPosition());
        result.setMaxDepth(pTreeOptions.getMaxDepth());
        result.setCycleAsPruned(pTreeOptions.isCycleAsPruned());
        return result;
    }
}

