/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.texttree.internal;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import org.barfuin.texttree.internal.TreeElementType;

public enum Callout {
    None(TreeElementType.CalloutError, false),
    RepeatingNode(TreeElementType.CalloutNote, true),
    Cycle(TreeElementType.CalloutError, true),
    MaxDepth(TreeElementType.CalloutNote, false);

    private final TreeElementType elementType;
    private final boolean printOnSameLine;

    private Callout(TreeElementType pElementType, boolean pPrintOnSameLine) {
        this.elementType = pElementType;
        this.printOnSameLine = pPrintOnSameLine;
    }

    @Nonnull
    public TreeElementType getElementType() {
        return this.elementType;
    }

    @Nonnull
    public String getText() {
        if (this == None) {
            return "";
        }
        return ResourceBundle.getBundle("org.barfuin.texttree.internal.messages").getString("callout." + this.name().toLowerCase(Locale.ENGLISH));
    }

    public boolean isPrintOnSameLine() {
        return this.printOnSameLine;
    }
}

