/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;

public class DependencyUtils {
    public static String getDependencyName(ResolvedDependency resolvedDependencies) {
        ModuleVersionIdentifier m = resolvedDependencies.getModule().getId();
        return DependencyUtils.getDependencyName(m);
    }

    public static String getDependencyName(ResolvedArtifact artifact) {
        ModuleVersionIdentifier m = artifact.getModuleVersion().getId();
        return DependencyUtils.getDependencyName(m);
    }

    public static boolean canBeResolved(Configuration configuration) {
        try {
            Method method = Configuration.class.getMethod("isCanBeResolved", new Class[0]);
            try {
                return (Boolean)method.invoke((Object)configuration, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return true;
            }
        }
        catch (NoSuchMethodException e) {
            return true;
        }
    }

    private static String getDependencyName(ModuleVersionIdentifier moduleVersion) {
        return String.format("%s:%s:%s", moduleVersion.getGroup(), moduleVersion.getName(), moduleVersion.getVersion());
    }
}

