/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.internal.agent;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.graalvm.buildtools.agent.AgentConfiguration;
import org.graalvm.buildtools.agent.AgentMode;
import org.graalvm.buildtools.agent.ConditionalAgentMode;
import org.graalvm.buildtools.agent.DirectAgentMode;
import org.graalvm.buildtools.agent.DisabledAgentMode;
import org.graalvm.buildtools.agent.StandardAgentMode;
import org.graalvm.buildtools.gradle.dsl.agent.AgentOptions;
import org.graalvm.buildtools.gradle.dsl.agent.ConditionalAgentModeOptions;
import org.graalvm.buildtools.gradle.internal.ConfigurationCacheSupport;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.provider.Provider;

public class AgentConfigurationFactory {
    public static Provider<AgentConfiguration> getAgentConfiguration(Provider<String> modeName, AgentOptions options) {
        return modeName.map(ConfigurationCacheSupport.serializableTransformerOf(name -> {
            ConfigurableFileCollection callerFilterFiles = options.getCallerFilterFiles();
            ConfigurableFileCollection accessFilterFiles = options.getAccessFilterFiles();
            return new AgentConfiguration(AgentConfigurationFactory.getFilePaths(callerFilterFiles), AgentConfigurationFactory.getFilePaths(accessFilterFiles), (Boolean)options.getBuiltinCallerFilter().get(), (Boolean)options.getBuiltinHeuristicFilter().get(), (Boolean)options.getEnableExperimentalPredefinedClasses().get(), (Boolean)options.getEnableExperimentalUnsafeAllocationTracing().get(), (Boolean)options.getTrackReflectionMetadata().get(), (AgentMode)(switch (name) {
                case "standard" -> new StandardAgentMode();
                case "disabled" -> new DisabledAgentMode();
                case "conditional" -> {
                    ConditionalAgentModeOptions opts = options.getModes().getConditional();
                    if (!opts.getUserCodeFilterPath().isPresent()) {
                        throw new GradleException("Missing property userCodeFilterPath in agent conditional configuration");
                    }
                    yield new ConditionalAgentMode((String)opts.getUserCodeFilterPath().get(), (String)opts.getExtraFilterPath().getOrElse((Object)""), ((Boolean)opts.getParallel().get()).booleanValue());
                }
                case "direct" -> new DirectAgentMode((List)options.getModes().getDirect().getOptions().getOrElse(Collections.emptyList()));
                default -> throw new GradleException("Unknown agent mode selected: " + name);
            }));
        }));
    }

    private static Collection<String> getFilePaths(ConfigurableFileCollection configurableFileCollection) {
        return configurableFileCollection.getFiles().stream().map(File::getAbsolutePath).collect(Collectors.toList());
    }

    public static Provider<Directory> getAgentOutputDirectoryForTask(ProjectLayout layout, String taskName) {
        return layout.getBuildDirectory().dir("native/agent-output/" + taskName);
    }
}

