/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import org.graalvm.buildtools.gradle.dsl.NativeImageOptions;
import org.graalvm.buildtools.gradle.internal.GraalVMLogger;
import org.graalvm.buildtools.gradle.internal.NativeImageExecutableLocator;
import org.graalvm.buildtools.utils.NativeImageUtils;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;

class MergeAgentFiles
implements Action<Task> {
    private final Provider<Boolean> agent;
    private final Provider<String> graalvmHomeProvider;
    private final Provider<Directory> outputDir;
    private final Provider<Boolean> disableToolchainDetection;
    private final ExecOperations execOperations;
    private final NativeImageOptions options;
    private final FileSystemOperations fileOperations;
    private final Logger logger;

    MergeAgentFiles(Provider<Boolean> agent, Provider<String> graalvmHomeProvider, Provider<Directory> outputDir, Provider<Boolean> disableToolchainDetection, NativeImageOptions options, ExecOperations execOperations, FileSystemOperations fileOperations, Logger logger) {
        this.agent = agent;
        this.graalvmHomeProvider = graalvmHomeProvider;
        this.outputDir = outputDir;
        this.disableToolchainDetection = disableToolchainDetection;
        this.options = options;
        this.execOperations = execOperations;
        this.fileOperations = fileOperations;
        this.logger = logger;
    }

    public void execute(Task task) {
        if (((Boolean)this.agent.get()).booleanValue()) {
            File nativeImage = NativeImageExecutableLocator.findNativeImageExecutable(this.options, this.disableToolchainDetection, this.graalvmHomeProvider, this.execOperations, GraalVMLogger.of(this.logger));
            File workingDir = nativeImage.getParentFile();
            File launcher = new File(workingDir, NativeImageUtils.nativeImageConfigureFileName());
            if (!launcher.exists()) {
                this.logger.info("Installing native-image-configure");
                this.execOperations.exec(spec -> {
                    spec.executable((Object)nativeImage);
                    spec.args(new Object[]{"--macro:native-image-configure-launcher"});
                });
                NativeImageUtils.maybeCreateConfigureUtilSymlink((File)launcher, (Path)nativeImage.toPath());
            }
            if (launcher.exists()) {
                File[] files = ((Directory)this.outputDir.get()).getAsFile().listFiles();
                ArrayList<String> args = new ArrayList<String>(files.length + 2);
                args.add("generate");
                this.sessionDirectoriesFrom(files).map(f -> "--input-dir=" + f.getAbsolutePath()).forEach(args::add);
                if (args.size() > 1) {
                    this.logger.info("Merging agent files");
                    args.add("--output-dir=" + ((Directory)this.outputDir.get()).getAsFile().getAbsolutePath());
                    ExecResult exec = this.execOperations.exec(spec -> {
                        spec.executable((Object)launcher);
                        spec.args((Iterable)args);
                        spec.setStandardOutput((OutputStream)System.out);
                        spec.setErrorOutput((OutputStream)System.err);
                    });
                    if (exec.getExitValue() == 0) {
                        this.fileOperations.delete(spec -> this.sessionDirectoriesFrom(files).forEach(xva$0 -> spec.delete(new Object[]{xva$0})));
                    } else {
                        exec.rethrowFailure();
                    }
                }
            } else {
                this.logger.warn("Cannot merge agent files because native-image-configure is not installed. Please upgrade to a newer version of GraalVM.");
            }
        }
    }

    private Stream<File> sessionDirectoriesFrom(File[] files) {
        return Arrays.stream(files).filter(File::isDirectory).filter(f -> f.getName().startsWith("session-"));
    }
}

