/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graalvm.buildtools.gradle.MergeAgentFiles;
import org.graalvm.buildtools.gradle.NativeImageService;
import org.graalvm.buildtools.gradle.dsl.AgentConfiguration;
import org.graalvm.buildtools.gradle.dsl.GraalVMExtension;
import org.graalvm.buildtools.gradle.dsl.JvmReachabilityMetadataRepositoryExtension;
import org.graalvm.buildtools.gradle.dsl.NativeImageOptions;
import org.graalvm.buildtools.gradle.internal.AgentCommandLineProvider;
import org.graalvm.buildtools.gradle.internal.BaseNativeImageOptions;
import org.graalvm.buildtools.gradle.internal.DefaultGraalVmExtension;
import org.graalvm.buildtools.gradle.internal.DefaultTestBinaryConfig;
import org.graalvm.buildtools.gradle.internal.DeprecatedNativeImageOptions;
import org.graalvm.buildtools.gradle.internal.GraalVMLogger;
import org.graalvm.buildtools.gradle.internal.GradleUtils;
import org.graalvm.buildtools.gradle.internal.JvmReachabilityMetadataService;
import org.graalvm.buildtools.gradle.internal.NativeConfigurations;
import org.graalvm.buildtools.gradle.internal.NativeImageExecutableLocator;
import org.graalvm.buildtools.gradle.internal.ProcessGeneratedGraalResourceFiles;
import org.graalvm.buildtools.gradle.tasks.BuildNativeImageTask;
import org.graalvm.buildtools.gradle.tasks.GenerateResourcesConfigFile;
import org.graalvm.buildtools.gradle.tasks.NativeRunTask;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ApplicationPlugin;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaApplication;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.testing.Test;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.ExecOperations;
import org.gradle.process.JavaForkOptions;
import org.gradle.util.GFileUtils;

public class NativeImagePlugin
implements Plugin<Project> {
    public static final String NATIVE_COMPILE_TASK_NAME = "nativeCompile";
    public static final String NATIVE_TEST_COMPILE_TASK_NAME = "nativeTestCompile";
    public static final String NATIVE_TEST_TASK_NAME = "nativeTest";
    public static final String NATIVE_TEST_EXTENSION = "test";
    public static final String NATIVE_MAIN_EXTENSION = "main";
    public static final String PROCESS_AGENT_RESOURCES_TASK_NAME_PREFIX = "filterAgent";
    public static final String PROCESS_AGENT_RESOURCES_TASK_NAME_SUFFIX = "Resources";
    public static final String GENERATE_RESOURCES_CONFIG_FILE_TASK_NAME = "generateResourcesConfigFile";
    public static final String GENERATE_TEST_RESOURCES_CONFIG_FILE_TASK_NAME = "generateTestResourcesConfigFile";
    public static final String DEPRECATED_NATIVE_BUILD_EXTENSION = "nativeBuild";
    public static final String DEPRECATED_NATIVE_TEST_EXTENSION = "nativeTest";
    public static final String DEPRECATED_NATIVE_BUILD_TASK = "nativeBuild";
    public static final String DEPRECATED_NATIVE_TEST_BUILD_TASK = "nativeTestBuild";
    public static final String CONFIG_REPO_LOGLEVEL = "org.graalvm.internal.gradle.configrepo.logging";
    private static final Consumer<Object> FORCE_CONFIG = t -> {};
    private static final String JUNIT_PLATFORM_LISTENERS_UID_TRACKING_ENABLED = "junit.platform.listeners.uid.tracking.enabled";
    private static final String JUNIT_PLATFORM_LISTENERS_UID_TRACKING_OUTPUT_DIR = "junit.platform.listeners.uid.tracking.output.dir";
    private GraalVMLogger logger;

    @Inject
    public ArchiveOperations getArchiveOperations() {
        throw new UnsupportedOperationException();
    }

    @Inject
    public ExecOperations getExecOperations() {
        throw new UnsupportedOperationException();
    }

    @Inject
    public FileSystemOperations getFileOperations() {
        throw new UnsupportedOperationException();
    }

    public void apply(Project project) {
        Provider<NativeImageService> nativeImageServiceProvider = NativeImageService.registerOn(project);
        this.logger = GraalVMLogger.of(project.getLogger());
        DefaultGraalVmExtension graalExtension = (DefaultGraalVmExtension)this.registerGraalVMExtension(project);
        graalExtension.getUseArgFile().convention((Object)true);
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> this.configureJavaProject(project, nativeImageServiceProvider, graalExtension));
        project.afterEvaluate(p -> {
            Map<String, Provider<Boolean>> agents = graalExtension.getAgentProperties();
            graalExtension.getBinaries().all(options -> {
                AgentConfiguration agentConfiguration = options.getAgent();
                if (agentConfiguration.getInstrumentedTask().isPresent()) {
                    NativeImagePlugin.configureAgent(p, agents, (Provider<Boolean>)graalExtension.getToolchainDetection().map(b -> b == false), options, this.getExecOperations(), this.getFileOperations());
                }
            });
        });
    }

    private static String deriveTaskName(String name, String prefix, String suffix) {
        if (NATIVE_MAIN_EXTENSION.equals(name)) {
            return prefix + suffix;
        }
        return prefix + NativeImagePlugin.capitalize(name) + suffix;
    }

    private void configureJavaProject(Project project, Provider<NativeImageService> nativeImageServiceProvider, DefaultGraalVmExtension graalExtension) {
        this.logger.log("====================");
        this.logger.log("Initializing project: " + project.getName());
        this.logger.log("====================");
        Map<String, Provider<Boolean>> agents = graalExtension.getAgentProperties();
        NativeImageOptions mainOptions = NativeImagePlugin.createMainOptions(graalExtension, project);
        this.deprecateExtension(project, mainOptions, "nativeBuild", NATIVE_MAIN_EXTENSION);
        project.getPlugins().withId("application", p -> mainOptions.getMainClass().convention((Provider)((JavaApplication)project.getExtensions().findByType(JavaApplication.class)).getMainClass()));
        project.getPlugins().withId("java-library", p -> mainOptions.getSharedLibrary().convention((Object)true));
        NativeImagePlugin.registerServiceProvider(project, nativeImageServiceProvider);
        TaskContainer tasks = project.getTasks();
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        this.configureAutomaticTaskCreation(project, graalExtension, agents, tasks, javaConvention.getSourceSets());
        TaskProvider imageBuilder = tasks.named(NATIVE_COMPILE_TASK_NAME, BuildNativeImageTask.class);
        TaskProvider deprecatedTask = tasks.register("nativeBuild", t -> {
            t.dependsOn(new Object[]{imageBuilder});
            t.doFirst("Warn about deprecation", task -> task.getLogger().warn("Task nativeBuild is deprecated. Use nativeCompile instead."));
        });
        project.getPlugins().withType(ApplicationPlugin.class, applicationPlugin -> {
            TaskProvider runTask = tasks.withType(JavaExec.class).named("run");
            mainOptions.getAgent().getInstrumentedTask().convention((Object)runTask);
        });
        graalExtension.registerTestBinary(NATIVE_TEST_EXTENSION, (Action<? super GraalVMExtension.TestBinaryConfig>)((Action)config -> {
            config.forTestTask((TaskProvider<Test>)tasks.named(NATIVE_TEST_EXTENSION, Test.class));
            config.usingSourceSet(GradleUtils.findSourceSet(project, NATIVE_TEST_EXTENSION));
        }));
    }

    private void configureAutomaticTaskCreation(Project project, GraalVMExtension graalExtension, Map<String, Provider<Boolean>> agents, TaskContainer tasks, SourceSetContainer sourceSets) {
        graalExtension.getBinaries().configureEach(options -> {
            String binaryName = options.getName();
            String compileTaskName = NativeImagePlugin.deriveTaskName(binaryName, "native", "Compile");
            if (NATIVE_MAIN_EXTENSION.equals(binaryName)) {
                compileTaskName = NATIVE_COMPILE_TASK_NAME;
            }
            Provider<Boolean> agent = NativeImagePlugin.agentPropertyOverride(project, options);
            agents.put(binaryName, agent);
            TaskProvider imageBuilder = tasks.register(compileTaskName, BuildNativeImageTask.class, builder -> {
                builder.setDescription("Compiles a native image for the " + options.getName() + " binary");
                builder.setGroup("build");
                builder.getOptions().convention(options);
                builder.getAgentEnabled().set(agent);
                builder.getUseArgFile().convention(graalExtension.getUseArgFile());
            });
            String runTaskName = NativeImagePlugin.deriveTaskName(binaryName, "native", "Run");
            if (NATIVE_MAIN_EXTENSION.equals(binaryName)) {
                runTaskName = "nativeRun";
            } else if (binaryName.toLowerCase(Locale.US).endsWith(NATIVE_TEST_EXTENSION)) {
                runTaskName = "native" + NativeImagePlugin.capitalize(binaryName);
            }
            tasks.register(runTaskName, NativeRunTask.class, task -> {
                task.setGroup("build");
                task.setDescription("Executes the " + options.getName() + " native binary");
                task.getImage().convention(imageBuilder.map(t -> (RegularFile)t.getOutputFile().get()));
                task.getRuntimeArgs().convention(options.getRuntimeArgs());
            });
            this.configureClasspathJarFor(tasks, (NativeImageOptions)options, (TaskProvider<BuildNativeImageTask>)imageBuilder);
            SourceSet sourceSet = NATIVE_TEST_EXTENSION.equals(binaryName) ? (SourceSet)sourceSets.getByName(NATIVE_TEST_EXTENSION) : (SourceSet)sourceSets.getByName(NATIVE_MAIN_EXTENSION);
            TaskProvider<GenerateResourcesConfigFile> generateResourcesConfig = this.registerResourcesConfigTask((Provider<Directory>)graalExtension.getGeneratedResourcesDirectory(), (NativeImageOptions)options, tasks, GradleUtils.transitiveProjectArtifacts(project, sourceSet.getRuntimeClasspathConfigurationName()), NativeImagePlugin.deriveTaskName(binaryName, "generate", "ResourcesConfigFile"));
            options.getConfigurationFileDirectories().from(new Object[]{generateResourcesConfig.map(t -> t.getOutputFile().map(f -> f.getAsFile().getParentFile()))});
            this.configureJvmReachabilityConfigurationDirectories(project, graalExtension, (NativeImageOptions)options, sourceSet);
        });
    }

    private void configureJvmReachabilityConfigurationDirectories(Project project, GraalVMExtension graalExtension, NativeImageOptions options, SourceSet sourceSet) {
        JvmReachabilityMetadataRepositoryExtension repositoryExtension = NativeImagePlugin.reachabilityExtensionOn(graalExtension);
        Provider serviceProvider = project.getGradle().getSharedServices().registerIfAbsent("nativeConfigurationService", JvmReachabilityMetadataService.class, spec -> {
            LogLevel logLevel = NativeImagePlugin.determineLogLevel();
            ((JvmReachabilityMetadataService.Params)spec.getParameters()).getLogLevel().set((Object)logLevel);
            ((JvmReachabilityMetadataService.Params)spec.getParameters()).getUri().set(repositoryExtension.getUri());
            ((JvmReachabilityMetadataService.Params)spec.getParameters()).getCacheDir().set(new File(project.getGradle().getGradleUserHomeDir(), "native-build-tools/repositories"));
        });
        options.getConfigurationFileDirectories().from(new Object[]{repositoryExtension.getEnabled().flatMap(enabled -> {
            if (enabled.booleanValue() && repositoryExtension.getUri().isPresent()) {
                Configuration classpath = project.getConfigurations().getByName(sourceSet.getRuntimeClasspathConfigurationName());
                Set excludedModules = (Set)repositoryExtension.getExcludedModules().getOrElse(Collections.emptySet());
                Map forcedVersions = (Map)repositoryExtension.getModuleToConfigVersion().getOrElse(Collections.emptyMap());
                return serviceProvider.map(repo -> repo.findConfigurationDirectoriesFor(query -> classpath.getIncoming().getResolutionResult().allComponents(component -> {
                    ModuleVersionIdentifier moduleVersion = component.getModuleVersion();
                    String module = moduleVersion.getGroup() + ":" + moduleVersion.getName();
                    if (!excludedModules.contains(module)) {
                        query.forArtifact(artifact -> {
                            artifact.gav(module + ":" + moduleVersion.getVersion());
                            if (forcedVersions.containsKey(module)) {
                                artifact.forceConfigVersion((String)forcedVersions.get(module));
                            }
                        });
                    }
                    query.useLatestConfigWhenVersionIsUntested();
                })).stream().map(Path::toAbsolutePath).map(Path::toFile).collect(Collectors.toList()));
            }
            return project.getProviders().provider(Collections::emptySet);
        })});
    }

    private static LogLevel determineLogLevel() {
        LogLevel logLevel = LogLevel.DEBUG;
        String loggingProperty = System.getProperty(CONFIG_REPO_LOGLEVEL);
        if (loggingProperty != null) {
            logLevel = LogLevel.valueOf((String)loggingProperty.toUpperCase(Locale.US));
        }
        return logLevel;
    }

    private static JvmReachabilityMetadataRepositoryExtension reachabilityExtensionOn(GraalVMExtension graalExtension) {
        return (JvmReachabilityMetadataRepositoryExtension)((ExtensionAware)graalExtension).getExtensions().getByType(JvmReachabilityMetadataRepositoryExtension.class);
    }

    private void deprecateExtension(Project project, NativeImageOptions delegate, String name, String substitute) {
        JavaToolchainService toolchains = (JavaToolchainService)project.getExtensions().findByType(JavaToolchainService.class);
        ObjectFactory objects = project.getObjects();
        project.getExtensions().add(name, objects.newInstance(DeprecatedNativeImageOptions.class, new Object[]{name, delegate, substitute, project.getLogger()}));
    }

    private void configureClasspathJarFor(TaskContainer tasks, NativeImageOptions options, TaskProvider<BuildNativeImageTask> imageBuilder) {
        String baseName = imageBuilder.getName();
        TaskProvider classpathJar = tasks.register(baseName + "ClasspathJar", Jar.class, jar -> {
            jar.setDescription("Builds a pathing jar for the " + options.getName() + " native binary");
            jar.from(new Object[]{options.getClasspath().getElements().map(elems -> elems.stream().map(e -> {
                if (NativeImagePlugin.isJar(e)) {
                    return this.getArchiveOperations().zipTree(e);
                }
                return e;
            }).collect(Collectors.toList()))});
            jar.setDuplicatesStrategy(DuplicatesStrategy.WARN);
            jar.getArchiveBaseName().set((Object)(baseName.toLowerCase(Locale.ENGLISH) + "-classpath"));
        });
        imageBuilder.configure(nit -> {
            if (((Boolean)options.getUseFatJar().get()).booleanValue()) {
                nit.getClasspathJar().set(classpathJar.flatMap(AbstractArchiveTask::getArchiveFile));
            }
        });
    }

    private static boolean isJar(FileSystemLocation location) {
        return location.getAsFile().getName().toLowerCase(Locale.US).endsWith(".jar");
    }

    private GraalVMExtension registerGraalVMExtension(Project project) {
        NamedDomainObjectContainer nativeImages = project.getObjects().domainObjectContainer(NativeImageOptions.class, name -> (BaseNativeImageOptions)project.getObjects().newInstance(BaseNativeImageOptions.class, new Object[]{name, project.getObjects(), project.getProviders(), project.getExtensions().findByType(JavaToolchainService.class), project.getName()}));
        GraalVMExtension graalvmNative = (GraalVMExtension)project.getExtensions().create(GraalVMExtension.class, "graalvmNative", DefaultGraalVmExtension.class, new Object[]{nativeImages, this, project});
        graalvmNative.getGeneratedResourcesDirectory().set(project.getLayout().getBuildDirectory().dir("native/generated/"));
        this.configureNativeConfigurationRepo((ExtensionAware)graalvmNative);
        return graalvmNative;
    }

    private void configureNativeConfigurationRepo(ExtensionAware graalvmNative) {
        JvmReachabilityMetadataRepositoryExtension configurationRepository = (JvmReachabilityMetadataRepositoryExtension)graalvmNative.getExtensions().create("metadataRepository", JvmReachabilityMetadataRepositoryExtension.class, new Object[0]);
        configurationRepository.getEnabled().convention((Object)false);
        configurationRepository.getUri().convention(configurationRepository.getVersion().map(v -> {
            try {
                return new URI("https://github.com/graalvm/jvm-reachability-metadata/releases/download/" + v + "/jvm-reachability-metadata-" + v + ".zip");
            }
            catch (URISyntaxException e) {
                return null;
            }
        }));
        configurationRepository.getExcludedModules().convention(Collections.emptySet());
        configurationRepository.getModuleToConfigVersion().convention(Collections.emptyMap());
    }

    private TaskProvider<GenerateResourcesConfigFile> registerResourcesConfigTask(Provider<Directory> generatedDir, NativeImageOptions options, TaskContainer tasks, FileCollection transitiveProjectArtifacts, String name) {
        return tasks.register(name, GenerateResourcesConfigFile.class, task -> {
            task.setDescription("Generates a GraalVM resource-config.json file");
            task.getOptions().convention((Object)options.getResources());
            task.getClasspath().from(new Object[]{options.getClasspath()});
            task.getTransitiveProjectArtifacts().from(new Object[]{transitiveProjectArtifacts});
            task.getOutputFile().convention(generatedDir.map(d -> d.file(name + "/resource-config.json")));
        });
    }

    public void registerTestBinary(Project project, DefaultGraalVmExtension graalExtension, DefaultTestBinaryConfig config) {
        NativeImageOptions mainOptions = (NativeImageOptions)graalExtension.getBinaries().getByName(NATIVE_MAIN_EXTENSION);
        String name = config.getName();
        boolean isPrimaryTest = NATIVE_TEST_EXTENSION.equals(name);
        TaskContainer tasks = project.getTasks();
        File testResultsDir = GradleUtils.getJavaPluginConvention(project).getTestResultsDir();
        DirectoryProperty testListDirectory = project.getObjects().directoryProperty();
        NativeImageOptions testOptions = NativeImagePlugin.createTestOptions(graalExtension, name, project, mainOptions, testListDirectory, config.getSourceSet());
        if (isPrimaryTest) {
            this.deprecateExtension(project, testOptions, "nativeTest", NATIVE_TEST_EXTENSION);
        }
        TaskProvider<Test> testTask = config.validate().getTestTask();
        testOptions.getAgent().getInstrumentedTask().set(testTask);
        testTask.configure(test -> {
            File testList = new File(testResultsDir, test.getName() + "/testlist");
            testListDirectory.set(testList);
            test.getOutputs().dir((Object)testList);
            test.systemProperty(JUNIT_PLATFORM_LISTENERS_UID_TRACKING_ENABLED, (Object)true);
            TrackingDirectorySystemPropertyProvider directoryProvider = (TrackingDirectorySystemPropertyProvider)project.getObjects().newInstance(TrackingDirectorySystemPropertyProvider.class, new Object[0]);
            directoryProvider.getDirectory().set((Provider)testListDirectory);
            test.getJvmArgumentProviders().add(directoryProvider);
            test.doFirst("cleanup test ids", (Action)new CleanupTestIdsDirectory(testListDirectory));
        });
        NativeImagePlugin.injectTestPluginDependencies(project, graalExtension.getTestSupport());
        TaskProvider testImageBuilder = tasks.named(NativeImagePlugin.deriveTaskName(name, "native", "Compile"), BuildNativeImageTask.class, task -> {
            task.setOnlyIf(t -> (Boolean)graalExtension.getTestSupport().get());
            task.getTestListDirectory().set((Provider)testListDirectory);
            testTask.get();
            ConfigurableFileCollection testList = project.getObjects().fileCollection();
            testList.from(new Object[]{testListDirectory}).builtBy(new Object[]{testTask});
            testOptions.getClasspath().from(new Object[]{testList});
        });
        if (isPrimaryTest) {
            tasks.register(DEPRECATED_NATIVE_TEST_BUILD_TASK, t -> {
                t.dependsOn(new Object[]{testImageBuilder});
                t.doFirst("Warn about deprecation", task -> task.getLogger().warn("Task nativeTestBuild is deprecated. Use nativeTestCompile instead."));
            });
        }
        tasks.named(isPrimaryTest ? "nativeTest" : "native" + NativeImagePlugin.capitalize(name), NativeRunTask.class, task -> {
            task.setGroup("verification");
            task.setOnlyIf(t -> (Boolean)graalExtension.getTestSupport().get());
        });
    }

    private static Provider<Boolean> agentPropertyOverride(Project project, NativeImageOptions extension) {
        return project.getProviders().gradleProperty("agent").forUseAtConfigurationTime().map(v -> {
            if (!v.isEmpty()) {
                return Boolean.valueOf(v);
            }
            return true;
        }).orElse(extension.getAgent().getEnabled());
    }

    private static TaskProvider<ProcessGeneratedGraalResourceFiles> registerProcessAgentFilesTask(Project project, String name) {
        return project.getTasks().register(name, ProcessGeneratedGraalResourceFiles.class, task -> {
            task.getFilterableEntries().convention(Arrays.asList("org.gradle.", "java."));
            task.getOutputDirectory().convention(project.getLayout().getBuildDirectory().dir("native/processed/agent/" + name));
        });
    }

    private static void registerServiceProvider(Project project, Provider<NativeImageService> nativeImageServiceProvider) {
        project.getTasks().withType(BuildNativeImageTask.class).configureEach(task -> {
            task.usesService(nativeImageServiceProvider);
            task.getService().set(nativeImageServiceProvider);
        });
    }

    private static String capitalize(String name) {
        if (name.length() > 0) {
            return name.substring(0, 1).toUpperCase(Locale.US) + name.substring(1);
        }
        return name;
    }

    private static NativeConfigurations createNativeConfigurations(Project project, String binaryName, String baseClasspathConfigurationName) {
        ConfigurationContainer configurations = project.getConfigurations();
        String prefix = NATIVE_MAIN_EXTENSION.equals(binaryName) ? "" : NativeImagePlugin.capitalize(binaryName);
        Configuration baseClasspath = configurations.getByName(baseClasspathConfigurationName);
        Configuration compileOnly = (Configuration)configurations.create("nativeImage" + prefix + "CompileOnly", c -> {
            c.setCanBeResolved(false);
            c.setCanBeConsumed(false);
        });
        Configuration classpath = (Configuration)configurations.create("nativeImage" + prefix + "Classpath", c -> {
            c.setCanBeConsumed(false);
            c.setCanBeResolved(true);
            c.extendsFrom(new Configuration[]{compileOnly});
            baseClasspath.getExtendsFrom().forEach(xva$0 -> c.extendsFrom(new Configuration[]{xva$0}));
            c.attributes(attrs -> {
                AttributeContainer baseAttributes = baseClasspath.getAttributes();
                Iterator iterator = baseAttributes.keySet().iterator();
                while (iterator.hasNext()) {
                    Attribute attribute;
                    Attribute attr = attribute = (Attribute)iterator.next();
                    Object value = baseAttributes.getAttribute(attr);
                    attrs.attribute(attr, value);
                }
            });
        });
        compileOnly.getDependencies().add((Object)project.getDependencies().create((Object)project));
        return new NativeConfigurations(compileOnly, classpath);
    }

    private static NativeImageOptions createMainOptions(GraalVMExtension graalExtension, Project project) {
        NativeImageOptions buildExtension = (NativeImageOptions)graalExtension.getBinaries().create(NATIVE_MAIN_EXTENSION);
        NativeConfigurations configs = NativeImagePlugin.createNativeConfigurations(project, NATIVE_MAIN_EXTENSION, "runtimeClasspath");
        buildExtension.getClasspath().from(new Object[]{configs.getImageClasspathConfiguration()});
        return buildExtension;
    }

    private static NativeImageOptions createTestOptions(GraalVMExtension graalExtension, String binaryName, Project project, NativeImageOptions mainExtension, DirectoryProperty testListDirectory, SourceSet sourceSet) {
        NativeImageOptions testExtension = (NativeImageOptions)graalExtension.getBinaries().create(binaryName);
        NativeConfigurations configs = NativeImagePlugin.createNativeConfigurations(project, binaryName, "testRuntimeClasspath");
        testExtension.getMainClass().set((Object)"org.graalvm.junit.platform.NativeImageJUnitLauncher");
        testExtension.getMainClass().finalizeValue();
        testExtension.getImageName().convention(mainExtension.getImageName().map(name -> name + "-tests"));
        ListProperty<String> runtimeArgs = testExtension.getRuntimeArgs();
        runtimeArgs.add((Object)"--xml-output-dir");
        runtimeArgs.add(project.getLayout().getBuildDirectory().dir("test-results/" + binaryName + "-native").map(d -> d.getAsFile().getAbsolutePath()));
        testExtension.buildArgs("--features=org.graalvm.junit.platform.JUnitPlatformFeature");
        ConfigurableFileCollection classpath = testExtension.getClasspath();
        classpath.from(new Object[]{configs.getImageClasspathConfiguration()});
        classpath.from(new Object[]{sourceSet.getOutput().getClassesDirs()});
        classpath.from(new Object[]{sourceSet.getOutput().getResourcesDir()});
        return testExtension;
    }

    private static void configureAgent(Project project, Map<String, Provider<Boolean>> agents, Provider<Boolean> disableToolchainDetection, NativeImageOptions nativeImageOptions, ExecOperations execOperations, FileSystemOperations fileOperations) {
        String postProcessTaskName = PROCESS_AGENT_RESOURCES_TASK_NAME_PREFIX + NativeImagePlugin.capitalize(nativeImageOptions.getName()) + PROCESS_AGENT_RESOURCES_TASK_NAME_SUFFIX;
        TaskProvider<ProcessGeneratedGraalResourceFiles> postProcessingTask = NativeImagePlugin.registerProcessAgentFilesTask(project, postProcessTaskName);
        TaskProvider instrumentedTask = (TaskProvider)nativeImageOptions.getAgent().getInstrumentedTask().get();
        AgentCommandLineProvider cliProvider = (AgentCommandLineProvider)project.getObjects().newInstance(AgentCommandLineProvider.class, new Object[0]);
        Provider<Boolean> agent = agents.get(nativeImageOptions.getName());
        cliProvider.getEnabled().set(agent);
        Provider outputDir = project.getLayout().getBuildDirectory().dir("native/agent-output/" + instrumentedTask.getName());
        cliProvider.getOutputDirectory().set(outputDir);
        cliProvider.getAgentOptions().set(nativeImageOptions.getAgent().getOptions());
        ((JavaForkOptions)((Task)instrumentedTask.get())).getJvmArgumentProviders().add(cliProvider);
        instrumentedTask.configure(task -> task.doLast((Action)new MergeAgentFiles(agent, NativeImageExecutableLocator.graalvmHomeProvider(project.getProviders()), (Provider<Directory>)outputDir, disableToolchainDetection, nativeImageOptions, execOperations, fileOperations, project.getLogger())));
        ((ProcessGeneratedGraalResourceFiles)((Object)postProcessingTask.get())).getGeneratedFilesDir().set(instrumentedTask.map(t -> (Directory)outputDir.get()));
        ConfigurableFileCollection files = project.getObjects().fileCollection();
        files.from(new Object[]{agent.map(enabled -> enabled != false ? postProcessingTask : project.files(new Object[0]))});
        files.builtBy(new Object[]{() -> (Boolean)agent.get() != false ? (Task)postProcessingTask.get() : null});
        nativeImageOptions.getConfigurationFileDirectories().from(new Object[]{files});
    }

    private static void injectTestPluginDependencies(Project project, Property<Boolean> testSupportEnabled) {
        project.afterEvaluate(p -> {
            if (((Boolean)testSupportEnabled.get()).booleanValue()) {
                project.getDependencies().add("testImplementation", (Object)"org.graalvm.buildtools:junit-platform-native:0.9.11");
            }
        });
    }

    public static abstract class TrackingDirectorySystemPropertyProvider
    implements CommandLineArgumentProvider {
        @OutputDirectory
        public abstract DirectoryProperty getDirectory();

        public Iterable<String> asArguments() {
            return Collections.singleton("-Djunit.platform.listeners.uid.tracking.output.dir=" + ((File)this.getDirectory().getAsFile().get()).getAbsolutePath());
        }
    }

    private static final class CleanupTestIdsDirectory
    implements Action<Task> {
        private final DirectoryProperty directory;

        private CleanupTestIdsDirectory(DirectoryProperty directory) {
            this.directory = directory;
        }

        public void execute(Task task) {
            File dir = (File)this.directory.getAsFile().get();
            if (dir.exists()) {
                GFileUtils.deleteDirectory((File)dir);
            }
        }
    }
}

