/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.graalvm.reachability.JvmReachabilityMetadataRepository;
import org.graalvm.reachability.Query;
import org.graalvm.reachability.internal.FileSystemRepository;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;

public abstract class JvmReachabilityMetadataService
implements BuildService<Params>,
JvmReachabilityMetadataRepository {
    private static final Logger LOGGER = Logging.getLogger(JvmReachabilityMetadataService.class);
    private final JvmReachabilityMetadataRepository repository;

    @Inject
    protected abstract ArchiveOperations getArchiveOperations();

    @Inject
    protected abstract FileSystemOperations getFileOperations();

    public JvmReachabilityMetadataService() throws URISyntaxException {
        URI uri = (URI)((Params)this.getParameters()).getUri().get();
        this.repository = this.newRepository(uri);
    }

    private static String hashFor(URI uri) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] messageDigest = md.digest(md.digest(uri.toString().getBytes("utf-8")));
            BigInteger no = new BigInteger(1, messageDigest);
            StringBuilder digest = new StringBuilder(no.toString(16));
            while (digest.length() < 32) {
                digest.insert(0, "0");
            }
            return digest.toString();
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private JvmReachabilityMetadataRepository newRepository(URI uri) throws URISyntaxException {
        String cacheKey = JvmReachabilityMetadataService.hashFor(uri);
        String path = uri.getPath();
        LogLevel logLevel = (LogLevel)((Params)this.getParameters()).getLogLevel().get();
        if (uri.getScheme().equals("file")) {
            File localFile = new File(uri);
            if (JvmReachabilityMetadataService.isSupportedZipFormat(path)) {
                return this.newRepositoryFromZipFile(cacheKey, localFile, logLevel);
            }
            return this.newRepositoryFromDirectory(localFile.toPath(), logLevel);
        }
        if (JvmReachabilityMetadataService.isSupportedZipFormat(path)) {
            File zipped = ((RegularFile)((Params)this.getParameters()).getCacheDir().file(cacheKey + "/archive").get()).getAsFile();
            if (!zipped.exists()) {
                try (ReadableByteChannel readableByteChannel = Channels.newChannel(uri.toURL().openStream());
                     FileOutputStream fileOutputStream = new FileOutputStream(zipped);){
                    fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.newRepositoryFromZipFile(cacheKey, zipped, logLevel);
        }
        throw new UnsupportedOperationException("Remote URI must point to a zip, a tar.gz or tar.bz2 file");
    }

    private static boolean isSupportedZipFormat(String path) {
        return path.endsWith(".zip") || path.endsWith(".tar.gz") || path.endsWith(".tar.bz2");
    }

    private FileSystemRepository newRepositoryFromZipFile(String cacheKey, File localFile, LogLevel logLevel) {
        File explodedEntry = ((RegularFile)((Params)this.getParameters()).getCacheDir().file(cacheKey + "/exploded").get()).getAsFile();
        if (!explodedEntry.exists() && (explodedEntry.getParentFile().isDirectory() || explodedEntry.getParentFile().mkdirs())) {
            LOGGER.info("Extracting {} to {}", (Object)localFile, (Object)explodedEntry);
            this.getFileOperations().copy(spec -> {
                if (localFile.getName().endsWith(".zip")) {
                    spec.from(new Object[]{this.getArchiveOperations().zipTree((Object)localFile)});
                } else if (localFile.getName().endsWith(".tar.gz")) {
                    spec.from(new Object[]{this.getArchiveOperations().tarTree((Object)localFile)});
                } else if (localFile.getName().endsWith(".tar.bz2")) {
                    spec.from(new Object[]{this.getArchiveOperations().tarTree((Object)localFile)});
                }
                spec.into((Object)explodedEntry);
            });
        }
        return this.newRepositoryFromDirectory(explodedEntry.toPath(), logLevel);
    }

    private FileSystemRepository newRepositoryFromDirectory(Path path, final LogLevel logLevel) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return new FileSystemRepository(path, new FileSystemRepository.Logger(){

                public void log(String groupId, String artifactId, String version, Supplier<String> message) {
                    LOGGER.log(logLevel, "[jvm reachability metadata repository for {}:{}:{}]: {}", new Object[]{groupId, artifactId, version, message.get()});
                }
            });
        }
        throw new IllegalArgumentException("JVM reachability metadata repository URI must point to a directory");
    }

    public Set<Path> findConfigurationDirectoriesFor(Consumer<? super Query> queryBuilder) {
        return this.repository.findConfigurationDirectoriesFor(queryBuilder);
    }

    public Set<Path> findConfigurationDirectoriesFor(String gavCoordinates) {
        return this.repository.findConfigurationDirectoriesFor(gavCoordinates);
    }

    public Set<Path> findConfigurationDirectoriesFor(Collection<String> modules) {
        return this.repository.findConfigurationDirectoriesFor(modules);
    }

    public static interface Params
    extends BuildServiceParameters {
        public Property<LogLevel> getLogLevel();

        public Property<URI> getUri();

        public DirectoryProperty getCacheDir();
    }
}

