/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.internal;

import groovy.json.JsonGenerator;
import groovy.json.JsonOutput;
import groovy.json.JsonSlurper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.FileChange;
import org.gradle.work.InputChanges;

@CacheableTask
public abstract class ProcessGeneratedGraalResourceFiles
extends DefaultTask {
    @InputDirectory
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public abstract DirectoryProperty getGeneratedFilesDir();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDirectory();

    @Input
    public abstract ListProperty<String> getFilterableEntries();

    @TaskAction
    public void filterResources(InputChanges inputChanges) throws IOException {
        block8: {
            File outputDir = ((Directory)this.getOutputDirectory().get()).getAsFile();
            if (!outputDir.isDirectory() && !outputDir.mkdirs()) break block8;
            if (inputChanges.isIncremental()) {
                Iterable fileChanges = inputChanges.getFileChanges((Provider)this.getGeneratedFilesDir());
                for (FileChange change : fileChanges) {
                    switch (change.getChangeType()) {
                        case ADDED: 
                        case MODIFIED: {
                            this.processFile(change.getFile(), outputDir);
                            break;
                        }
                        case REMOVED: {
                            new File(outputDir, change.getFile().getName()).delete();
                        }
                    }
                }
            } else {
                for (File resourceFile : this.getGeneratedFilesDir().getAsFileTree().getFiles()) {
                    this.processFile(resourceFile, outputDir);
                }
            }
        }
    }

    protected void processFile(File file, File outputDir) throws IOException {
        if (file.getName().endsWith(".json")) {
            this.processJsonFile(file, outputDir);
        } else {
            ProcessGeneratedGraalResourceFiles.copyFile(file, outputDir);
        }
    }

    private static void copyFile(File file, File outputDir) throws IOException {
        Files.copy(file.toPath(), outputDir.toPath().resolve(file.getName()), StandardCopyOption.REPLACE_EXISTING);
    }

    protected void processJsonFile(File jsonFile, File outputDir) throws IOException {
        JsonSlurper json = new JsonSlurper();
        Object result = json.parse(jsonFile);
        Object filtered = this.filter(result);
        JsonGenerator generator = new JsonGenerator.Options().build();
        String processed = JsonOutput.prettyPrint((String)generator.toJson(filtered));
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(outputDir, jsonFile.getName())), StandardCharsets.UTF_8);){
            writer.write(processed);
        }
    }

    private Object filter(Object in) {
        Class<?> clazz = in.getClass();
        if (this.shouldFilterString(in)) {
            return null;
        }
        if (List.class.isAssignableFrom(clazz)) {
            return this.filterList((List)in);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return this.filterMap((Map)in);
        }
        return in;
    }

    private Map<Object, Object> filterMap(Map<Object, Object> map) {
        if (this.shouldFilterString(map.get("name"))) {
            return null;
        }
        HashMap<Object, Object> out = new HashMap<Object, Object>(map.size());
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (this.shouldFilterString(value)) continue;
            out.put(key, this.filter(value));
        }
        return out;
    }

    private boolean shouldFilterString(Object value) {
        if (value instanceof CharSequence) {
            String string = value.toString();
            return ((List)this.getFilterableEntries().get()).stream().anyMatch(string::startsWith);
        }
        return false;
    }

    private List<Object> filterList(List<Object> in) {
        ArrayList<Object> out = new ArrayList<Object>(in.size());
        for (Object element : in) {
            Object filtered = this.filter(element);
            if (filtered == null || filtered instanceof Collection && ((Collection)filtered).isEmpty()) continue;
            out.add(filtered);
        }
        return out;
    }
}

