/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.graalvm.buildtools.utils.FileUtils;
import org.graalvm.reachability.DirectoryConfiguration;
import org.graalvm.reachability.GraalVMReachabilityMetadataRepository;
import org.graalvm.reachability.Query;
import org.graalvm.reachability.internal.FileSystemRepository;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;

public abstract class GraalVMReachabilityMetadataService
implements BuildService<Params>,
GraalVMReachabilityMetadataRepository {
    private static final Logger LOGGER = Logging.getLogger(GraalVMReachabilityMetadataService.class);
    private final GraalVMReachabilityMetadataRepository repository;

    @Inject
    protected abstract ArchiveOperations getArchiveOperations();

    @Inject
    protected abstract FileSystemOperations getFileOperations();

    public GraalVMReachabilityMetadataService() throws URISyntaxException {
        URI uri = (URI)((Params)this.getParameters()).getUri().get();
        this.repository = this.newRepository(uri);
    }

    private GraalVMReachabilityMetadataRepository newRepository(URI uri) throws URISyntaxException {
        String cacheKey = FileUtils.hashFor((URI)uri);
        String path = uri.getPath();
        LogLevel logLevel = (LogLevel)((Params)this.getParameters()).getLogLevel().get();
        if (uri.getScheme().equals("file")) {
            File localFile = new File(uri);
            if (FileSystemRepository.isSupportedArchiveFormat((String)path)) {
                return this.newRepositoryFromZipFile(cacheKey, localFile, logLevel);
            }
            return this.newRepositoryFromDirectory(localFile.toPath(), logLevel);
        }
        String format = FileSystemRepository.getArchiveFormat((String)path);
        if (format != null) {
            File zipped = ((RegularFile)((Params)this.getParameters()).getCacheDir().file(cacheKey + "/archive" + format).get()).getAsFile();
            if (!zipped.exists()) {
                File cacheDirParent = zipped.getParentFile();
                if (cacheDirParent.exists()) {
                    if (!cacheDirParent.isDirectory()) {
                        throw new RuntimeException("Cache directory path must not exist or must be a directory: " + cacheDirParent.getAbsolutePath());
                    }
                } else {
                    try {
                        Files.createDirectories(cacheDirParent.toPath(), new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                try (ReadableByteChannel readableByteChannel = Channels.newChannel(uri.toURL().openStream());
                     FileOutputStream fileOutputStream = new FileOutputStream(zipped);){
                    fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.newRepositoryFromZipFile(cacheKey, zipped, logLevel);
        }
        throw new UnsupportedOperationException("Remote URI must point to a zip, a tar.gz or tar.bz2 file");
    }

    private FileSystemRepository newRepositoryFromZipFile(String cacheKey, File localFile, LogLevel logLevel) {
        File explodedEntry = ((RegularFile)((Params)this.getParameters()).getCacheDir().file(cacheKey + "/exploded").get()).getAsFile();
        if (!explodedEntry.exists() && (explodedEntry.getParentFile().isDirectory() || explodedEntry.getParentFile().mkdirs())) {
            LOGGER.info("Extracting {} to {}", (Object)localFile, (Object)explodedEntry);
            this.getFileOperations().copy(spec -> {
                if (localFile.getName().endsWith(".zip")) {
                    spec.from(new Object[]{this.getArchiveOperations().zipTree((Object)localFile)});
                } else if (localFile.getName().endsWith(".tar.gz")) {
                    spec.from(new Object[]{this.getArchiveOperations().tarTree((Object)localFile)});
                } else if (localFile.getName().endsWith(".tar.bz2")) {
                    spec.from(new Object[]{this.getArchiveOperations().tarTree((Object)localFile)});
                }
                spec.into((Object)explodedEntry);
            });
        }
        return this.newRepositoryFromDirectory(explodedEntry.toPath(), logLevel);
    }

    private FileSystemRepository newRepositoryFromDirectory(Path path, final LogLevel logLevel) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return new FileSystemRepository(path, new FileSystemRepository.Logger(){

                public void log(String groupId, String artifactId, String version, Supplier<String> message) {
                    LOGGER.log(logLevel, "[graalvm reachability metadata repository for {}:{}:{}]: {}", new Object[]{groupId, artifactId, version, message.get()});
                }
            });
        }
        throw new IllegalArgumentException("GraalVM reachability metadata repository URI must point to a directory");
    }

    public Set<DirectoryConfiguration> findConfigurationsFor(Consumer<? super Query> queryBuilder) {
        return this.repository.findConfigurationsFor(queryBuilder);
    }

    public Set<DirectoryConfiguration> findConfigurationsFor(String gavCoordinates) {
        return this.repository.findConfigurationsFor(gavCoordinates);
    }

    public Set<DirectoryConfiguration> findConfigurationsFor(Collection<String> modules) {
        return this.repository.findConfigurationsFor(modules);
    }

    public Set<DirectoryConfiguration> findConfigurationsFor(Set<String> excludedModules, Map<String, String> forcedVersions, ModuleVersionIdentifier moduleVersion) {
        Objects.requireNonNull(moduleVersion);
        String groupAndArtifact = moduleVersion.getGroup() + ":" + moduleVersion.getName();
        return this.findConfigurationsFor((? super Query query) -> {
            if (!excludedModules.contains(groupAndArtifact)) {
                query.forArtifact(artifact -> {
                    artifact.gav(groupAndArtifact + ":" + moduleVersion.getVersion());
                    if (forcedVersions.containsKey(groupAndArtifact)) {
                        artifact.forceConfigVersion((String)forcedVersions.get(groupAndArtifact));
                    }
                });
            }
            query.useLatestConfigWhenVersionIsUntested();
        });
    }

    public static interface Params
    extends BuildServiceParameters {
        public Property<LogLevel> getLogLevel();

        public Property<URI> getUri();

        public DirectoryProperty getCacheDir();
    }
}

