/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.utils;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class DynamicAccessMetadataUtils {
    public static Set<String> readArtifacts(File inputFile) throws IOException {
        LinkedHashSet<String> artifacts = new LinkedHashSet<String>();
        String content = Files.readString(inputFile.toPath());
        JSONArray jsonArray = new JSONArray(content);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject entry = jsonArray.getJSONObject(i);
            if (!entry.has("artifact")) continue;
            artifacts.add(entry.getString("artifact"));
        }
        return artifacts;
    }

    public static void serialize(File outputFile, Map<String, Set<String>> exportMap) throws IOException {
        JSONArray jsonArray = new JSONArray();
        for (Map.Entry<String, Set<String>> entry : exportMap.entrySet()) {
            JSONObject obj = new JSONObject();
            obj.put("metadataProvider", (Object)entry.getKey());
            JSONArray providedArray = new JSONArray();
            entry.getValue().forEach(arg_0 -> ((JSONArray)providedArray).put(arg_0));
            obj.put("providesFor", (Object)providedArray);
            jsonArray.put((Object)obj);
        }
        try (FileWriter writer = new FileWriter(outputFile);){
            writer.write(jsonArray.toString(2));
        }
    }
}

