/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.gradle.plugins.docker;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.internal.os.OperatingSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.gradle.plugins.docker.DockerRegistryContainer;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001eB)\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0019\u001a\u00020\u0005H\u0016J\u0014\u0010\u0007\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001cJ\u0006\u0010\u001d\u001a\u00020\u001aJ\u0014\u0010\u001d\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001cR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/gradle/plugins/docker/DockerExtension;", "Lorg/gradle/api/Named;", "Lorg/gradle/api/plugins/ExtensionAware;", "file", "Lkotlin/Function1;", "", "Ljava/io/File;", "registries", "Lorg/jetbrains/gradle/plugins/docker/DockerRegistryContainer;", "name", "(Lkotlin/jvm/functions/Function1;Lorg/jetbrains/gradle/plugins/docker/DockerRegistryContainer;Ljava/lang/String;)V", "getRegistries", "()Lorg/jetbrains/gradle/plugins/docker/DockerRegistryContainer;", "remoteConfigBuilder", "Lorg/jetbrains/gradle/plugins/docker/DockerExtension$Remote;", "getRemoteConfigBuilder$package_search_gradle_plugins", "()Lorg/jetbrains/gradle/plugins/docker/DockerExtension$Remote;", "setRemoteConfigBuilder$package_search_gradle_plugins", "(Lorg/jetbrains/gradle/plugins/docker/DockerExtension$Remote;)V", "showLogs", "", "getShowLogs", "()Z", "setShowLogs", "(Z)V", "getName", "", "action", "Lorg/gradle/api/Action;", "useDockerRestApi", "Remote", "package-search-gradle-plugins"})
public abstract class DockerExtension
implements Named,
ExtensionAware {
    @Nullable
    private Remote remoteConfigBuilder;
    private boolean showLogs;
    private final Function1<String, File> file;
    @NotNull
    private final DockerRegistryContainer registries;
    private final String name;

    @Nullable
    public final Remote getRemoteConfigBuilder$package_search_gradle_plugins() {
        return this.remoteConfigBuilder;
    }

    public final void setRemoteConfigBuilder$package_search_gradle_plugins(@Nullable Remote remote) {
        this.remoteConfigBuilder = remote;
    }

    public final boolean getShowLogs() {
        return this.showLogs;
    }

    public final void setShowLogs(boolean bl) {
        this.showLogs = bl;
    }

    public final void registries(@NotNull Action<DockerRegistryContainer> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        action.execute((Object)this.registries);
    }

    public final void useDockerRestApi(@NotNull Action<Remote> action) {
        block0: {
            Remote remote;
            Intrinsics.checkNotNullParameter(action, (String)"action");
            this.useDockerRestApi();
            Remote remote2 = this.remoteConfigBuilder;
            if (remote2 == null) break block0;
            Remote it = remote = remote2;
            boolean bl = false;
            action.execute((Object)it);
        }
    }

    public final void useDockerRestApi() {
        if (this.remoteConfigBuilder == null) {
            this.remoteConfigBuilder = new Remote(this.file);
        }
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final DockerRegistryContainer getRegistries() {
        return this.registries;
    }

    public DockerExtension(@NotNull Function1<? super String, ? extends File> file, @NotNull DockerRegistryContainer registries, @NotNull String name) {
        Intrinsics.checkNotNullParameter(file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.file = file;
        this.registries = registries;
        this.name = name;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/gradle/plugins/docker/DockerExtension$Remote;", "", "file", "Lkotlin/Function1;", "", "Ljava/io/File;", "(Lkotlin/jvm/functions/Function1;)V", "dockerCertPath", "getDockerCertPath", "()Ljava/io/File;", "setDockerCertPath", "(Ljava/io/File;)V", "host", "getHost", "()Ljava/lang/String;", "setHost", "(Ljava/lang/String;)V", "useTsl", "", "getUseTsl", "()Z", "setUseTsl", "(Z)V", "dockerCertFile", "", "path", "package-search-gradle-plugins"})
    public static final class Remote {
        @NotNull
        private String host;
        private boolean useTsl;
        @Nullable
        private File dockerCertPath;
        private final Function1<String, File> file;

        @NotNull
        public final String getHost() {
            return this.host;
        }

        public final void setHost(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.host = string;
        }

        public final boolean getUseTsl() {
            return this.useTsl;
        }

        public final void setUseTsl(boolean bl) {
            this.useTsl = bl;
        }

        @Nullable
        public final File getDockerCertPath() {
            return this.dockerCertPath;
        }

        public final void setDockerCertPath(@Nullable File file) {
            this.dockerCertPath = file;
        }

        public final void dockerCertFile(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.dockerCertPath = (File)this.file.invoke((Object)path);
        }

        public Remote(@NotNull Function1<? super String, ? extends File> file) {
            Intrinsics.checkNotNullParameter(file, (String)"file");
            this.file = file;
            OperatingSystem operatingSystem = OperatingSystem.current();
            Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"OperatingSystem.current()");
            this.host = operatingSystem.isWindows() ? "tcp://localhost:2375" : "unix:///var/run/docker.sock";
        }
    }
}

