/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.gradle.plugins.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import java.io.File;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.kotlin.dsl.TaskContainerScope;
import org.gradle.process.ExecResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.gradle.plugins.PluginUtilsKt;
import org.jetbrains.gradle.plugins.docker.DockerExtension;
import org.jetbrains.gradle.plugins.docker.DockerImage;
import org.jetbrains.gradle.plugins.docker.DockerRegistryCredentials;
import org.jetbrains.gradle.plugins.docker.UtilsKt;
import org.jetbrains.gradle.plugins.docker.tasks.DockerBuild;
import org.jetbrains.gradle.plugins.docker.tasks.DockerBuildSpec;
import org.jetbrains.gradle.plugins.docker.tasks.DockerExecLogin;
import org.jetbrains.gradle.plugins.docker.tasks.DockerExecPush;
import org.jetbrains.gradle.plugins.docker.tasks.DockerPush;
import org.jetbrains.gradle.plugins.docker.tasks.DockerPushSpec;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000j\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0016\u0010\u0007\u001a\u00020\b*\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0000\u001a;\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u00a2\u0006\u0002\b\u0015H\u0000\u001aS\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000b*\u00020\r2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u000f2\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00140\u0012\u00a2\u0006\u0002\b\u00152\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\bH\u0000\u001aJ\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000b*\u00020\r2\u0006\u0010\u0019\u001a\u00020\u000f2\u000e\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020!0\u000b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\bH\u0000\u00a8\u0006$"}, d2={"buildDockerHttpClient", "Lcom/github/dockerjava/api/DockerClient;", "Lorg/gradle/api/Project;", "repo", "Lorg/jetbrains/gradle/plugins/docker/DockerRegistryCredentials;", "dockerRemoteConfig", "Lorg/jetbrains/gradle/plugins/docker/DockerExtension$Remote;", "isDockerPresent", "", "remoteConfigBuilder", "registerDockerBuild", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/jetbrains/gradle/plugins/docker/tasks/DockerBuild;", "Lorg/gradle/kotlin/dsl/TaskContainerScope;", "dockerBuildTaskName", "", "remoteConfig", "buildSpec", "Lkotlin/Function1;", "Lorg/jetbrains/gradle/plugins/docker/tasks/DockerBuildSpec;", "", "Lkotlin/ExtensionFunctionType;", "registerDockerExecPush", "Lorg/jetbrains/gradle/plugins/docker/tasks/DockerExecPush;", "repoName", "dockerPushTaskName", "dockerPushSpec", "Lorg/jetbrains/gradle/plugins/docker/tasks/DockerPushSpec;", "rootProject", "showLogs", "registerDockerPush", "Lorg/jetbrains/gradle/plugins/docker/tasks/DockerPush;", "dockerImageBuild", "Lorg/gradle/api/Task;", "imageData", "Lorg/jetbrains/gradle/plugins/docker/DockerImage;", "package-search-gradle-plugins"})
public final class UtilsKt {
    @NotNull
    public static final DockerClient buildDockerHttpClient(@NotNull Project $this$buildDockerHttpClient, @Nullable DockerRegistryCredentials repo, @NotNull DockerExtension.Remote dockerRemoteConfig) {
        ApacheDockerHttpClient.Builder builder;
        DefaultDockerClientConfig.Builder builder2;
        Intrinsics.checkNotNullParameter((Object)$this$buildDockerHttpClient, (String)"$this$buildDockerHttpClient");
        Intrinsics.checkNotNullParameter((Object)dockerRemoteConfig, (String)"dockerRemoteConfig");
        DefaultDockerClientConfig.Builder $this$apply = builder2 = DefaultDockerClientConfig.createDefaultConfigBuilder();
        boolean bl = false;
        $this$apply.withDockerHost(dockerRemoteConfig.getHost());
        $this$apply.withDockerTlsVerify(Boolean.valueOf(dockerRemoteConfig.getUseTsl()));
        if (repo != null) {
            Object it;
            Object object;
            File file = dockerRemoteConfig.getDockerCertPath();
            if (file != null) {
                it = object = file;
                boolean bl2 = false;
                $this$apply.withDockerCertPath(((File)it).getAbsolutePath());
            }
            it = object = repo.getUrl();
            DefaultDockerClientConfig.Builder builder3 = $this$apply;
            boolean bl3 = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl4 = charSequence.length() > 0;
            Object object2 = bl4 ? object : null;
            if (object2 == null) {
                object = "Docker Repository " + repo.getName() + " has an empty url";
                throw new IllegalStateException(object.toString());
            }
            builder3.withRegistryUrl((String)object2);
            Object object3 = repo.getUsername();
            if (object3 != null) {
                it = object = object3;
                boolean bl5 = false;
                charSequence = (CharSequence)it;
                object3 = charSequence.length() > 0 ? object : null;
                if (object3 != null) {
                    it = object = object3;
                    boolean bl6 = false;
                    $this$apply.withRegistryUsername((String)it);
                }
            }
            $this$apply.withRegistryPassword(repo.getPassword());
            Object object4 = repo.getEmail();
            if (object4 != null) {
                it = object = object4;
                boolean bl7 = false;
                charSequence = (CharSequence)it;
                object4 = charSequence.length() > 0 ? object : null;
                if (object4 != null) {
                    it = object = object4;
                    boolean bl8 = false;
                    $this$apply.withRegistryEmail((String)it);
                }
            }
            if (repo.getUsername() == null && repo.getEmail() == null) {
                $this$buildDockerHttpClient.getLogger().warn("Username and email for registry " + repo.getName() + " are both null, skipping login.");
            }
        }
        DefaultDockerClientConfig config = builder2.build();
        ApacheDockerHttpClient.Builder $this$apply2 = builder = new ApacheDockerHttpClient.Builder();
        boolean bl9 = false;
        DefaultDockerClientConfig defaultDockerClientConfig = config;
        Intrinsics.checkNotNullExpressionValue((Object)defaultDockerClientConfig, (String)"config");
        $this$apply2.dockerHost(defaultDockerClientConfig.getDockerHost());
        $this$apply2.sslConfig((SSLConfig)config.getSSLConfig());
        ApacheDockerHttpClient httpClient = builder.build();
        DockerClient dockerClient = DockerClientImpl.getInstance((DockerClientConfig)((DockerClientConfig)config), (DockerHttpClient)((DockerHttpClient)httpClient));
        Intrinsics.checkNotNullExpressionValue((Object)dockerClient, (String)"DockerClientImpl.getInstance(config, httpClient)");
        return dockerClient;
    }

    public static final boolean isDockerPresent(@NotNull Project $this$isDockerPresent, @Nullable DockerExtension.Remote remoteConfigBuilder) {
        Object object;
        Object $this$runCatching;
        Intrinsics.checkNotNullParameter((Object)$this$isDockerPresent, (String)"$this$isDockerPresent");
        Object object2 = $this$isDockerPresent;
        try {
            Object object3;
            block9: {
                block8: {
                    DockerExtension.Remote remote;
                    $this$runCatching = object2;
                    boolean bl = false;
                    object3 = remoteConfigBuilder;
                    if (object3 == null) break block8;
                    DockerExtension.Remote remoteConfig = remote = object3;
                    boolean bl2 = false;
                    object3 = (Void)UtilsKt.buildDockerHttpClient($this$runCatching, null, remoteConfig).pingCmd().exec();
                    if (object3 != null) break block9;
                }
                ExecResult execResult = $this$runCatching.exec((Action)isDockerPresent.1.2.INSTANCE);
                object3 = execResult;
                Intrinsics.checkNotNullExpressionValue((Object)execResult, (String)"exec {\n            execu\u2026lOutputStream()\n        }");
            }
            $this$runCatching = Result.constructor-impl((Object)object3);
        }
        catch (Throwable bl) {
            $this$runCatching = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$runCatching;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            $this$runCatching = throwable;
            Object it = bl = $this$runCatching;
            boolean bl = false;
            $this$isDockerPresent.getLogger().warn("Docker not available: " + ((Throwable)it).getMessage());
        }
        if (Result.isSuccess-impl((Object)object2)) {
            Project it = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)true);
        } else {
            object = Result.constructor-impl((Object)object2);
        }
        object2 = object;
        Boolean bl = false;
        return Result.isFailure-impl((Object)object2) ? bl : object2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final TaskProvider<DockerBuild> registerDockerBuild(@NotNull TaskContainerScope $this$registerDockerBuild, @NotNull String dockerBuildTaskName, @NotNull DockerExtension.Remote remoteConfig, @NotNull Function1<? super DockerBuildSpec, Unit> buildSpec) {
        void $this$register$iv;
        Intrinsics.checkNotNullParameter((Object)$this$registerDockerBuild, (String)"$this$registerDockerBuild");
        Intrinsics.checkNotNullParameter((Object)dockerBuildTaskName, (String)"dockerBuildTaskName");
        Intrinsics.checkNotNullParameter((Object)remoteConfig, (String)"remoteConfig");
        Intrinsics.checkNotNullParameter(buildSpec, (String)"buildSpec");
        TaskContainer taskContainer = (TaskContainer)$this$registerDockerBuild;
        Function1 configuration$iv = (Function1)new Function1<DockerBuild, Unit>(remoteConfig, buildSpec){
            final /* synthetic */ DockerExtension.Remote $remoteConfig;
            final /* synthetic */ Function1 $buildSpec;

            public final void invoke(@NotNull DockerBuild $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$receiver");
                Project project = $this$register.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                $this$register.setClient(UtilsKt.buildDockerHttpClient(project, null, this.$remoteConfig));
                this.$buildSpec.invoke((Object)$this$register);
            }
            {
                this.$remoteConfig = remote;
                this.$buildSpec = function1;
                super(1);
            }
        };
        boolean $i$f$register = false;
        Function1 function1 = configuration$iv;
        TaskProvider taskProvider = $this$register$iv.register(dockerBuildTaskName, DockerBuild.class, new Action(function1){
            private final /* synthetic */ Function1 function;
            {
                this.function = function1;
            }

            public final /* synthetic */ void execute(Object p0) {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(p0), (String)"invoke(...)");
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final TaskProvider<DockerPush> registerDockerPush(@NotNull TaskContainerScope $this$registerDockerPush, @NotNull String dockerPushTaskName, @NotNull TaskProvider<? extends Task> dockerImageBuild, @NotNull DockerRegistryCredentials repo, @NotNull DockerImage imageData, @NotNull DockerExtension.Remote remoteConfig, boolean showLogs) {
        void $this$register$iv;
        Intrinsics.checkNotNullParameter((Object)$this$registerDockerPush, (String)"$this$registerDockerPush");
        Intrinsics.checkNotNullParameter((Object)dockerPushTaskName, (String)"dockerPushTaskName");
        Intrinsics.checkNotNullParameter(dockerImageBuild, (String)"dockerImageBuild");
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Intrinsics.checkNotNullParameter((Object)imageData, (String)"imageData");
        Intrinsics.checkNotNullParameter((Object)remoteConfig, (String)"remoteConfig");
        TaskContainer taskContainer = (TaskContainer)$this$registerDockerPush;
        Function1 configuration$iv = (Function1)new Function1<DockerPush, Unit>(dockerImageBuild, repo, imageData, remoteConfig, showLogs){
            final /* synthetic */ TaskProvider $dockerImageBuild;
            final /* synthetic */ DockerRegistryCredentials $repo;
            final /* synthetic */ DockerImage $imageData;
            final /* synthetic */ DockerExtension.Remote $remoteConfig;
            final /* synthetic */ boolean $showLogs;

            public final void invoke(@NotNull DockerPush $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$receiver");
                $this$register.dependsOn(new Object[]{this.$dockerImageBuild});
                $this$register.setImageTag(PluginUtilsKt.suffixIfNot(this.$repo.getImageNamePrefix(), "/") + this.$imageData.getImageNameWithTag());
                Project project = $this$register.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                $this$register.setClient(UtilsKt.buildDockerHttpClient(project, this.$repo, this.$remoteConfig));
                if (!this.$showLogs) {
                    $this$register.getLogging().captureStandardOutput(LogLevel.INFO);
                    $this$register.getLogging().captureStandardError(LogLevel.INFO);
                }
            }
            {
                this.$dockerImageBuild = taskProvider;
                this.$repo = dockerRegistryCredentials;
                this.$imageData = dockerImage;
                this.$remoteConfig = remote;
                this.$showLogs = bl;
                super(1);
            }
        };
        boolean $i$f$register = false;
        Function1 function1 = configuration$iv;
        TaskProvider taskProvider = $this$register$iv.register(dockerPushTaskName, DockerPush.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
        return taskProvider;
    }

    @NotNull
    public static final TaskProvider<DockerExecPush> registerDockerExecPush(@NotNull TaskContainerScope $this$registerDockerExecPush, @NotNull String repoName, @NotNull DockerRegistryCredentials repo, @NotNull String dockerPushTaskName, @NotNull Function1<? super DockerPushSpec, Unit> dockerPushSpec, @NotNull Project rootProject, boolean showLogs) {
        TaskContainer $this$register$iv;
        Function1 function1;
        boolean $i$f$register;
        Function1 configuration$iv;
        Intrinsics.checkNotNullParameter((Object)$this$registerDockerExecPush, (String)"$this$registerDockerExecPush");
        Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Intrinsics.checkNotNullParameter((Object)dockerPushTaskName, (String)"dockerPushTaskName");
        Intrinsics.checkNotNullParameter(dockerPushSpec, (String)"dockerPushSpec");
        Intrinsics.checkNotNullParameter((Object)rootProject, (String)"rootProject");
        String dockerLoginTaskName = "docker" + repoName + "Login";
        Task task = (Task)rootProject.getTasks().findByName(dockerLoginTaskName);
        if (task == null) {
            TaskContainer taskContainer = rootProject.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"rootProject.tasks");
            TaskContainer taskContainer2 = taskContainer;
            configuration$iv = (Function1)new Function1<DockerExecLogin, Unit>(repo){
                final /* synthetic */ DockerRegistryCredentials $repo;

                public final void invoke(@NotNull DockerExecLogin $this$register) {
                    String string;
                    DockerExecLogin dockerExecLogin;
                    block6: {
                        boolean bl;
                        CharSequence charSequence;
                        String it;
                        DockerExecLogin dockerExecLogin2;
                        String string2;
                        block5: {
                            Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$receiver");
                            $this$register.setUrl(this.$repo.getUrl());
                            dockerExecLogin = $this$register;
                            string = this.$repo.getUsername();
                            if (string == null) break block5;
                            String string3 = string2 = string;
                            dockerExecLogin2 = dockerExecLogin;
                            boolean bl2 = false;
                            charSequence = it;
                            bl = charSequence.length() > 0;
                            dockerExecLogin = dockerExecLogin2;
                            string = bl ? string2 : null;
                            if (string != null) break block6;
                        }
                        String string4 = this.$repo.getEmail();
                        if (string4 != null) {
                            it = string2 = string4;
                            dockerExecLogin2 = dockerExecLogin;
                            boolean bl3 = false;
                            charSequence = it;
                            bl = charSequence.length() > 0;
                            dockerExecLogin = dockerExecLogin2;
                            string = bl ? string2 : null;
                        } else {
                            string = null;
                        }
                    }
                    dockerExecLogin.setUsername(string);
                    $this$register.setPassword(this.$repo.getPassword());
                }
                {
                    this.$repo = dockerRegistryCredentials;
                    super(1);
                }
            };
            $i$f$register = false;
            function1 = configuration$iv;
            TaskProvider taskProvider = $this$register$iv.register(dockerLoginTaskName, DockerExecLogin.class, new /* invalid duplicate definition of identical inner class */);
            task = taskProvider;
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
        }
        Task dockerLogin2 = task;
        $this$register$iv = (TaskContainer)$this$registerDockerExecPush;
        configuration$iv = (Function1)new Function1<DockerExecPush, Unit>((Object)dockerLogin2, dockerPushSpec, showLogs){
            final /* synthetic */ Object $dockerLogin;
            final /* synthetic */ Function1 $dockerPushSpec;
            final /* synthetic */ boolean $showLogs;

            public final void invoke(@NotNull DockerExecPush $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$receiver");
                $this$register.dependsOn(new Object[]{this.$dockerLogin});
                this.$dockerPushSpec.invoke((Object)$this$register);
                if (!this.$showLogs) {
                    $this$register.getLogging().captureStandardOutput(LogLevel.INFO);
                    $this$register.getLogging().captureStandardError(LogLevel.INFO);
                }
            }
            {
                this.$dockerLogin = object;
                this.$dockerPushSpec = function1;
                this.$showLogs = bl;
                super(1);
            }
        };
        $i$f$register = false;
        function1 = configuration$iv;
        TaskProvider taskProvider = $this$register$iv.register(dockerPushTaskName, DockerExecPush.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
        return taskProvider;
    }
}

