/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.gradle.plugins.terraform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ContentFilterable;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.internal.os.OperatingSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.gradle.plugins.terraform.TerraformModuleMetadata;
import org.jetbrains.gradle.plugins.terraform.TerraformSourceSet;
import org.jetbrains.gradle.plugins.terraform.UtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0012\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\tH\u0000\u001a\u001a\u0010\n\u001a\u00020\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\bH\u0000\u00a8\u0006\u000f"}, d2={"computeTerraformModuleName", "", "version", "evaluateTerraformName", "generateTerraformDetachedConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "Lorg/gradle/api/Project;", "getSourceDependencies", "", "Lorg/jetbrains/gradle/plugins/terraform/TerraformSourceSet;", "resolveModules", "Lorg/gradle/api/file/ContentFilterable;", "Lorg/gradle/api/file/FileCopyDetails;", "availableModules", "Lorg/jetbrains/gradle/plugins/terraform/TerraformModuleMetadata;", "package-search-gradle-plugins"})
public final class UtilsKt {
    @NotNull
    public static final String evaluateTerraformName(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        StringBuilder stringBuilder = new StringBuilder().append("terraform_").append(version);
        OperatingSystem operatingSystem = OperatingSystem.current();
        Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"OperatingSystem.current()");
        return stringBuilder.append(operatingSystem.isWindows() ? ".exe" : "").toString();
    }

    @NotNull
    public static final String computeTerraformModuleName(@NotNull String version) {
        String string;
        boolean bl;
        String archProperty;
        String osName;
        block15: {
            String string2;
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            OperatingSystem operatingSystem = OperatingSystem.current();
            Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"OperatingSystem.current()");
            OperatingSystem currentOs = operatingSystem;
            if (currentOs.isWindows()) {
                string2 = "windows";
            } else if (currentOs.isMacOsX()) {
                string2 = "darwin";
            } else if (currentOs.isLinux()) {
                string2 = "linux";
            } else {
                String string3 = "OS \"" + currentOs + "\" not supported by Terraform plugin";
                throw new IllegalStateException(string3.toString());
            }
            osName = string2;
            String string4 = System.getProperty("os.arch");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"System.getProperty(\"os.arch\")");
            archProperty = string4;
            Iterable $this$any$iv = CollectionsKt.listOf((Object[])new String[]{"arm", "aarch"});
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)archProperty, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        if (bl) {
            string = StringsKt.contains$default((CharSequence)archProperty, (CharSequence)"64", (boolean)false, (int)2, null) ? "arm64" : "arm";
        } else if (StringsKt.contains$default((CharSequence)archProperty, (CharSequence)"amd64", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)archProperty, (CharSequence)"x86_64", (boolean)false, (int)2, null)) {
            string = "amd64";
        } else if (StringsKt.contains$default((CharSequence)archProperty, (CharSequence)"386", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)archProperty, (CharSequence)"x86", (boolean)false, (int)2, null)) {
            string = "386";
        } else {
            String string5 = "OS architecture \"" + archProperty + "\" not supported by Terraform plugin";
            throw new IllegalStateException(string5.toString());
        }
        String arch = string;
        return "hashicorp:terraform:" + version + ':' + osName + '_' + arch;
    }

    @NotNull
    public static final Configuration generateTerraformDetachedConfiguration(@NotNull Project $this$generateTerraformDetachedConfiguration, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)$this$generateTerraformDetachedConfiguration, (String)"$this$generateTerraformDetachedConfiguration");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Dependency dependency = $this$generateTerraformDetachedConfiguration.getDependencies().create((Object)UtilsKt.computeTerraformModuleName(version));
        Intrinsics.checkNotNullExpressionValue((Object)dependency, (String)"dependencies.create(comp\u2026aformModuleName(version))");
        Dependency dependency2 = dependency;
        Configuration configuration = $this$generateTerraformDetachedConfiguration.getConfigurations().detachedConfiguration(new Dependency[]{dependency2});
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"configurations.detachedConfiguration(dependency)");
        return configuration;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<TerraformSourceSet> getSourceDependencies(@NotNull TerraformSourceSet $this$getSourceDependencies) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)$this$getSourceDependencies, (String)"$this$getSourceDependencies");
        Set visited = new LinkedHashSet();
        List queue = CollectionsKt.toMutableList((Collection)$this$getSourceDependencies.getDependsOn());
        while (!(collection = (Collection)queue).isEmpty()) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            TerraformSourceSet currentSourceSet = (TerraformSourceSet)queue.remove(0);
            visited.add(currentSourceSet);
            Iterable iterable = currentSourceSet.getDependsOn();
            List list = queue;
            boolean $i$f$filter = false;
            void var6_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TerraformSourceSet it = (TerraformSourceSet)element$iv$iv;
                boolean bl = false;
                if (!(!visited.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            list.addAll(list2);
        }
        return visited;
    }

    @NotNull
    public static final ContentFilterable resolveModules(@NotNull FileCopyDetails $this$resolveModules, @NotNull Set<TerraformModuleMetadata> availableModules) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveModules, (String)"$this$resolveModules");
        Intrinsics.checkNotNullParameter(availableModules, (String)"availableModules");
        ContentFilterable contentFilterable = $this$resolveModules.filter(new Transformer($this$resolveModules, availableModules){
            final /* synthetic */ FileCopyDetails $this_resolveModules;
            final /* synthetic */ Set $availableModules;

            /*
             * Unable to fully structure code
             */
            @NotNull
            public final String transform(@NotNull String line) {
                block7: {
                    block6: {
                        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                        hasSourceKeyword = StringsKt.contains$default((CharSequence)line, (CharSequence)"source", (boolean)false, (int)2, null);
                        var4_3 = null;
                        substring1 = LazyKt.lazy((Function0)((Function0)new Function0<String>(line){
                            final /* synthetic */ String $line;

                            @NotNull
                            public final String invoke() {
                                String string = this.$line;
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"line");
                                return StringsKt.substringAfter$default((String)string, (String)"source", null, (int)2, null);
                            }
                            {
                                this.$line = string;
                                super(0);
                            }
                        }));
                        var6_5 = null;
                        hasEqualsAfterSource = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(substring1, var4_3){
                            final /* synthetic */ Lazy $substring1;
                            final /* synthetic */ KProperty $substring1$metadata;

                            public final boolean invoke() {
                                Lazy lazy = this.$substring1;
                                Object var2_2 = null;
                                KProperty kProperty = this.$substring1$metadata;
                                return StringsKt.contains$default((CharSequence)((CharSequence)lazy.getValue()), (CharSequence)"=", (boolean)false, (int)2, null);
                            }
                            {
                                this.$substring1 = lazy;
                                this.$substring1$metadata = kProperty;
                                super(0);
                            }
                        }));
                        var8_7 = null;
                        substring2 = LazyKt.lazy((Function0)((Function0)new Function0<String>(substring1, var4_3){
                            final /* synthetic */ Lazy $substring1;
                            final /* synthetic */ KProperty $substring1$metadata;

                            @NotNull
                            public final String invoke() {
                                Lazy lazy = this.$substring1;
                                Object var2_2 = null;
                                KProperty kProperty = this.$substring1$metadata;
                                return StringsKt.substringAfter$default((String)((String)lazy.getValue()), (String)"=", null, (int)2, null);
                            }
                            {
                                this.$substring1 = lazy;
                                this.$substring1$metadata = kProperty;
                                super(0);
                            }
                        }));
                        var10_9 = null;
                        hasModulesKeyword = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(substring2, var8_7){
                            final /* synthetic */ Lazy $substring2;
                            final /* synthetic */ KProperty $substring2$metadata;

                            public final boolean invoke() {
                                Lazy lazy = this.$substring2;
                                Object var2_2 = null;
                                KProperty kProperty = this.$substring2$metadata;
                                return StringsKt.contains$default((CharSequence)((CharSequence)lazy.getValue()), (CharSequence)"modules.", (boolean)false, (int)2, null);
                            }
                            {
                                this.$substring2 = lazy;
                                this.$substring2$metadata = kProperty;
                                super(0);
                            }
                        }));
                        var12_11 = null;
                        substring3 = LazyKt.lazy((Function0)((Function0)new Function0<String>(substring2, var8_7){
                            final /* synthetic */ Lazy $substring2;
                            final /* synthetic */ KProperty $substring2$metadata;

                            @NotNull
                            public final String invoke() {
                                Lazy lazy = this.$substring2;
                                Object var2_2 = null;
                                KProperty kProperty = this.$substring2$metadata;
                                return StringsKt.replace$default((String)StringsKt.substringAfter$default((String)((String)lazy.getValue()), (String)"modules.", null, (int)2, null), (String)".", (String)"/", (boolean)false, (int)4, null);
                            }
                            {
                                this.$substring2 = lazy;
                                this.$substring2$metadata = kProperty;
                                super(0);
                            }
                        }));
                        var14_13 = null;
                        moduleMatch = LazyKt.lazy((Function0)((Function0)new Function0<TerraformModuleMetadata>(this, substring3, var12_11){
                            final /* synthetic */ resolveModules.1 this$0;
                            final /* synthetic */ Lazy $substring3;
                            final /* synthetic */ KProperty $substring3$metadata;

                            @Nullable
                            public final TerraformModuleMetadata invoke() {
                                Object v0;
                                block1: {
                                    Iterable iterable;
                                    Iterable iterable2 = iterable = (Iterable)this.this$0.$availableModules;
                                    for (T t : iterable2) {
                                        TerraformModuleMetadata it = (TerraformModuleMetadata)t;
                                        boolean bl = false;
                                        Lazy lazy = this.$substring3;
                                        Object var8_8 = null;
                                        KProperty kProperty = this.$substring3$metadata;
                                        if (!StringsKt.contains$default((CharSequence)((CharSequence)lazy.getValue()), (CharSequence)it.getAsPath(), (boolean)false, (int)2, null)) continue;
                                        v0 = t;
                                        break block1;
                                    }
                                    v0 = null;
                                }
                                return v0;
                            }
                            {
                                this.this$0 = var1_1;
                                this.$substring3 = lazy;
                                this.$substring3$metadata = kProperty;
                                super(0);
                            }
                        }));
                        if (!hasSourceKeyword) break block6;
                        var15_15 = hasEqualsAfterSource;
                        var16_16 = null;
                        if (!((Boolean)var15_15.getValue()).booleanValue()) break block6;
                        var15_15 = hasModulesKeyword;
                        var16_16 = null;
                        if (!((Boolean)var15_15.getValue()).booleanValue()) break block6;
                        var15_15 = moduleMatch;
                        var16_16 = null;
                        if (var15_15.getValue() == null) break block6;
                        $this$buildString = var15_15 = new StringBuilder();
                        $i$a$-buildString-UtilsKt$resolveModules$1$1 = false;
                        $this$buildString.append(StringsKt.substringBefore$default((String)line, (String)"source", null, (int)2, null));
                        $this$buildString.append("source = ");
                        $this$buildString.append('\"');
                        v0 = this.$this_resolveModules.getRelativePath();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"relativePath");
                        switch (v0.getSegments().length) {
                            case 1: {
                                v1 = new StringBuilder().append("./");
                                var18_18 = moduleMatch;
                                var19_20 = null;
                                var20_22 = var14_13;
                                v2 = (TerraformModuleMetadata)var18_18.getValue();
                                Intrinsics.checkNotNull((Object)v2);
                                $this$buildString.append(v1.append(v2.getAsPath()).toString());
                                break;
                            }
                            default: {
                                var19_21 = moduleMatch;
                                var20_23 = null;
                                var21_28 = var14_13;
                                v3 = (TerraformModuleMetadata)var19_21.getValue();
                                Intrinsics.checkNotNull((Object)v3);
                                $this$toTypedArray$iv = StringsKt.split$default((CharSequence)v3.getAsPath(), (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
                                $i$f$toTypedArray = false;
                                thisCollection$iv = $this$toTypedArray$iv;
                                v4 = thisCollection$iv.toArray(new String[0]);
                                Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                                modulePathSegments = v4;
                                v5 = this.$this_resolveModules.getRelativePath();
                                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"relativePath");
                                v6 = v5.getParent();
                                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"relativePath.parent");
                                v7 = v6.getSegments();
                                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"relativePath.parent.segments");
                                $i$f$toTypedArray = v7;
                                $i$f$uncommonElementsFromLeft = 0;
                                iterator$iv = ArrayIteratorKt.iterator((Object[])$this$uncommonElementsFromLeft$iv);
                                otherIterator$iv = ArrayIteratorKt.iterator((Object[])modulePathSegments);
                                while (iterator$iv.hasNext() && otherIterator$iv.hasNext()) {
                                    element$iv = iterator$iv.next();
                                    if (!(Intrinsics.areEqual(element$iv, otherElement$iv = otherIterator$iv.next()) ^ true)) continue;
                                    v8 = new SpreadBuilder(2);
                                    v8.add(element$iv);
                                    $this$toTypedArray$iv$iv = SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)iterator$iv));
                                    $i$f$toTypedArray = false;
                                    thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                                    v9 = thisCollection$iv$iv.toArray(new String[0]);
                                    Intrinsics.checkNotNull((Object)v9, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                                    v8.addSpread((Object)v9);
                                    v10 = v8.toArray((Object[])new String[v8.size()]);
                                    ** GOTO lbl84
                                }
                                v10 = new String[]{};
lbl84:
                                // 2 sources

                                uncommonElements = v10;
                                $this$uncommonElementsFromLeft$iv = uncommonElements.length;
                                $i$f$uncommonElementsFromLeft = 0;
                                while ($i$f$uncommonElementsFromLeft < $this$uncommonElementsFromLeft$iv) {
                                    it = $i$f$uncommonElementsFromLeft++;
                                    $i$a$-repeat-UtilsKt$resolveModules$1$1$1 = false;
                                    $this$buildString.append("../");
                                }
                                $this$uncommonElementsFromLeft$iv = modulePathSegments;
                                v11 = this.$this_resolveModules.getRelativePath();
                                Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"relativePath");
                                v12 = v11.getParent();
                                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"relativePath.parent");
                                v13 = v12.getSegments();
                                Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"relativePath.parent.segments");
                                $i$f$uncommonElementsFromLeft = v13;
                                var29_43 = $this$buildString;
                                $i$f$uncommonElementsFromLeft = false;
                                iterator$iv = ArrayIteratorKt.iterator((Object[])$this$uncommonElementsFromLeft$iv);
                                otherIterator$iv = ArrayIteratorKt.iterator((Object[])other$iv);
                                while (iterator$iv.hasNext() && otherIterator$iv.hasNext()) {
                                    element$iv = iterator$iv.next();
                                    if (!(Intrinsics.areEqual(element$iv, otherElement$iv = otherIterator$iv.next()) ^ true)) continue;
                                    v14 = new SpreadBuilder(2);
                                    v14.add(element$iv);
                                    $this$toTypedArray$iv$iv = SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)iterator$iv));
                                    $i$f$toTypedArray = false;
                                    thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                                    v15 = thisCollection$iv$iv.toArray(new String[0]);
                                    Intrinsics.checkNotNull((Object)v15, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                                    v14.addSpread((Object)v15);
                                    v16 = v14.toArray((Object[])new String[v14.size()]);
                                    ** GOTO lbl120
                                }
                                v16 = new String[]{};
lbl120:
                                // 2 sources

                                var31_45 = v16;
                                var29_43.append(ArraysKt.joinToString$default((Object[])var31_45, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null));
                            }
                        }
                        $this$buildString.append('\"');
                        v17 = var15_15.toString();
                        v18 = v17;
                        Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"StringBuilder().apply(builderAction).toString()");
                        break block7;
                    }
                    v18 = line;
                }
                return v18;
            }
            {
                this.$this_resolveModules = fileCopyDetails;
                this.$availableModules = set;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)contentFilterable, (String)"filter { line ->\n\n    va\u2026\"')\n        } else line\n}");
        return contentFilterable;
    }
}

