/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.BuiltInWithDifferentJvmName;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.SpecialBridgeMethods;
import org.jetbrains.kotlin.backend.common.lower.SpecialMethodWithDefaultInfo;
import org.jetbrains.kotlin.backend.common.lower.VariableRemapper;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.codegen.IrCodegenUtilsKt;
import org.jetbrains.kotlin.backend.jvm.codegen.IrTypeMapper;
import org.jetbrains.kotlin.backend.jvm.codegen.MethodSignatureMapper;
import org.jetbrains.kotlin.backend.jvm.lower.BridgeLowering;
import org.jetbrains.kotlin.backend.jvm.lower.BridgeLoweringKt;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrIfThenElseImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.commons.Method;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0003IJKB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nH\u0002J\b\u0010\u0019\u001a\u00020\u0015H\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0017H\u0016J\u0014\u0010!\u001a\u00020\n*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u001c\u0010\"\u001a\u00020\n*\u00020\u00172\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\nH\u0002J\u001c\u0010&\u001a\u00020\n*\u00020\u00172\u0006\u0010'\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\nH\u0002J.\u0010(\u001a\u00020\u0015*\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\n2\u0010\b\u0002\u0010*\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010+H\u0002J.\u0010-\u001a\u00020.*\u00020.2\u0006\u0010%\u001a\u00020\n2\f\u0010/\u001a\b\u0012\u0004\u0012\u000201002\n\b\u0002\u00102\u001a\u0004\u0018\u00010,H\u0002J(\u00103\u001a\u000204*\u0002052\u0006\u0010#\u001a\u00020\n2\u0006\u0010%\u001a\u00020\n2\n\b\u0002\u00106\u001a\u0004\u0018\u000107H\u0002J\u001c\u00108\u001a\u000204*\u0002052\u0006\u00109\u001a\u0002042\u0006\u0010:\u001a\u00020,H\u0002J\f\u0010;\u001a\u00020<*\u00020,H\u0002J\u0012\u0010=\u001a\b\u0012\u0004\u0012\u00020\f0+*\u00020\nH\u0002J\u0012\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00110+*\u00020\nH\u0002J$\u0010?\u001a\u00020@*\u0002052\u0006\u0010A\u001a\u00020.2\u0006\u0010B\u001a\u00020,2\u0006\u0010C\u001a\u000204H\u0002J$\u0010D\u001a\u00020\u0015*\u00020\n2\u0006\u0010E\u001a\u00020\f2\u0006\u0010F\u001a\u00020\f2\u0006\u0010G\u001a\u00020HH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\f*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006L"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/BridgeLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "potentialBridgeTargets", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "jvmMethod", "Lorg/jetbrains/org/objectweb/asm/commons/Method;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getJvmMethod", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/org/objectweb/asm/commons/Method;", "specialBridgeOrNull", "Lorg/jetbrains/kotlin/backend/jvm/lower/BridgeLowering$SpecialBridge;", "getSpecialBridgeOrNull", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Lorg/jetbrains/kotlin/backend/jvm/lower/BridgeLowering$SpecialBridge;", "createBridges", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irFunction", "generateBridges", "lower", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "makeLastParameterNullable", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "addAbstractMethodStub", "addBridge", "bridge", "Lorg/jetbrains/kotlin/backend/jvm/lower/BridgeLowering$Bridge;", "target", "addSpecialBridge", "specialBridge", "copyParametersWithErasure", "from", "substitutedParameterTypes", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "copyWithTypeErasure", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "visibleTypeParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "substitutedType", "delegatingCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "superQualifierSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "irCastIfNeeded", "expression", "to", "isTypeParameterWithPrimitiveUpperBound", "", "overriddenFinalSpecialBridges", "overriddenSpecialBridges", "parameterTypeCheck", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrIfThenElseImpl;", "parameter", "type", "defaultValue", "rewriteSpecialMethodBody", "ourSignature", "specialOverrideSignature", "specialOverrideInfo", "Lorg/jetbrains/kotlin/backend/common/lower/SpecialMethodWithDefaultInfo;", "Bridge", "BridgeLoweringCache", "SpecialBridge", "backend.jvm"})
public final class BridgeLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final List<IrSimpleFunction> potentialBridgeTargets;

    public BridgeLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        boolean bl = false;
        this.potentialBridgeTargets = new ArrayList();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.transformChildrenVoid(irFile);
        this.generateBridges();
        this.potentialBridgeTargets.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrStatement visitClass(@NotNull IrClass declaration2) {
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.DEFAULT_IMPLS.INSTANCE) || IrUtilsKt.isAnnotationClass(declaration2)) {
            return super.visitClass(declaration2);
        }
        Sequence<IrSimpleFunction> sequence2 = IrUtilsKt.getFunctions(declaration2);
        Collection destination$iv = this.potentialBridgeTargets;
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            boolean bl;
            IrSimpleFunction irFunction2 = (IrSimpleFunction)element$iv;
            if (DescriptorVisibilities.isPrivate(irFunction2.getVisibility()) || org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isStatic(irFunction2) || irFunction2.getOverriddenSymbols().isEmpty()) {
                bl = false;
            } else if (org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isMethodOfAny(irFunction2)) {
                bl = false;
            } else if (org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.isJvmAbstract(irFunction2, this.context.getState().getJvmDefaultMode())) {
                if (IrCodegenUtilsKt.isJvmInterface(IrUtilsKt.getParentAsClass(irFunction2))) {
                    if (this.getSpecialBridgeOrNull(irFunction2) != null) {
                        this.context.getFunctionsWithSpecialBridges$backend_jvm().add(irFunction2);
                    }
                    bl = false;
                } else {
                    bl = true;
                }
            } else {
                bl = !irFunction2.isFakeOverride() || BridgeLoweringKt.access$resolvesToClass(irFunction2);
            }
            if (!bl) continue;
            destination$iv.add(element$iv);
        }
        if (declaration2.isInline()) {
            Object v1;
            block14: {
                Sequence<IrSimpleFunction> sequence3 = IrUtilsKt.getFunctions(declaration2);
                boolean bl = false;
                Sequence<IrSimpleFunction> sequence4 = sequence3;
                boolean bl2 = false;
                for (Object e : sequence4) {
                    IrSimpleFunction it = (IrSimpleFunction)e;
                    boolean bl3 = false;
                    IrFunction original = this.getContext().getInlineClassReplacements().getOriginalFunctionForStaticReplacement$backend_jvm().get(it);
                    if (!(original != null && this.getContext().getMethodSignatureMapper().shouldBoxSingleValueParameterForSpecialCaseOfRemove$backend_jvm(original))) continue;
                    v1 = e;
                    break block14;
                }
                v1 = null;
            }
            IrSimpleFunction remove = v1;
            if (remove != null) {
                this.makeLastParameterNullable(remove);
            }
        }
        return super.visitClass(declaration2);
    }

    private final void makeLastParameterNullable(IrSimpleFunction irFunction2) {
        IrValueParameter oldValueParameter = (IrValueParameter)CollectionsKt.last(irFunction2.getValueParameters());
        IrValueParameter newValueParameter = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(oldValueParameter, irFunction2, null, 0, 0, 0, null, null, IrTypesKt.makeNullable(oldValueParameter.getType()), null, null, false, false, false, 8062, null);
        irFunction2.setValueParameters(CollectionsKt.plus((Collection)CollectionsKt.dropLast(irFunction2.getValueParameters(), (int)1), (Object)newValueParameter));
        IrBody irBody = irFunction2.getBody();
        if (irBody != null) {
            irBody.transform((IrElementTransformer)new VariableRemapper(MapsKt.mapOf((Pair)TuplesKt.to((Object)oldValueParameter, (Object)newValueParameter))), (Object)null);
        }
    }

    private final void generateBridges() {
        for (IrSimpleFunction member2 : this.potentialBridgeTargets) {
            IrClass parent2 = IrUtilsKt.getParentAsClass(member2);
            this.createBridges(parent2, member2);
            if (!Intrinsics.areEqual((Object)member2.getName(), (Object)OperatorNameConventions.INVOKE) || !Intrinsics.areEqual((Object)parent2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.LAMBDA_IMPL.INSTANCE) && !Intrinsics.areEqual((Object)parent2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.FUNCTION_REFERENCE_IMPL.INSTANCE) || BridgeLoweringKt.access$isInlineClassErasingToAny(member2.getReturnType())) continue;
            member2.setOverriddenSymbols(CollectionsKt.emptyList());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createBridges(IrClass irClass2, IrSimpleFunction irFunction2) {
        void $this$filterTo$iv$iv;
        void $this$forEach$iv;
        Bridge answer$iv;
        Object object;
        void $this$mapTo$iv;
        boolean bl = false;
        Set blacklist = new LinkedHashSet();
        Sequence sequence2 = SequencesKt.filter(IrUtilsKt.getFunctions(irClass2), (Function1)((Function1)new Function1<IrSimpleFunction, Boolean>(irFunction2){
            final /* synthetic */ IrSimpleFunction $irFunction;
            {
                this.$irFunction = $irFunction;
                super(1);
            }

            public final boolean invoke(@NotNull IrSimpleFunction it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !it.isFakeOverride() && Intrinsics.areEqual((Object)it.getName(), (Object)this.$irFunction.getName());
            }
        }));
        Object destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv2 : $this$mapTo$iv) {
            void it;
            IrSimpleFunction irSimpleFunction = (IrSimpleFunction)item$iv2;
            Collection collection = destination$iv;
            boolean bl2 = false;
            Method method = this.getJvmMethod((IrFunction)it);
            collection.add(method);
        }
        HashSet existingMethodSignatures2 = (HashSet)destination$iv;
        destination$iv = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default(irFunction2, false, null, 3, null);
        Method targetMethod = this.getJvmMethod((IrFunction)(destination$iv == null ? irFunction2 : destination$iv));
        if (!irFunction2.isFakeOverride() || irFunction2.getModality() == Modality.FINAL) {
            destination$iv = blacklist;
            $i$f$mapTo = false;
            destination$iv.add(targetMethod);
        }
        SpecialBridge specialBridge = this.getSpecialBridgeOrNull(irFunction2);
        Ref.ObjectRef bridgeTarget = new Ref.ObjectRef();
        bridgeTarget.element = irFunction2;
        if (specialBridge != null) {
            Object item$iv2;
            Collection collection = blacklist;
            item$iv2 = this.overriddenFinalSpecialBridges(irFunction2);
            boolean it = false;
            CollectionsKt.addAll((Collection)collection, item$iv2);
            IrSimpleFunction specialBridgeTarget = BridgeLowering.createBridges$getSpecialBridgeTargetAddingExtraBridges(blacklist, specialBridge, irFunction2, this, (Ref.ObjectRef<IrSimpleFunction>)bridgeTarget, irClass2, existingMethodSignatures2);
            if (!irFunction2.isFakeOverride() && specialBridge.getMethodInfo() != null) {
                this.rewriteSpecialMethodBody(irFunction2, targetMethod, specialBridge.getSignature(), specialBridge.getMethodInfo());
            }
            if (specialBridge.getSubstitutedReturnType() != null) {
                for (SpecialBridge overriddenSpecialBridge : this.overriddenSpecialBridges(irFunction2)) {
                    if (blacklist.contains(overriddenSpecialBridge.getSignature())) continue;
                    this.addSpecialBridge(irClass2, overriddenSpecialBridge, specialBridgeTarget);
                    Collection bl2 = blacklist;
                    object = overriddenSpecialBridge.getSignature();
                    boolean bl3 = false;
                    bl2.add(object);
                }
            }
        } else if (org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.isJvmAbstract(irFunction2, this.context.getState().getJvmDefaultMode())) {
            return;
        }
        boolean item$iv2 = false;
        Map generated = new LinkedHashMap();
        for (IrSimpleFunction override : org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.allOverridden$default(irFunction2, false, 1, null)) {
            Object object2;
            Method signature2;
            if (override.isFakeOverride() || Intrinsics.areEqual((Object)targetMethod, (Object)(signature2 = this.getJvmMethod(override))) || blacklist.contains(signature2)) continue;
            Object $this$getOrPut$iv = generated;
            boolean $i$f$getOrPut22 = false;
            Object value$iv22 = $this$getOrPut$iv.get(signature2);
            if (value$iv22 == null) {
                boolean bl4 = false;
                answer$iv = new Bridge(override, signature2, null, 4, null);
                $this$getOrPut$iv.put(signature2, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv22;
            }
            object = (Bridge)object2;
            $this$getOrPut$iv = ((Bridge)object).getOverriddenSymbols();
            IrSimpleFunctionSymbol $i$f$getOrPut22 = override.getSymbol();
            boolean value$iv22 = false;
            $this$getOrPut$iv.add($i$f$getOrPut22);
        }
        if (generated.isEmpty()) {
            return;
        }
        if (irFunction2.isFakeOverride()) {
            Sequence item$iv2 = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)irFunction2.getOverriddenSymbols()), (Function1)createBridges.2.INSTANCE), (Function1)((Function1)new Function1<IrSimpleFunction, Boolean>(this){
                final /* synthetic */ BridgeLowering this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final boolean invoke(@NotNull IrSimpleFunction it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.isJvmAbstract(it, this.this$0.getContext().getState().getJvmDefaultMode());
                }
            }));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapTo$iv2;
                Iterator $this$filterTo$iv$iv2;
                Iterable $this$filter$iv;
                IrSimpleFunction override = (IrSimpleFunction)element$iv;
                boolean bl5 = false;
                Iterable value$iv22 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.allOverridden$default(override, false, 1, null);
                boolean $i$f$filter = false;
                answer$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo2 = false;
                Iterator iterator2 = $this$filterTo$iv$iv2.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv = iterator2.next();
                    IrSimpleFunction it = (IrSimpleFunction)element$iv$iv;
                    boolean bl6 = false;
                    if (!(!it.isFakeOverride())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$mapTo2 = false;
                $this$filterTo$iv$iv2 = $this$mapTo$iv2.iterator();
                while ($this$filterTo$iv$iv2.hasNext()) {
                    void it;
                    Object item$iv3 = $this$filterTo$iv$iv2.next();
                    IrSimpleFunction $i$f$filterTo2 = (IrSimpleFunction)item$iv3;
                    Collection collection = blacklist;
                    boolean bl7 = false;
                    Method method = this.getJvmMethod((IrFunction)it);
                    collection.add(method);
                }
            }
        }
        Iterable $this$filter$iv = generated.values();
        boolean $i$f$filter = false;
        Iterable signature2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Bridge it = (Bridge)element$iv$iv;
            boolean bl8 = false;
            if (!(!blacklist.contains(it.getSignature()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Bridge it = (Bridge)element$iv;
            boolean bl9 = false;
            this.addBridge(irClass2, it, (IrSimpleFunction)bridgeTarget.element);
        }
    }

    private final SpecialBridge getSpecialBridgeOrNull(IrSimpleFunction $this$specialBridgeOrNull) {
        return this.context.getBridgeLoweringCache$backend_jvm().computeSpecialBridge($this$specialBridgeOrNull);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Method> overriddenFinalSpecialBridges(IrSimpleFunction $this$overriddenFinalSpecialBridges) {
        void var3_4;
        void $this$mapNotNullTo$iv;
        Iterable iterable = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.allOverridden$default($this$overriddenFinalSpecialBridges, false, 1, null);
        boolean bl = false;
        Collection destination$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Method method;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl3 = false;
            if (IrUtilsKt.isInterface(IrUtilsKt.getParentAsClass(it)) || org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isFromJava(it)) {
                method = null;
            } else {
                SpecialBridge specialBridge = this.getSpecialBridgeOrNull(it);
                if (specialBridge == null) {
                    method = null;
                } else {
                    Method method2;
                    Method method3 = method2 = specialBridge.getSignature();
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Method bridgeSignature = method3;
                    boolean bl6 = false;
                    method = !Intrinsics.areEqual((Object)bridgeSignature, (Object)this.getJvmMethod(it)) ? method3 : null;
                }
            }
            if (method == null) continue;
            Method method4 = method;
            boolean bl7 = false;
            boolean bl8 = false;
            Method it$iv = method4;
            boolean bl9 = false;
            destination$iv.add(it$iv);
        }
        return (List)var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SpecialBridge> overriddenSpecialBridges(IrSimpleFunction $this$overriddenSpecialBridges) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Method targetJvmMethod = MethodSignatureMapper.mapCalleeToAsmMethod$backend_jvm$default(this.context.getMethodSignatureMapper(), $this$overriddenSpecialBridges, false, 2, null);
        Iterable $this$filter$iv = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.allOverridden$default($this$overriddenSpecialBridges, false, 1, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrSimpleFunction)element$iv$iv;
            boolean bl = false;
            if (!(IrUtilsKt.isInterface(IrUtilsKt.getParentAsClass((IrDeclaration)it)) || org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isFromJava((IrDeclaration)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            SpecialBridge specialBridge;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            IrSimpleFunction it2 = (IrSimpleFunction)element$iv$iv;
            boolean bl2 = false;
            if (this.getSpecialBridgeOrNull(it2) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            SpecialBridge it$iv$iv = specialBridge;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SpecialBridge)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)((SpecialBridge)it).getSignature(), (Object)targetJvmMethod))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SpecialBridge)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SpecialBridge specialBridge = SpecialBridge.copy$default((SpecialBridge)it, null, null, false, null, null, null, null, false, true, false, 607, null);
            collection.add(specialBridge);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction addAbstractMethodStub(IrClass $this$addAbstractMethodStub, IrSimpleFunction irFunction2) {
        Collection<IrValueParameter> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrClass $this$addFunction$iv = $this$addAbstractMethodStub;
        boolean $i$f$addFunction = false;
        IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
        boolean $i$f$addFunction2 = false;
        Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
        boolean $i$f$buildFun22 = false;
        IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
        boolean bl = false;
        boolean bl2 = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2d14$iv$iv$iv = irFunctionBuilder;
        boolean bl3 = false;
        IrFunctionBuilder $this$addAbstractMethodStub_u24lambda_u2d16 = $this$buildFun_u24lambda_u2d14$iv$iv$iv;
        boolean bl4 = false;
        $this$addAbstractMethodStub_u24lambda_u2d16.updateFrom(irFunction2);
        $this$addAbstractMethodStub_u24lambda_u2d16.setModality(Modality.ABSTRACT);
        $this$addAbstractMethodStub_u24lambda_u2d16.setOrigin(JvmLoweredDeclarationOrigin.ABSTRACT_BRIDGE_STUB.INSTANCE);
        $this$addAbstractMethodStub_u24lambda_u2d16.setName(irFunction2.getName());
        $this$addAbstractMethodStub_u24lambda_u2d16.setReturnType(irFunction2.getReturnType());
        $this$addAbstractMethodStub_u24lambda_u2d16.setFakeOverride(false);
        $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, $this$buildFun_u24lambda_u2d14$iv$iv$iv);
        $i$f$buildFun22 = false;
        boolean bl5 = false;
        Object function$iv$iv = $this$buildFun$iv$iv$iv;
        boolean $i$a$-also-DeclarationBuildersKt$addFunction$1$iv$iv22 = false;
        ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv);
        function$iv$iv.setParent($this$addFunction$iv);
        Object object = $this$buildFun$iv$iv$iv;
        boolean bl6 = false;
        boolean bl7 = false;
        Object $this$addAbstractMethodStub_u24lambda_u2d18 = object;
        boolean bl8 = false;
        org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.copyCorrespondingPropertyFrom((IrSimpleFunction)$this$addAbstractMethodStub_u24lambda_u2d18, irFunction2);
        Object $i$f$buildFun22 = $this$addAbstractMethodStub.getThisReceiver();
        ((IrFunction)$this$addAbstractMethodStub_u24lambda_u2d18).setDispatchReceiverParameter($i$f$buildFun22 == null ? null : org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)$i$f$buildFun22, (IrFunction)$this$addAbstractMethodStub_u24lambda_u2d18, null, 0, 0, 0, null, null, IrUtilsKt.getDefaultType($this$addAbstractMethodStub), null, null, false, false, false, 8062, null));
        $i$f$buildFun22 = irFunction2.getValueParameters();
        Object object2 = $this$addAbstractMethodStub_u24lambda_u2d18;
        boolean $i$f$map = false;
        void $i$a$-also-DeclarationBuildersKt$addFunction$1$iv$iv22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void param;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl9 = false;
            IrValueParameter irValueParameter2 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)param, (IrFunction)$this$addAbstractMethodStub_u24lambda_u2d18, null, 0, 0, 0, null, null, param.getType(), null, null, false, false, false, 8062, null);
            collection.add(irValueParameter2);
        }
        collection = (List)destination$iv$iv;
        ((IrFunction)object2).setValueParameters((List<? extends IrValueParameter>)collection);
        $this$addAbstractMethodStub_u24lambda_u2d18.setOverriddenSymbols(CollectionsKt.toList((Iterable)irFunction2.getOverriddenSymbols()));
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction addBridge(IrClass $this$addBridge, Bridge bridge, IrSimpleFunction target) {
        void $this$addBridge_u24lambda_u2d25_u24lambda_u2d20;
        IrClass $this$addFunction$iv = $this$addBridge;
        boolean $i$f$addFunction = false;
        IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
        boolean $i$f$addFunction2 = false;
        Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
        boolean $i$f$buildFun22 = false;
        IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
        boolean bl = false;
        boolean bl2 = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2d14$iv$iv$iv = irFunctionBuilder;
        boolean bl3 = false;
        IrFunctionBuilder $this$addBridge_u24lambda_u2d19 = $this$buildFun_u24lambda_u2d14$iv$iv$iv;
        boolean bl4 = false;
        $this$addBridge_u24lambda_u2d19.setStartOffset($this$addBridge.getStartOffset());
        $this$addBridge_u24lambda_u2d19.setEndOffset($this$addBridge.getStartOffset());
        $this$addBridge_u24lambda_u2d19.setModality(Modality.OPEN);
        $this$addBridge_u24lambda_u2d19.setOrigin(IrDeclarationOrigin.BRIDGE.INSTANCE);
        Name name = Name.identifier(bridge.getSignature().getName());
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(bridge.signature.name)");
        $this$addBridge_u24lambda_u2d19.setName(name);
        $this$addBridge_u24lambda_u2d19.setReturnType(org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.eraseTypeParameters(bridge.getOverridden().getReturnType()));
        $this$addBridge_u24lambda_u2d19.setSuspend(bridge.getOverridden().isSuspend());
        $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, $this$buildFun_u24lambda_u2d14$iv$iv$iv);
        $i$f$buildFun22 = false;
        boolean bl5 = false;
        Object function$iv$iv222 = $this$buildFun$iv$iv$iv;
        boolean $i$a$-also-DeclarationBuildersKt$addFunction$1$iv$iv22 = false;
        ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv222);
        function$iv$iv222.setParent($this$addFunction$iv);
        Object object = $this$buildFun$iv$iv$iv;
        boolean bl6 = false;
        boolean bl7 = false;
        Object $this$addBridge_u24lambda_u2d25 = object;
        boolean bl8 = false;
        BridgeLowering.copyParametersWithErasure$default(this, (IrSimpleFunction)$this$addBridge_u24lambda_u2d25, $this$addBridge, bridge.getOverridden(), null, 4, null);
        DeclarationIrBuilder $i$f$buildFun22 = LowerUtilsKt.createIrBuilder(this.getContext(), ((IrSimpleFunction)$this$addBridge_u24lambda_u2d25).getSymbol(), $this$addBridge_u24lambda_u2d25.getStartOffset(), $this$addBridge_u24lambda_u2d25.getEndOffset());
        bl5 = false;
        boolean function$iv$iv222 = false;
        DeclarationIrBuilder $i$a$-also-DeclarationBuildersKt$addFunction$1$iv$iv22 = $i$f$buildFun22;
        Object object2 = $this$addBridge_u24lambda_u2d25;
        boolean bl9 = false;
        Object object3 = ExpressionHelpersKt.irExprBody((IrBuilderWithScope)$this$addBridge_u24lambda_u2d25_u24lambda_u2d20, BridgeLowering.delegatingCall$default(this, (IrBuilderWithScope)$this$addBridge_u24lambda_u2d25_u24lambda_u2d20, (IrSimpleFunction)$this$addBridge_u24lambda_u2d25, target, null, 4, null));
        ((IrFunction)object2).setBody((IrBody)object3);
        if (!this.isTypeParameterWithPrimitiveUpperBound(bridge.getOverridden().getReturnType())) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void destination$iv;
            Iterable $this$flatMapTo$iv;
            Iterable destination$iv2;
            void $this$flatMapTo$iv2;
            Iterable iterable = bridge.getOverriddenSymbols();
            function$iv$iv222 = false;
            Collection function$iv$iv222 = new LinkedHashSet();
            boolean $i$f$flatMapTo22 = false;
            for (Object element$iv : $this$flatMapTo$iv2) {
                IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                boolean bl10 = false;
                Iterable list$iv = ((IrSimpleFunction)it.getOwner()).getOverriddenSymbols();
                CollectionsKt.addAll((Collection)destination$iv2, (Iterable)list$iv);
            }
            Set inheritedOverrides = (Set)destination$iv2;
            destination$iv2 = inheritedOverrides;
            $i$f$flatMapTo22 = false;
            Collection $i$f$flatMapTo22 = new LinkedHashSet();
            boolean $i$f$flatMapTo32 = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                void $this$mapTo$iv$iv;
                IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                boolean bl11 = false;
                Iterable $this$map$iv = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.allOverridden$default((IrSimpleFunction)it.getOwner(), false, 1, null);
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void override;
                    IrSimpleFunction irSimpleFunction = (IrSimpleFunction)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl12 = false;
                    IrSimpleFunctionSymbol irSimpleFunctionSymbol = override.getSymbol();
                    collection.add(irSimpleFunctionSymbol);
                }
                Iterable list$iv = (List)destination$iv$iv;
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            Set redundantOverrides = (Set)destination$iv;
            $this$flatMapTo$iv = inheritedOverrides;
            object2 = $this$addBridge_u24lambda_u2d25;
            boolean $i$f$filter = false;
            void $i$f$flatMapTo32 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv$iv;
                boolean bl13 = false;
                if (!(!redundantOverrides.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            object3 = (List)destination$iv$iv;
            object2.setOverriddenSymbols(object3);
        }
        return object;
    }

    private final boolean isTypeParameterWithPrimitiveUpperBound(IrType $this$isTypeParameterWithPrimitiveUpperBound) {
        return IrTypeUtilsKt.isTypeParameter($this$isTypeParameterWithPrimitiveUpperBound) && IrTypePredicatesKt.isPrimitiveType$default(org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.eraseTypeParameters($this$isTypeParameterWithPrimitiveUpperBound), false, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction addSpecialBridge(IrClass $this$addSpecialBridge, SpecialBridge specialBridge, IrSimpleFunction target) {
        void $this$addSpecialBridge_u24lambda_u2d30_u24lambda_u2d29;
        void this_$iv$iv;
        IrClass $this$addFunction$iv = $this$addSpecialBridge;
        boolean $i$f$addFunction = false;
        IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
        boolean $i$f$addFunction2 = false;
        Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
        boolean $i$f$buildFun = false;
        IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
        boolean bl = false;
        boolean bl2 = false;
        Object $this$buildFun_u24lambda_u2d14$iv$iv$iv = irFunctionBuilder;
        boolean bl3 = false;
        IrFunctionBuilder $this$addSpecialBridge_u24lambda_u2d26 = $this$buildFun_u24lambda_u2d14$iv$iv$iv;
        boolean bl4 = false;
        $this$addSpecialBridge_u24lambda_u2d26.setStartOffset($this$addSpecialBridge.getStartOffset());
        $this$addSpecialBridge_u24lambda_u2d26.setEndOffset($this$addSpecialBridge.getStartOffset());
        $this$addSpecialBridge_u24lambda_u2d26.setModality(specialBridge.isFinal() ? Modality.FINAL : Modality.OPEN);
        $this$addSpecialBridge_u24lambda_u2d26.setOrigin(specialBridge.isSynthetic() ? (IrDeclarationOrigin)IrDeclarationOrigin.BRIDGE.INSTANCE : (IrDeclarationOrigin)IrDeclarationOrigin.BRIDGE_SPECIAL.INSTANCE);
        Name name = Name.identifier(specialBridge.getSignature().getName());
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(specialBridge.signature.name)");
        $this$addSpecialBridge_u24lambda_u2d26.setName(name);
        Object object = specialBridge.getSubstitutedReturnType();
        name = object == null ? null : org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.eraseToScope((IrType)object, IrUtilsKt.getParentAsClass(target));
        $this$addSpecialBridge_u24lambda_u2d26.setReturnType((IrType)(name == null ? org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.eraseTypeParameters(specialBridge.getOverridden().getReturnType()) : name));
        $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u2d14$iv$iv$iv);
        $i$f$buildFun = false;
        boolean bl5 = false;
        Object function$iv$iv = $this$buildFun$iv$iv$iv;
        boolean bl6 = false;
        ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv);
        function$iv$iv.setParent($this$addFunction$iv);
        Object object2 = $this$buildFun$iv$iv$iv;
        boolean bl7 = false;
        boolean bl8 = false;
        Object $this$addSpecialBridge_u24lambda_u2d30 = object2;
        boolean bl9 = false;
        this.getContext().getFunctionsWithSpecialBridges$backend_jvm().add(target);
        this.copyParametersWithErasure((IrSimpleFunction)$this$addSpecialBridge_u24lambda_u2d30, $this$addSpecialBridge, specialBridge.getOverridden(), specialBridge.getSubstitutedParameterTypes());
        IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder(this.getContext(), ((IrSimpleFunction)$this$addSpecialBridge_u24lambda_u2d30).getSymbol(), $this$addSpecialBridge_u24lambda_u2d30.getStartOffset(), $this$addSpecialBridge_u24lambda_u2d30.getEndOffset());
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        $this$buildFun_u24lambda_u2d14$iv$iv$iv = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        $this$addSpecialBridge_u24lambda_u2d26 = this_$iv$iv;
        Object object3 = $this$addSpecialBridge_u24lambda_u2d30;
        boolean bl10 = false;
        object = specialBridge.getMethodInfo();
        if (object != null) {
            Object object4 = object;
            boolean bl11 = false;
            boolean bl12 = false;
            Object info = object4;
            boolean bl13 = false;
            Iterable $this$forEach$iv = CollectionsKt.take((Iterable)((IrFunction)$this$addSpecialBridge_u24lambda_u2d30).getValueParameters(), (int)((SpecialMethodWithDefaultInfo)info).getArgumentsToCheck());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrValueParameter it = (IrValueParameter)element$iv;
                boolean bl14 = false;
                $this$addSpecialBridge_u24lambda_u2d30_u24lambda_u2d29.unaryPlus(this.parameterTypeCheck((IrBuilderWithScope)$this$addSpecialBridge_u24lambda_u2d30_u24lambda_u2d29, it, target.getValueParameters().get(it.getIndex()).getType(), (IrExpression)((SpecialMethodWithDefaultInfo)info).getDefaultValueGenerator().invoke($this$addSpecialBridge_u24lambda_u2d30)));
            }
        }
        $this$addSpecialBridge_u24lambda_u2d30_u24lambda_u2d29.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$addSpecialBridge_u24lambda_u2d30_u24lambda_u2d29, this.delegatingCall((IrBuilderWithScope)$this$addSpecialBridge_u24lambda_u2d30_u24lambda_u2d29, (IrSimpleFunction)$this$addSpecialBridge_u24lambda_u2d30, target, specialBridge.getSuperQualifierSymbol())));
        Unit unit = Unit.INSTANCE;
        ((IrFunction)object3).setBody(this_$iv$iv.doBuild());
        if (specialBridge.isOverriding()) {
            $this$addSpecialBridge_u24lambda_u2d30.setOverriddenSymbols(CollectionsKt.listOf((Object)specialBridge.getOverridden().getSymbol()));
        }
        if (this.getContext().getMethodSignatureMapper().shouldBoxSingleValueParameterForSpecialCaseOfRemove$backend_jvm((IrFunction)$this$addSpecialBridge_u24lambda_u2d30)) {
            this.makeLastParameterNullable((IrSimpleFunction)$this$addSpecialBridge_u24lambda_u2d30);
        }
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    private final void rewriteSpecialMethodBody(IrSimpleFunction $this$rewriteSpecialMethodBody, Method ourSignature, Method specialOverrideSignature, SpecialMethodWithDefaultInfo specialOverrideInfo) {
        Iterable argumentsToCheck;
        boolean bl = false;
        Map variableMap = new LinkedHashMap();
        if (Intrinsics.areEqual((Object)specialOverrideSignature, (Object)ourSignature)) {
            boolean shouldGenerateParameterChecks;
            boolean $i$f$any;
            Object $this$any$iv;
            block17: {
                boolean bl2;
                argumentsToCheck = CollectionsKt.take((Iterable)$this$rewriteSpecialMethodBody.getValueParameters(), (int)specialOverrideInfo.getArgumentsToCheck());
                $this$any$iv = argumentsToCheck;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    Iterator iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv = iterator2.next();
                        IrValueParameter it = (IrValueParameter)element$iv;
                        boolean bl3 = false;
                        if (!(!org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(it.getType()))) continue;
                        bl2 = true;
                        break block17;
                    }
                    bl2 = shouldGenerateParameterChecks = false;
                }
            }
            if (shouldGenerateParameterChecks) {
                void $this$rewriteSpecialMethodBody_u24lambda_u2d35_u24lambda_u2d34;
                IrStatement it;
                Object element$iv;
                void this_$iv$iv;
                $this$any$iv = LowerUtilsKt.createIrBuilder$default(this.context, $this$rewriteSpecialMethodBody.getSymbol(), 0, 0, 6, null);
                $i$f$any = false;
                boolean bl4 = false;
                Object $this$rewriteSpecialMethodBody_u24lambda_u2d35 = $this$any$iv;
                boolean bl5 = false;
                IrBuilderWithScope $this$irBlockBody_u24default$iv = (IrBuilderWithScope)$this$rewriteSpecialMethodBody_u24lambda_u2d35;
                int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
                int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
                boolean $i$f$irBlockBody = false;
                IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
                boolean $i$f$blockBody = false;
                void var19_34 = this_$iv$iv;
                IrSimpleFunction irSimpleFunction = $this$rewriteSpecialMethodBody;
                boolean bl6 = false;
                ArrayList<IrValueParameter> newValueParameters = new ArrayList<IrValueParameter>((Collection)$this$rewriteSpecialMethodBody.getValueParameters());
                Object $this$forEach$iv = argumentsToCheck;
                boolean $i$f$forEach = false;
                Iterator iterator3 = $this$forEach$iv.iterator();
                while (iterator3.hasNext()) {
                    element$iv = iterator3.next();
                    it = (IrValueParameter)element$iv;
                    boolean bl7 = false;
                    IrType parameterType = ((IrValueDeclaration)it).getType();
                    if (org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(parameterType)) continue;
                    IrValueParameter newParameter = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)it, $this$rewriteSpecialMethodBody, null, 0, 0, 0, null, null, IrTypesKt.makeNullable(parameterType), null, null, false, false, false, 8062, null);
                    Map map = variableMap;
                    IrValueParameter irValueParameter = $this$rewriteSpecialMethodBody.getValueParameters().get(((IrValueParameter)it).getIndex());
                    boolean bl8 = false;
                    map.put(irValueParameter, newParameter);
                    newValueParameters.set(((IrValueParameter)it).getIndex(), newParameter);
                    $this$rewriteSpecialMethodBody_u24lambda_u2d35_u24lambda_u2d34.unaryPlus(this.parameterTypeCheck((IrBuilderWithScope)$this$rewriteSpecialMethodBody_u24lambda_u2d35_u24lambda_u2d34, newParameter, parameterType, (IrExpression)specialOverrideInfo.getDefaultValueGenerator().invoke((Object)$this$rewriteSpecialMethodBody)));
                }
                $this$rewriteSpecialMethodBody.setValueParameters((List<? extends IrValueParameter>)newValueParameters);
                if ($this$rewriteSpecialMethodBody.getBody() instanceof IrExpressionBody) {
                    $this$forEach$iv = $this$rewriteSpecialMethodBody.getBody();
                    if ($this$forEach$iv == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpressionBody");
                    }
                    $this$rewriteSpecialMethodBody_u24lambda_u2d35_u24lambda_u2d34.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$rewriteSpecialMethodBody_u24lambda_u2d35_u24lambda_u2d34, ((IrExpressionBody)$this$forEach$iv).getExpression()));
                } else {
                    $this$forEach$iv = $this$rewriteSpecialMethodBody.getBody();
                    if ($this$forEach$iv == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
                    }
                    $this$forEach$iv = ((IrBlockBody)$this$forEach$iv).getStatements();
                    $i$f$forEach = false;
                    iterator3 = $this$forEach$iv.iterator();
                    while (iterator3.hasNext()) {
                        element$iv = iterator3.next();
                        it = (IrStatement)element$iv;
                        boolean bl9 = false;
                        $this$rewriteSpecialMethodBody_u24lambda_u2d35_u24lambda_u2d34.unaryPlus(it);
                    }
                }
                Unit unit = Unit.INSTANCE;
                irSimpleFunction.setBody(this_$iv$iv.doBuild());
            }
        } else {
            Collection<void> collection;
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            argumentsToCheck = $this$rewriteSpecialMethodBody.getValueParameters();
            IrSimpleFunction irSimpleFunction = $this$rewriteSpecialMethodBody;
            boolean $i$f$mapIndexed = false;
            void $this$any$iv = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                IrValueParameter irValueParameter;
                void i;
                void p;
                int n = index$iv$iv++;
                boolean bl10 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrValueParameter $i$f$irBlockBody = (IrValueParameter)item$iv$iv;
                int this_$iv$iv = n;
                collection = destination$iv$iv;
                boolean bl11 = false;
                if (AsmUtil.isPrimitive(IrTypeMapper.mapType$default(this.getContext().getTypeMapper(), p.getType(), null, null, 6, null)) && ourSignature.getArgumentTypes()[i].getSort() == 10) {
                    IrValueParameter newParameter = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)p, $this$rewriteSpecialMethodBody, null, 0, 0, 0, null, null, IrTypesKt.makeNullable(p.getType()), null, null, false, false, false, 8062, null);
                    Map map = variableMap;
                    boolean bl12 = false;
                    map.put(p, newParameter);
                    irValueParameter = newParameter;
                } else {
                    irValueParameter = p;
                }
                void var37_55 = irValueParameter;
                collection.add(var37_55);
            }
            collection = (List)destination$iv$iv;
            irSimpleFunction.setValueParameters((List<? extends IrValueParameter>)collection);
        }
        Object object = variableMap;
        boolean bl13 = false;
        if (!object.isEmpty() && (object = $this$rewriteSpecialMethodBody.getBody()) != null) {
            ((IrBody)object).transform((IrElementTransformer)new VariableRemapper(variableMap), (Object)null);
        }
    }

    private final IrIfThenElseImpl parameterTypeCheck(IrBuilderWithScope $this$parameterTypeCheck, IrValueParameter parameter, IrType type2, IrExpression defaultValue2) {
        return ExpressionHelpersKt.irIfThen$default($this$parameterTypeCheck, $this$parameterTypeCheck.getContext().getIrBuiltIns().getUnitType(), LowerUtilsKt.irNot($this$parameterTypeCheck, ExpressionHelpersKt.irIs($this$parameterTypeCheck, ExpressionHelpersKt.irGet($this$parameterTypeCheck, parameter), type2)), ExpressionHelpersKt.irReturn($this$parameterTypeCheck, defaultValue2), null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void copyParametersWithErasure(IrSimpleFunction $this$copyParametersWithErasure, IrClass irClass2, IrSimpleFunction from, List<? extends IrType> substitutedParameterTypes) {
        List list2;
        IrSimpleFunction irSimpleFunction;
        Iterable $this$map$iv;
        Set<IrTypeParameter> visibleTypeParameters = org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.collectVisibleTypeParameters($this$copyParametersWithErasure);
        Object object = irClass2.getThisReceiver();
        $this$copyParametersWithErasure.setDispatchReceiverParameter(object == null ? null : org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)object, $this$copyParametersWithErasure, null, 0, 0, 0, null, null, IrUtilsKt.getDefaultType(irClass2), null, null, false, false, false, 8062, null));
        object = from.getExtensionReceiverParameter();
        $this$copyParametersWithErasure.setExtensionReceiverParameter(object == null ? null : BridgeLowering.copyWithTypeErasure$default(this, (IrValueParameter)object, $this$copyParametersWithErasure, visibleTypeParameters, null, 4, null));
        IrSimpleFunction irSimpleFunction2 = $this$copyParametersWithErasure;
        if (substitutedParameterTypes != null) {
            Collection<IrValueParameter> collection;
            void $this$mapTo$iv$iv;
            object = CollectionsKt.zip((Iterable)from.getValueParameters(), (Iterable)substitutedParameterTypes);
            IrSimpleFunction irSimpleFunction3 = irSimpleFunction2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $dstr$param$type;
                Pair pair = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                IrValueParameter param = (IrValueParameter)$dstr$param$type.component1();
                IrType type2 = (IrType)$dstr$param$type.component2();
                IrValueParameter irValueParameter = this.copyWithTypeErasure(param, $this$copyParametersWithErasure, visibleTypeParameters, type2);
                collection.add(irValueParameter);
            }
            collection = (List)destination$iv$iv;
            irSimpleFunction = irSimpleFunction3;
            list2 = collection;
        } else {
            Collection<IrValueParameter> collection;
            $this$map$iv = from.getValueParameters();
            IrSimpleFunction irSimpleFunction4 = irSimpleFunction2;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrValueParameter $dstr$param$type = (IrValueParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                IrValueParameter irValueParameter = BridgeLowering.copyWithTypeErasure$default(this, (IrValueParameter)it, $this$copyParametersWithErasure, visibleTypeParameters, null, 4, null);
                collection.add(irValueParameter);
            }
            collection = (List)destination$iv$iv;
            irSimpleFunction = irSimpleFunction4;
            list2 = collection;
        }
        irSimpleFunction.setValueParameters(list2);
    }

    static /* synthetic */ void copyParametersWithErasure$default(BridgeLowering bridgeLowering, IrSimpleFunction irSimpleFunction, IrClass irClass2, IrSimpleFunction irSimpleFunction2, List list2, int n, Object object) {
        if ((n & 4) != 0) {
            list2 = null;
        }
        bridgeLowering.copyParametersWithErasure(irSimpleFunction, irClass2, irSimpleFunction2, list2);
    }

    private final IrValueParameter copyWithTypeErasure(IrValueParameter $this$copyWithTypeErasure, IrSimpleFunction target, Set<? extends IrTypeParameter> visibleTypeParameters, IrType substitutedType) {
        IrDeclarationOrigin.BRIDGE bRIDGE = IrDeclarationOrigin.BRIDGE.INSTANCE;
        IrType irType = substitutedType;
        IrType irType2 = irType == null ? null : org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.eraseToScope(irType, visibleTypeParameters);
        IrType irType3 = irType2 == null ? org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.eraseTypeParameters($this$copyWithTypeErasure.getType()) : irType2;
        irType = $this$copyWithTypeErasure.getVarargElementType();
        irType2 = irType == null ? null : org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.eraseToScope(irType, visibleTypeParameters);
        int n = target.getStartOffset();
        int n2 = target.getEndOffset();
        return org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default($this$copyWithTypeErasure, target, bRIDGE, 0, n, n2, null, null, irType3, irType2, null, false, false, false, 7780, null);
    }

    static /* synthetic */ IrValueParameter copyWithTypeErasure$default(BridgeLowering bridgeLowering, IrValueParameter irValueParameter, IrSimpleFunction irSimpleFunction, Set set, IrType irType, int n, Object object) {
        if ((n & 4) != 0) {
            irType = null;
        }
        return bridgeLowering.copyWithTypeErasure(irValueParameter, irSimpleFunction, set, irType);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression delegatingCall(IrBuilderWithScope $this$delegatingCall, IrSimpleFunction bridge, IrSimpleFunction target, IrClassSymbol superQualifierSymbol) {
        IrCall irCall = ExpressionHelpersKt.irCall($this$delegatingCall, target, IrStatementOrigin.BRIDGE_DELEGATION.INSTANCE, superQualifierSymbol);
        boolean bl = false;
        boolean bl2 = false;
        IrCall irCall2 = irCall;
        IrBuilderWithScope irBuilderWithScope = $this$delegatingCall;
        BridgeLowering bridgeLowering = this;
        boolean bl3 = false;
        for (Pair pair : CollectionsKt.zip((Iterable)IrUtilsKt.getExplicitParameters(bridge), (Iterable)IrUtilsKt.getExplicitParameters(target))) {
            void argument2;
            void $this$delegatingCall_u24lambda_u2d40;
            IrValueParameter param = (IrValueParameter)pair.component1();
            IrValueParameter targetParam = (IrValueParameter)pair.component2();
            IrGetValueImpl irGetValueImpl = ExpressionHelpersKt.irGet($this$delegatingCall, param);
            boolean bl4 = false;
            boolean bl5 = false;
            IrGetValueImpl irGetValueImpl2 = irGetValueImpl;
            IrValueParameter irValueParameter = targetParam;
            IrFunctionAccessExpression irFunctionAccessExpression = (IrFunctionAccessExpression)$this$delegatingCall_u24lambda_u2d40;
            boolean bl6 = false;
            IrExpression irExpression = Intrinsics.areEqual((Object)param, (Object)bridge.getDispatchReceiverParameter()) ? (IrExpression)argument2 : this.irCastIfNeeded($this$delegatingCall, (IrExpression)argument2, org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.getUpperBound(targetParam.getType()));
            IrFunctionAccessExpressionKt.putArgument(irFunctionAccessExpression, irValueParameter, irExpression);
        }
        Unit unit = Unit.INSTANCE;
        return bridgeLowering.irCastIfNeeded(irBuilderWithScope, irCall, org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.getUpperBound(bridge.getReturnType()));
    }

    static /* synthetic */ IrExpression delegatingCall$default(BridgeLowering bridgeLowering, IrBuilderWithScope irBuilderWithScope, IrSimpleFunction irSimpleFunction, IrSimpleFunction irSimpleFunction2, IrClassSymbol irClassSymbol, int n, Object object) {
        if ((n & 4) != 0) {
            irClassSymbol = null;
        }
        return bridgeLowering.delegatingCall(irBuilderWithScope, irSimpleFunction, irSimpleFunction2, irClassSymbol);
    }

    private final IrExpression irCastIfNeeded(IrBuilderWithScope $this$irCastIfNeeded, IrExpression expression2, IrType to) {
        return Intrinsics.areEqual((Object)expression2.getType(), (Object)to) || IrTypePredicatesKt.isAny(to) || IrTypePredicatesKt.isNullableAny(to) ? expression2 : (IrExpression)ExpressionHelpersKt.irImplicitCast($this$irCastIfNeeded, expression2, to);
    }

    private final Method getJvmMethod(IrFunction $this$jvmMethod) {
        return this.context.getBridgeLoweringCache$backend_jvm().computeJvmMethod($this$jvmMethod);
    }

    /*
     * WARNING - void declaration
     */
    private static final IrSimpleFunction createBridges$getSpecialBridgeTargetAddingExtraBridges(Set<Method> blacklist, SpecialBridge specialBridge, IrSimpleFunction $irFunction, BridgeLowering this$0, Ref.ObjectRef<IrSimpleFunction> bridgeTarget, IrClass $irClass, HashSet<Method> existingMethodSignatures2) {
        boolean bl;
        Collection collection;
        Object object;
        if (blacklist.contains(specialBridge.getSignature()) || $irFunction.isFakeOverride() && Intrinsics.areEqual((Object)this$0.getJvmMethod($irFunction), (Object)specialBridge.getSignature())) {
            return $irFunction;
        }
        if ($irFunction.isFakeOverride()) {
            IrSimpleFunction irSimpleFunction;
            Ref.ObjectRef<IrSimpleFunction> objectRef = bridgeTarget;
            if (org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.isJvmAbstract($irFunction, this$0.context.getState().getJvmDefaultMode())) {
                $irClass.getDeclarations().remove($irFunction);
                irSimpleFunction = this$0.addAbstractMethodStub($irClass, $irFunction);
            } else if ($irFunction.getModality() != Modality.FINAL) {
                Object superTarget;
                void it;
                object = BridgeLoweringKt.access$overriddenFromClass($irFunction);
                Intrinsics.checkNotNull((Object)object);
                Object overriddenFromClass = object;
                Method method = this$0.getJvmMethod($irFunction);
                Object object2 = IrUtilsKt.getParentAsClass((IrDeclaration)overriddenFromClass).getSymbol();
                SpecialMethodWithDefaultInfo specialMethodWithDefaultInfo = specialBridge.getMethodInfo();
                Object object3 = specialMethodWithDefaultInfo == null ? null : SpecialMethodWithDefaultInfo.copy$default(specialMethodWithDefaultInfo, null, 0, false, 5, null);
                SpecialBridge superBridge = new SpecialBridge($irFunction, method, false, null, null, (SpecialMethodWithDefaultInfo)object3, (IrClassSymbol)object2, false, false, false, 796, null);
                object3 = overriddenFromClass;
                boolean bl2 = false;
                boolean bl3 = false;
                Object object4 = object3;
                Ref.ObjectRef<IrSimpleFunction> objectRef2 = objectRef;
                boolean bl4 = false;
                boolean bl5 = !it.isFakeOverride();
                objectRef = objectRef2;
                object2 = bl5 ? object3 : null;
                Object object5 = superTarget = object2 == null ? specialBridge.getOverridden() : object2;
                if (Intrinsics.areEqual((Object)superBridge.getSignature(), (Object)this$0.getJvmMethod((IrFunction)superTarget))) {
                    irSimpleFunction = $irFunction;
                } else {
                    $irClass.getDeclarations().remove($irFunction);
                    irSimpleFunction = this$0.addSpecialBridge($irClass, superBridge, (IrSimpleFunction)superTarget);
                }
            } else {
                irSimpleFunction = $irFunction;
            }
            objectRef.element = irSimpleFunction;
            collection = blacklist;
            object = this$0.getJvmMethod((IrFunction)bridgeTarget.element);
            bl = false;
            collection.add(object);
        }
        if (existingMethodSignatures2.contains(specialBridge.getSignature())) {
            return $irFunction;
        }
        collection = blacklist;
        object = specialBridge.getSignature();
        bl = false;
        collection.add(object);
        return this$0.addSpecialBridge($irClass, specialBridge, (IrSimpleFunction)bridgeTarget.element);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/BridgeLowering$Bridge;", "", "overridden", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "signature", "Lorg/jetbrains/org/objectweb/asm/commons/Method;", "overriddenSymbols", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;Lorg/jetbrains/org/objectweb/asm/commons/Method;Ljava/util/List;)V", "getOverridden", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getOverriddenSymbols", "()Ljava/util/List;", "getSignature", "()Lorg/jetbrains/org/objectweb/asm/commons/Method;", "backend.jvm"})
    private static final class Bridge {
        @NotNull
        private final IrSimpleFunction overridden;
        @NotNull
        private final Method signature;
        @NotNull
        private final List<IrSimpleFunctionSymbol> overriddenSymbols;

        public Bridge(@NotNull IrSimpleFunction overridden, @NotNull Method signature2, @NotNull List<IrSimpleFunctionSymbol> overriddenSymbols2) {
            Intrinsics.checkNotNullParameter((Object)overridden, (String)"overridden");
            Intrinsics.checkNotNullParameter((Object)signature2, (String)"signature");
            Intrinsics.checkNotNullParameter(overriddenSymbols2, (String)"overriddenSymbols");
            this.overridden = overridden;
            this.signature = signature2;
            this.overriddenSymbols = overriddenSymbols2;
        }

        public /* synthetic */ Bridge(IrSimpleFunction irSimpleFunction, Method method, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                boolean bl = false;
                list2 = new ArrayList();
            }
            this(irSimpleFunction, method, list2);
        }

        @NotNull
        public final IrSimpleFunction getOverridden() {
            return this.overridden;
        }

        @NotNull
        public final Method getSignature() {
            return this.signature;
        }

        @NotNull
        public final List<IrSimpleFunctionSymbol> getOverriddenSymbols() {
            return this.overriddenSymbols;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001Bs\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0013J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\u0007H\u00c6\u0003J\u0011\u0010&\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003J\t\u0010*\u001a\u00020\u0007H\u00c6\u0003J\t\u0010+\u001a\u00020\u0007H\u00c6\u0003J{\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00072\b\b\u0002\u0010\u0011\u001a\u00020\u00072\b\b\u0002\u0010\u0012\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010-\u001a\u00020\u00072\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001J\t\u00101\u001a\u000202H\u00d6\u0001R\u0011\u0010\u0010\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0014R\u0011\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0014R\u0011\u0010\u0011\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0014R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0019\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/BridgeLowering$SpecialBridge;", "", "overridden", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "signature", "Lorg/jetbrains/org/objectweb/asm/commons/Method;", "needsGenericSignature", "", "substitutedParameterTypes", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "substitutedReturnType", "methodInfo", "Lorg/jetbrains/kotlin/backend/common/lower/SpecialMethodWithDefaultInfo;", "superQualifierSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "isFinal", "isSynthetic", "isOverriding", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;Lorg/jetbrains/org/objectweb/asm/commons/Method;ZLjava/util/List;Lorg/jetbrains/kotlin/ir/types/IrType;Lorg/jetbrains/kotlin/backend/common/lower/SpecialMethodWithDefaultInfo;Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;ZZZ)V", "()Z", "getMethodInfo", "()Lorg/jetbrains/kotlin/backend/common/lower/SpecialMethodWithDefaultInfo;", "getNeedsGenericSignature", "getOverridden", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getSignature", "()Lorg/jetbrains/org/objectweb/asm/commons/Method;", "getSubstitutedParameterTypes", "()Ljava/util/List;", "getSubstitutedReturnType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "getSuperQualifierSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "", "toString", "", "backend.jvm"})
    public static final class SpecialBridge {
        @NotNull
        private final IrSimpleFunction overridden;
        @NotNull
        private final Method signature;
        private final boolean needsGenericSignature;
        @Nullable
        private final List<IrType> substitutedParameterTypes;
        @Nullable
        private final IrType substitutedReturnType;
        @Nullable
        private final SpecialMethodWithDefaultInfo methodInfo;
        @Nullable
        private final IrClassSymbol superQualifierSymbol;
        private final boolean isFinal;
        private final boolean isSynthetic;
        private final boolean isOverriding;

        public SpecialBridge(@NotNull IrSimpleFunction overridden, @NotNull Method signature2, boolean needsGenericSignature, @Nullable List<? extends IrType> substitutedParameterTypes, @Nullable IrType substitutedReturnType, @Nullable SpecialMethodWithDefaultInfo methodInfo, @Nullable IrClassSymbol superQualifierSymbol, boolean isFinal, boolean isSynthetic, boolean isOverriding) {
            Intrinsics.checkNotNullParameter((Object)overridden, (String)"overridden");
            Intrinsics.checkNotNullParameter((Object)signature2, (String)"signature");
            this.overridden = overridden;
            this.signature = signature2;
            this.needsGenericSignature = needsGenericSignature;
            this.substitutedParameterTypes = substitutedParameterTypes;
            this.substitutedReturnType = substitutedReturnType;
            this.methodInfo = methodInfo;
            this.superQualifierSymbol = superQualifierSymbol;
            this.isFinal = isFinal;
            this.isSynthetic = isSynthetic;
            this.isOverriding = isOverriding;
        }

        public /* synthetic */ SpecialBridge(IrSimpleFunction irSimpleFunction, Method method, boolean bl, List list2, IrType irType, SpecialMethodWithDefaultInfo specialMethodWithDefaultInfo, IrClassSymbol irClassSymbol, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                list2 = null;
            }
            if ((n & 0x10) != 0) {
                irType = null;
            }
            if ((n & 0x20) != 0) {
                specialMethodWithDefaultInfo = null;
            }
            if ((n & 0x40) != 0) {
                irClassSymbol = null;
            }
            if ((n & 0x80) != 0) {
                bl2 = true;
            }
            if ((n & 0x100) != 0) {
                bl3 = false;
            }
            if ((n & 0x200) != 0) {
                bl4 = true;
            }
            this(irSimpleFunction, method, bl, list2, irType, specialMethodWithDefaultInfo, irClassSymbol, bl2, bl3, bl4);
        }

        @NotNull
        public final IrSimpleFunction getOverridden() {
            return this.overridden;
        }

        @NotNull
        public final Method getSignature() {
            return this.signature;
        }

        public final boolean getNeedsGenericSignature() {
            return this.needsGenericSignature;
        }

        @Nullable
        public final List<IrType> getSubstitutedParameterTypes() {
            return this.substitutedParameterTypes;
        }

        @Nullable
        public final IrType getSubstitutedReturnType() {
            return this.substitutedReturnType;
        }

        @Nullable
        public final SpecialMethodWithDefaultInfo getMethodInfo() {
            return this.methodInfo;
        }

        @Nullable
        public final IrClassSymbol getSuperQualifierSymbol() {
            return this.superQualifierSymbol;
        }

        public final boolean isFinal() {
            return this.isFinal;
        }

        public final boolean isSynthetic() {
            return this.isSynthetic;
        }

        public final boolean isOverriding() {
            return this.isOverriding;
        }

        @NotNull
        public final IrSimpleFunction component1() {
            return this.overridden;
        }

        @NotNull
        public final Method component2() {
            return this.signature;
        }

        public final boolean component3() {
            return this.needsGenericSignature;
        }

        @Nullable
        public final List<IrType> component4() {
            return this.substitutedParameterTypes;
        }

        @Nullable
        public final IrType component5() {
            return this.substitutedReturnType;
        }

        @Nullable
        public final SpecialMethodWithDefaultInfo component6() {
            return this.methodInfo;
        }

        @Nullable
        public final IrClassSymbol component7() {
            return this.superQualifierSymbol;
        }

        public final boolean component8() {
            return this.isFinal;
        }

        public final boolean component9() {
            return this.isSynthetic;
        }

        public final boolean component10() {
            return this.isOverriding;
        }

        @NotNull
        public final SpecialBridge copy(@NotNull IrSimpleFunction overridden, @NotNull Method signature2, boolean needsGenericSignature, @Nullable List<? extends IrType> substitutedParameterTypes, @Nullable IrType substitutedReturnType, @Nullable SpecialMethodWithDefaultInfo methodInfo, @Nullable IrClassSymbol superQualifierSymbol, boolean isFinal, boolean isSynthetic, boolean isOverriding) {
            Intrinsics.checkNotNullParameter((Object)overridden, (String)"overridden");
            Intrinsics.checkNotNullParameter((Object)signature2, (String)"signature");
            return new SpecialBridge(overridden, signature2, needsGenericSignature, substitutedParameterTypes, substitutedReturnType, methodInfo, superQualifierSymbol, isFinal, isSynthetic, isOverriding);
        }

        public static /* synthetic */ SpecialBridge copy$default(SpecialBridge specialBridge, IrSimpleFunction irSimpleFunction, Method method, boolean bl, List list2, IrType irType, SpecialMethodWithDefaultInfo specialMethodWithDefaultInfo, IrClassSymbol irClassSymbol, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
            if ((n & 1) != 0) {
                irSimpleFunction = specialBridge.overridden;
            }
            if ((n & 2) != 0) {
                method = specialBridge.signature;
            }
            if ((n & 4) != 0) {
                bl = specialBridge.needsGenericSignature;
            }
            if ((n & 8) != 0) {
                list2 = specialBridge.substitutedParameterTypes;
            }
            if ((n & 0x10) != 0) {
                irType = specialBridge.substitutedReturnType;
            }
            if ((n & 0x20) != 0) {
                specialMethodWithDefaultInfo = specialBridge.methodInfo;
            }
            if ((n & 0x40) != 0) {
                irClassSymbol = specialBridge.superQualifierSymbol;
            }
            if ((n & 0x80) != 0) {
                bl2 = specialBridge.isFinal;
            }
            if ((n & 0x100) != 0) {
                bl3 = specialBridge.isSynthetic;
            }
            if ((n & 0x200) != 0) {
                bl4 = specialBridge.isOverriding;
            }
            return specialBridge.copy(irSimpleFunction, method, bl, list2, irType, specialMethodWithDefaultInfo, irClassSymbol, bl2, bl3, bl4);
        }

        @NotNull
        public String toString() {
            return "SpecialBridge(overridden=" + this.overridden + ", signature=" + this.signature + ", needsGenericSignature=" + this.needsGenericSignature + ", substitutedParameterTypes=" + this.substitutedParameterTypes + ", substitutedReturnType=" + this.substitutedReturnType + ", methodInfo=" + this.methodInfo + ", superQualifierSymbol=" + this.superQualifierSymbol + ", isFinal=" + this.isFinal + ", isSynthetic=" + this.isSynthetic + ", isOverriding=" + this.isOverriding + ')';
        }

        public int hashCode() {
            int result2 = this.overridden.hashCode();
            result2 = result2 * 31 + this.signature.hashCode();
            int n = this.needsGenericSignature ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            result2 = result2 * 31 + (this.substitutedParameterTypes == null ? 0 : ((Object)this.substitutedParameterTypes).hashCode());
            result2 = result2 * 31 + (this.substitutedReturnType == null ? 0 : this.substitutedReturnType.hashCode());
            result2 = result2 * 31 + (this.methodInfo == null ? 0 : this.methodInfo.hashCode());
            result2 = result2 * 31 + (this.superQualifierSymbol == null ? 0 : this.superQualifierSymbol.hashCode());
            int n2 = this.isFinal ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result2 = result2 * 31 + n2;
            int n3 = this.isSynthetic ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            result2 = result2 * 31 + n3;
            int n4 = this.isOverriding ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            result2 = result2 * 31 + n4;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SpecialBridge)) {
                return false;
            }
            SpecialBridge specialBridge = (SpecialBridge)other;
            if (!Intrinsics.areEqual((Object)this.overridden, (Object)specialBridge.overridden)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.signature, (Object)specialBridge.signature)) {
                return false;
            }
            if (this.needsGenericSignature != specialBridge.needsGenericSignature) {
                return false;
            }
            if (!Intrinsics.areEqual(this.substitutedParameterTypes, specialBridge.substitutedParameterTypes)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.substitutedReturnType, (Object)specialBridge.substitutedReturnType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.methodInfo, (Object)specialBridge.methodInfo)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.superQualifierSymbol, (Object)specialBridge.superQualifierSymbol)) {
                return false;
            }
            if (this.isFinal != specialBridge.isFinal) {
                return false;
            }
            if (this.isSynthetic != specialBridge.isSynthetic) {
                return false;
            }
            return this.isOverriding == specialBridge.isOverriding;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/BridgeLowering$BridgeLoweringCache;", "", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "signatureCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "Lorg/jetbrains/org/objectweb/asm/commons/Method;", "specialBridgeMethods", "Lorg/jetbrains/kotlin/backend/common/lower/SpecialBridgeMethods;", "canHaveSpecialBridge", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "computeJvmMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "computeSpecialBridge", "Lorg/jetbrains/kotlin/backend/jvm/lower/BridgeLowering$SpecialBridge;", "backend.jvm"})
    public static final class BridgeLoweringCache {
        @NotNull
        private final JvmBackendContext context;
        @NotNull
        private final SpecialBridgeMethods specialBridgeMethods;
        @NotNull
        private final ConcurrentHashMap<IrFunctionSymbol, Method> signatureCache;

        public BridgeLoweringCache(@NotNull JvmBackendContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            this.context = context2;
            this.specialBridgeMethods = new SpecialBridgeMethods(this.context);
            this.signatureCache = new ConcurrentHashMap();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Method computeJvmMethod(@NotNull IrFunction function2) {
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            ConcurrentMap concurrentMap = this.signatureCache;
            IrFunctionSymbol key$iv = function2.getSymbol();
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(key$iv);
            if (object == null) {
                boolean bl = false;
                Method method = this.context.getMethodSignatureMapper().mapAsmMethod(function2);
                boolean bl2 = false;
                boolean bl3 = false;
                Method default$iv = method;
                boolean bl4 = false;
                object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            Object v = object;
            Intrinsics.checkNotNullExpressionValue(v, (String)"signatureCache.getOrPut(function.symbol) { context.methodSignatureMapper.mapAsmMethod(function) }");
            return (Method)v;
        }

        private final boolean canHaveSpecialBridge(IrSimpleFunction function2) {
            boolean bl;
            block4: {
                if (this.specialBridgeMethods.getSpecialMethodNames().contains(function2.getName())) {
                    return true;
                }
                String string2 = function2.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"function.name.asString()");
                String functionName = string2;
                Iterable $this$any$iv = this.specialBridgeMethods.getSpecialMethodNames();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Name it = (Name)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.startsWith$default((String)functionName, (String)Intrinsics.stringPlus((String)it.asString(), (Object)"-"), (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final SpecialBridge computeSpecialBridge(@NotNull IrSimpleFunction function2) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            IrPropertySymbol correspondingProperty2 = function2.getCorrespondingPropertySymbol();
            if (correspondingProperty2 != null ? !this.specialBridgeMethods.getSpecialPropertyNames().contains(((IrProperty)correspondingProperty2.getOwner()).getName()) : !this.canHaveSpecialBridge(function2)) {
                return null;
            }
            SpecialMethodWithDefaultInfo specialMethodInfo = this.specialBridgeMethods.getSpecialMethodInfo(function2);
            if (specialMethodInfo != null) {
                return new SpecialBridge(function2, this.computeJvmMethod(function2), specialMethodInfo.getNeedsGenericSignature(), null, null, specialMethodInfo, null, false, false, false, 984, null);
            }
            BuiltInWithDifferentJvmName specialBuiltInInfo = this.specialBridgeMethods.getBuiltInWithDifferentJvmName(function2);
            if (specialBuiltInInfo != null) {
                return new SpecialBridge(function2, this.computeJvmMethod(function2), specialBuiltInInfo.getNeedsGenericSignature(), null, null, null, null, false, false, specialBuiltInInfo.isOverriding(), 504, null);
            }
            for (IrSimpleFunctionSymbol overridden : function2.getOverriddenSymbols()) {
                Collection<IrValueParameter> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Name param;
                void $this$mapIndexedTo$iv$iv;
                int n;
                SpecialBridge specialBridge = this.computeSpecialBridge((IrSimpleFunction)overridden.getOwner());
                if (specialBridge == null) continue;
                SpecialBridge specialBridge2 = specialBridge;
                if (!specialBridge2.getNeedsGenericSignature()) {
                    return specialBridge2;
                }
                SpecialMethodWithDefaultInfo specialMethodWithDefaultInfo = specialBridge2.getMethodInfo();
                int erasedParameterCount = specialMethodWithDefaultInfo == null ? 0 : (n = specialMethodWithDefaultInfo.getArgumentsToCheck());
                Iterable $this$mapIndexed$iv = function2.getValueParameters();
                boolean $i$f$mapIndexed = false;
                Iterable iterable = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void index2;
                    int n2 = index$iv$iv++;
                    boolean bl = false;
                    if (n2 < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                    int n3 = n2;
                    Collection collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    IrType irType = index2 < erasedParameterCount ? this.context.getIrBuiltIns().getAnyNType() : ((IrValueDeclaration)((Object)param)).getType();
                    collection2.add(irType);
                }
                List substitutedParameterTypes = (List)destination$iv$iv;
                IrFactory $this$buildFun$iv = this.context.getIrFactory();
                boolean $i$f$buildFun = false;
                IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
                $i$f$mapIndexedTo = false;
                index$iv$iv = 0;
                Object $this$buildFun_u24lambda_u2d14$iv = irFunctionBuilder;
                boolean bl = false;
                IrFunctionBuilder $this$computeSpecialBridge_u24lambda_u2d3 = $this$buildFun_u24lambda_u2d14$iv;
                boolean $i$a$-buildFun-BridgeLowering$BridgeLoweringCache$computeSpecialBridge$substitutedOverride$22 = false;
                $this$computeSpecialBridge_u24lambda_u2d3.updateFrom(specialBridge2.getOverridden());
                param = Name.identifier(specialBridge2.getSignature().getName());
                Intrinsics.checkNotNullExpressionValue((Object)param, (String)"identifier(specialBridge.signature.name)");
                $this$computeSpecialBridge_u24lambda_u2d3.setName(param);
                $this$computeSpecialBridge_u24lambda_u2d3.setReturnType(function2.getReturnType());
                IrSimpleFunction irSimpleFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u2d14$iv);
                boolean bl3 = false;
                boolean bl4 = false;
                IrSimpleFunction $this$computeSpecialBridge_u24lambda_u2d5 = irSimpleFunction;
                boolean bl5 = false;
                $this$buildFun_u24lambda_u2d14$iv = CollectionsKt.zip((Iterable)function2.getValueParameters(), (Iterable)substitutedParameterTypes);
                IrSimpleFunction irSimpleFunction2 = $this$computeSpecialBridge_u24lambda_u2d5;
                boolean $i$f$map = false;
                void $i$a$-buildFun-BridgeLowering$BridgeLoweringCache$computeSpecialBridge$substitutedOverride$22 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void $dstr$param$type;
                    Pair pair = (Pair)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl6 = false;
                    IrValueParameter param2 = (IrValueParameter)$dstr$param$type.component1();
                    IrType type2 = (IrType)$dstr$param$type.component2();
                    IrValueParameter irValueParameter = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(param2, $this$computeSpecialBridge_u24lambda_u2d5, IrDeclarationOrigin.BRIDGE.INSTANCE, 0, 0, 0, null, null, type2, null, null, false, false, false, 8060, null);
                    collection.add(irValueParameter);
                }
                collection = (List)destination$iv$iv2;
                irSimpleFunction2.setValueParameters((List<? extends IrValueParameter>)collection);
                $this$computeSpecialBridge_u24lambda_u2d5.setOverriddenSymbols(CollectionsKt.listOf((Object)specialBridge2.getOverridden().getSymbol()));
                $this$computeSpecialBridge_u24lambda_u2d5.setParent(function2.getParent());
                IrSimpleFunction substitutedOverride = irSimpleFunction;
                return SpecialBridge.copy$default(specialBridge2, null, this.computeJvmMethod(substitutedOverride), false, substitutedParameterTypes, function2.getReturnType(), null, null, false, false, false, 997, null);
            }
            return null;
        }
    }
}

