/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirRealSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\r\u001a\u00020\u00062\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionParameterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkParameterTypes", "checkVarargParameters", "function", "checkers"})
public final class FirFunctionParameterChecker
extends FirDeclarationChecker<FirFunction<?>> {
    @NotNull
    public static final FirFunctionParameterChecker INSTANCE = new FirFunctionParameterChecker();

    private FirFunctionParameterChecker() {
    }

    @Override
    public void check(@NotNull FirFunction<?> declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.checkVarargParameters(declaration2, context2, reporter);
        this.checkParameterTypes(declaration2, context2, reporter);
    }

    private final void checkParameterTypes(FirFunction<?> declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        for (FirValueParameter valueParameter2 : declaration2.getValueParameters()) {
            ConeDiagnostic diagnostic;
            FirSourceElement firSourceElement;
            FirTypeRef returnTypeRef = valueParameter2.getReturnTypeRef();
            if (!(returnTypeRef instanceof FirErrorTypeRef) || Intrinsics.areEqual((Object)((firSourceElement = returnTypeRef.getSource()) == null ? null : firSourceElement.getKind()), (Object)FirRealSourceElementKind.INSTANCE) || !((diagnostic = ((FirErrorTypeRef)returnTypeRef).getDiagnostic()) instanceof ConeSimpleDiagnostic) || ((ConeSimpleDiagnostic)diagnostic).getKind() != DiagnosticKind.ValueParameterWithNoTypeAnnotation) continue;
            DiagnosticReporterKt.reportOnWithSuppression(reporter, valueParameter2, FirErrors.INSTANCE.getVALUE_PARAMETER_WITH_NO_TYPE_ANNOTATION(), context2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVarargParameters(FirFunction<?> function2, CheckerContext context2, DiagnosticReporter reporter) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = function2.getValueParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirValueParameter it = (FirValueParameter)element$iv$iv;
            boolean bl = false;
            if (!it.isVararg()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List varargParameters = (List)destination$iv$iv;
        if (varargParameters.size() > 1) {
            for (FirValueParameter parameter : varargParameters) {
                DiagnosticReporterKt.reportOnWithSuppression(reporter, parameter, FirErrors.INSTANCE.getMULTIPLE_VARARG_PARAMETERS(), context2);
            }
        }
        ConeKotlinType nullableNothingType = FirTypeUtilsKt.getConeType(context2.getSession().getBuiltinTypes().getNullableNothingType());
        for (FirValueParameter varargParameter : varargParameters) {
            ConeKotlinType coneKotlinType = ArrayUtilsKt.arrayElementType(FirTypeUtilsKt.getConeType(varargParameter.getReturnTypeRef()));
            if (coneKotlinType == null) continue;
            ConeKotlinType varargParameterType = coneKotlinType;
            if (!AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, SessionUtilsKt.getTypeContext(context2.getSession()), (KotlinTypeMarker)varargParameterType, (KotlinTypeMarker)nullableNothingType, false, 8, null) && (!FirHelpersKt.isInline(varargParameterType, context2.getSession()) || ConeTypeUtilsKt.isUnsignedTypeOrNullableUnsignedType(varargParameterType))) continue;
            DiagnosticReporterKt.reportOnWithSuppression(reporter, varargParameter, FirErrors.INSTANCE.getFORBIDDEN_VARARG_PARAMETER_TYPE(), varargParameterType, context2);
        }
    }
}

