/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionClassKind;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.TypeRendererKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0003\u001a\f\u0010\u0004\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a7\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0019\b\u0002\u0010\n\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u000b\u00a2\u0006\u0002\b\f\u001a\u001d\u0010\r\u001a\u00020\t*\u0004\u0018\u00010\u0007\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\b\u0003\u0010\u0000\u00a8\u0006\u000e"}, d2={"render", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "renderAttributes", "renderFunctionType", "kind", "Lorg/jetbrains/kotlin/builtins/functions/FunctionClassKind;", "isExtension", "", "renderType", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "withPrettyRender", "cones"})
public final class TypeRendererKt {
    @NotNull
    public static final String render(@NotNull ConeKotlinType $this$render) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        String nullabilitySuffix = !($this$render instanceof ConeFlexibleType) && !($this$render instanceof ConeClassErrorType) ? $this$render.getNullability().getSuffix() : "";
        ConeKotlinType coneKotlinType = $this$render;
        if (coneKotlinType instanceof ConeTypeVariableType) {
            string2 = TypeRendererKt.renderAttributes($this$render) + "TypeVariable(" + ((ConeTypeVariableType)$this$render).getLookupTag().getName() + ')';
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            string2 = Intrinsics.stringPlus((String)TypeRendererKt.render(((ConeDefinitelyNotNullType)$this$render).getOriginal()), (Object)"!!");
        } else if (coneKotlinType instanceof ConeClassErrorType) {
            string2 = TypeRendererKt.renderAttributes($this$render) + "ERROR CLASS: " + ((ConeClassErrorType)$this$render).getDiagnostic().getReason();
        } else if (coneKotlinType instanceof ConeCapturedType) {
            string2 = TypeRendererKt.renderAttributes($this$render) + "CapturedType(" + TypeRendererKt.render(((ConeCapturedType)$this$render).getConstructor().getProjection()) + ')';
        } else if (coneKotlinType instanceof ConeClassLikeType) {
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder stringBuilder2 = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder $this$render_u24lambda_u2d0 = stringBuilder2;
            boolean bl5 = false;
            $this$render_u24lambda_u2d0.append(TypeRendererKt.renderAttributes($this$render));
            $this$render_u24lambda_u2d0.append(((ConeClassLikeType)$this$render).getLookupTag().getClassId().asString());
            ConeTypeProjection[] coneTypeProjectionArray = $this$render.getTypeArguments();
            boolean bl6 = false;
            ConeTypeProjection[] coneTypeProjectionArray2 = coneTypeProjectionArray;
            boolean bl7 = false;
            if (!(coneTypeProjectionArray2.length == 0)) {
                $this$render_u24lambda_u2d0.append(ArraysKt.joinToString$default((Object[])$this$render.getTypeArguments(), null, (CharSequence)"<", (CharSequence)">", (int)0, null, (Function1)render.1.1.INSTANCE, (int)25, null));
            }
            String string3 = stringBuilder2.toString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        } else if (coneKotlinType instanceof ConeLookupTagBasedType) {
            string2 = Intrinsics.stringPlus((String)TypeRendererKt.renderAttributes($this$render), (Object)((ConeLookupTagBasedType)$this$render).getLookupTag().getName().asString());
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            boolean bl = false;
            boolean bl8 = false;
            StringBuilder stringBuilder3 = new StringBuilder();
            boolean bl9 = false;
            boolean bl10 = false;
            StringBuilder $this$render_u24lambda_u2d1 = stringBuilder3;
            boolean bl11 = false;
            $this$render_u24lambda_u2d1.append("ft<");
            $this$render_u24lambda_u2d1.append(TypeRendererKt.render(((ConeFlexibleType)$this$render).getLowerBound()));
            $this$render_u24lambda_u2d1.append(", ");
            $this$render_u24lambda_u2d1.append(TypeRendererKt.render(((ConeFlexibleType)$this$render).getUpperBound()));
            $this$render_u24lambda_u2d1.append(">");
            String string4 = stringBuilder3.toString();
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            string2 = CollectionsKt.joinToString$default((Iterable)((ConeIntersectionType)$this$render).getIntersectedTypes(), (CharSequence)" & ", (CharSequence)Intrinsics.stringPlus((String)TypeRendererKt.renderAttributes($this$render), (Object)"it("), (CharSequence)")", (int)0, null, null, (int)56, null);
        } else if (coneKotlinType instanceof ConeStubType) {
            string2 = TypeRendererKt.renderAttributes($this$render) + "Stub: " + ((ConeStubType)$this$render).getVariable();
        } else if (coneKotlinType instanceof ConeIntegerLiteralType) {
            string2 = TypeRendererKt.renderAttributes($this$render) + "ILT: " + ((ConeIntegerLiteralType)$this$render).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return Intrinsics.stringPlus((String)string2, (Object)nullabilitySuffix);
    }

    private static final String renderAttributes(ConeKotlinType $this$renderAttributes) {
        if (!CollectionsKt.any((Iterable)$this$renderAttributes.getAttributes())) {
            return "";
        }
        return CollectionsKt.joinToString$default((Iterable)$this$renderAttributes.getAttributes(), (CharSequence)" ", null, (CharSequence)" ", (int)0, null, (Function1)renderAttributes.1.INSTANCE, (int)26, null);
    }

    @NotNull
    public static final String render(@NotNull ConeTypeProjection $this$render) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        ConeTypeProjection coneTypeProjection = $this$render;
        if (Intrinsics.areEqual((Object)coneTypeProjection, (Object)ConeStarProjection.INSTANCE)) {
            string2 = "*";
        } else if (coneTypeProjection instanceof ConeKotlinTypeProjectionIn) {
            string2 = Intrinsics.stringPlus((String)"in ", (Object)TypeRendererKt.render(((ConeKotlinTypeProjectionIn)$this$render).getType()));
        } else if (coneTypeProjection instanceof ConeKotlinTypeProjectionOut) {
            string2 = Intrinsics.stringPlus((String)"out ", (Object)TypeRendererKt.render(((ConeKotlinTypeProjectionOut)$this$render).getType()));
        } else if (coneTypeProjection instanceof ConeKotlinType) {
            string2 = TypeRendererKt.render((ConeKotlinType)$this$render);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    @NotNull
    public static final String renderFunctionType(@NotNull ConeKotlinType $this$renderFunctionType, @Nullable FunctionClassKind kind, boolean isExtension, @NotNull Function1<? super ConeTypeProjection, String> renderType) {
        Intrinsics.checkNotNullParameter((Object)$this$renderFunctionType, (String)"<this>");
        Intrinsics.checkNotNullParameter(renderType, (String)"renderType");
        if (!TypeRendererKt.withPrettyRender(kind)) {
            return (String)renderType.invoke((Object)$this$renderFunctionType);
        }
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$renderFunctionType_u24lambda_u2d2 = stringBuilder2;
        boolean bl5 = false;
        if (kind == FunctionClassKind.SuspendFunction) {
            $this$renderFunctionType_u24lambda_u2d2.append("suspend ");
        }
        Pair pair = isExtension && !Intrinsics.areEqual((Object)ArraysKt.first((Object[])$this$renderFunctionType.getTypeArguments()), (Object)ConeStarProjection.INSTANCE) ? TuplesKt.to((Object)ArraysKt.first((Object[])$this$renderFunctionType.getTypeArguments()), (Object)ArraysKt.drop((Object[])$this$renderFunctionType.getTypeArguments(), (int)1)) : TuplesKt.to(null, (Object)ArraysKt.toList((Object[])$this$renderFunctionType.getTypeArguments()));
        ConeTypeProjection receiver = (ConeTypeProjection)pair.component1();
        List otherTypeArguments = (List)pair.component2();
        List arguments2 = otherTypeArguments.subList(0, otherTypeArguments.size() - 1);
        ConeTypeProjection returnType2 = (ConeTypeProjection)CollectionsKt.last((List)otherTypeArguments);
        if (receiver != null) {
            $this$renderFunctionType_u24lambda_u2d2.append((String)renderType.invoke((Object)receiver));
            $this$renderFunctionType_u24lambda_u2d2.append(".");
        }
        $this$renderFunctionType_u24lambda_u2d2.append(CollectionsKt.joinToString$default((Iterable)arguments2, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)((Function1)new Function1<ConeTypeProjection, CharSequence>(renderType){
            final /* synthetic */ Function1<ConeTypeProjection, String> $renderType;
            {
                this.$renderType = $renderType;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull ConeTypeProjection it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (CharSequence)this.$renderType.invoke((Object)it);
            }
        }), (int)24, null));
        $this$renderFunctionType_u24lambda_u2d2.append(" -> ");
        $this$renderFunctionType_u24lambda_u2d2.append((String)renderType.invoke((Object)returnType2));
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        String renderedType2 = string2;
        return ConeTypeUtilsKt.isMarkedNullable($this$renderFunctionType) ? '(' + renderedType2 + ")?" : renderedType2;
    }

    public static /* synthetic */ String renderFunctionType$default(ConeKotlinType coneKotlinType, FunctionClassKind functionClassKind, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = renderFunctionType.1.INSTANCE;
        }
        return TypeRendererKt.renderFunctionType(coneKotlinType, functionClassKind, bl, (Function1<? super ConeTypeProjection, String>)function1);
    }

    public static final boolean withPrettyRender(@Nullable FunctionClassKind $this$withPrettyRender) {
        boolean bl = false;
        return $this$withPrettyRender != null && $this$withPrettyRender != FunctionClassKind.KSuspendFunction && $this$withPrettyRender != FunctionClassKind.KFunction;
    }
}

