/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.analyze;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.functions.FunctionInterfaceFactoryKt;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.container.DslKt;
import org.jetbrains.kotlin.container.StorageComponentContainer;
import org.jetbrains.kotlin.context.ContextKt;
import org.jetbrains.kotlin.context.ModuleContext;
import org.jetbrains.kotlin.context.MutableModuleContext;
import org.jetbrains.kotlin.context.ProjectContext;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.frontend.js.di.InjectionKt;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.config.ErrorTolerancePolicy;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.resolve.BindingContextSlicesJsKt;
import org.jetbrains.kotlin.js.resolve.JsPlatformAnalyzerServices;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.js.JsPlatforms;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzer;
import org.jetbrains.kotlin.resolve.TargetEnvironment;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.extensions.AnalysisHandlerExtension;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.serialization.js.ModuleKind;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J^\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u000eJL\u0010\u0015\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\rJ$\u0010\u001c\u001a\u00020\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J(\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H$\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/js/analyze/AbstractTopDownAnalyzerFacadeForJS;", "", "()V", "analyzeFiles", "Lorg/jetbrains/kotlin/js/analyzer/JsAnalysisResult;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "moduleDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "friendModuleDescriptors", "targetEnvironment", "Lorg/jetbrains/kotlin/resolve/TargetEnvironment;", "thisIsBuiltInsModule", "", "customBuiltInsModule", "analyzeFilesWithGivenTrace", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "moduleContext", "Lorg/jetbrains/kotlin/context/ModuleContext;", "additionalPackages", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "checkForErrors", "allFiles", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "errorPolicy", "Lorg/jetbrains/kotlin/js/config/ErrorTolerancePolicy;", "loadIncrementalCacheMetadata", "incrementalData", "Lorg/jetbrains/kotlin/incremental/js/IncrementalDataProvider;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "js.frontend"})
public abstract class AbstractTopDownAnalyzerFacadeForJS {
    @NotNull
    public final JsAnalysisResult analyzeFiles(@NotNull Collection<? extends KtFile> files2, @NotNull Project project, @NotNull CompilerConfiguration configuration, @NotNull List<ModuleDescriptorImpl> moduleDescriptors, @NotNull List<ModuleDescriptorImpl> friendModuleDescriptors, @NotNull TargetEnvironment targetEnvironment, boolean thisIsBuiltInsModule, @Nullable ModuleDescriptorImpl customBuiltInsModule) {
        Object object;
        String string2;
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(moduleDescriptors, (String)"moduleDescriptors");
        Intrinsics.checkNotNullParameter(friendModuleDescriptors, (String)"friendModuleDescriptors");
        Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
        boolean bl = !thisIsBuiltInsModule || customBuiltInsModule == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string3 = "Can't simultaneously use custom built-ins module and set current module as built-ins";
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        KotlinBuiltIns builtIns = thisIsBuiltInsModule ? (KotlinBuiltIns)new DefaultBuiltIns(false) : (customBuiltInsModule != null ? customBuiltInsModule.getBuiltIns() : JsPlatformAnalyzerServices.INSTANCE.getBuiltIns());
        Object bl4 = configuration.get(CommonConfigurationKeys.MODULE_NAME);
        Intrinsics.checkNotNull((Object)bl4);
        String moduleName = string2 = bl4;
        ProjectContext projectContext = ContextKt.ProjectContext(project, "TopDownAnalyzer for JS");
        bl4 = Name.special('<' + moduleName + '>');
        Intrinsics.checkNotNullExpressionValue((Object)bl4, (String)"special(\"<$moduleName>\")");
        MutableModuleContext context2 = ContextKt.ContextForNewModule$default(projectContext, (Name)bl4, builtIns, JsPlatforms.INSTANCE.getDefaultJsPlatform(), null, 16, null);
        boolean bl5 = false;
        List additionalPackages = new ArrayList();
        if (thisIsBuiltInsModule) {
            builtIns.setBuiltInsModule(context2.getModule());
            Collection collection = additionalPackages;
            object = FunctionInterfaceFactoryKt.functionInterfacePackageFragmentProvider(context2.getStorageManager(), context2.getModule());
            boolean bl6 = false;
            collection.add(object);
        }
        object = new ModuleDescriptorImpl[]{context2.getModule()};
        Set set = SetsKt.plus((Set)SetsKt.mutableSetOf((Object[])object), (Iterable)moduleDescriptors);
        object = builtIns.getBuiltInsModule();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"builtIns.builtInsModule");
        Set dependencies2 = SetsKt.plus((Set)set, (Object)object);
        context2.getModule().setDependencies(CollectionsKt.toList((Iterable)dependencies2), CollectionsKt.toSet((Iterable)friendModuleDescriptors));
        ModuleKind moduleKind = configuration.get(JSConfigurationKeys.MODULE_KIND, ModuleKind.PLAIN);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)moduleKind), (String)"configuration.get(JSConfigurationKeys.MODULE_KIND, ModuleKind.PLAIN)");
        ModuleKind moduleKind2 = moduleKind;
        BindingTraceContext trace = new BindingTraceContext();
        trace.record(BindingContextSlicesJsKt.MODULE_KIND, context2.getModule(), moduleKind2);
        return this.analyzeFilesWithGivenTrace(files2, trace, context2, configuration, targetEnvironment, project, additionalPackages);
    }

    public static /* synthetic */ JsAnalysisResult analyzeFiles$default(AbstractTopDownAnalyzerFacadeForJS abstractTopDownAnalyzerFacadeForJS, Collection collection, Project project, CompilerConfiguration compilerConfiguration, List list2, List list3, TargetEnvironment targetEnvironment, boolean bl, ModuleDescriptorImpl moduleDescriptorImpl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: analyzeFiles");
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        if ((n & 0x80) != 0) {
            moduleDescriptorImpl = null;
        }
        return abstractTopDownAnalyzerFacadeForJS.analyzeFiles(collection, project, compilerConfiguration, list2, list3, targetEnvironment, bl, moduleDescriptorImpl);
    }

    @NotNull
    protected abstract PackageFragmentProvider loadIncrementalCacheMetadata(@NotNull IncrementalDataProvider var1, @NotNull ModuleContext var2, @NotNull LookupTracker var3, @NotNull LanguageVersionSettings var4);

    @NotNull
    public final JsAnalysisResult analyzeFilesWithGivenTrace(@NotNull Collection<? extends KtFile> files2, @NotNull BindingTrace trace, @NotNull ModuleContext moduleContext, @NotNull CompilerConfiguration configuration, @NotNull TargetEnvironment targetEnvironment, @NotNull Project project, @NotNull List<? extends PackageFragmentProvider> additionalPackages) {
        JsAnalysisResult jsAnalysisResult;
        AnalysisResult analysisResult2;
        AnalysisResult result2;
        AnalysisResult analysisResult3;
        block9: {
            AnalysisResult analysisResult4;
            Object element$iv;
            boolean $i$f$firstNotNullResult;
            Object $this$firstNotNullResult$iv;
            List analysisHandlerExtensions;
            StorageComponentContainer container2;
            block8: {
                AnalysisResult analysisResult5;
                PackageFragmentProvider packageFragmentProvider;
                Intrinsics.checkNotNullParameter(files2, (String)"files");
                Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
                Intrinsics.checkNotNullParameter((Object)moduleContext, (String)"moduleContext");
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(additionalPackages, (String)"additionalPackages");
                Object object = configuration.get(CommonConfigurationKeys.LOOKUP_TRACKER);
                LookupTracker lookupTracker = object == null ? (LookupTracker)LookupTracker.DO_NOTHING.INSTANCE : object;
                Intrinsics.checkNotNullExpressionValue((Object)lookupTracker, (String)"configuration.get(CommonConfigurationKeys.LOOKUP_TRACKER) ?: LookupTracker.DO_NOTHING");
                LookupTracker lookupTracker2 = lookupTracker;
                ExpectActualTracker expectActualTracker = configuration.get(CommonConfigurationKeys.EXPECT_ACTUAL_TRACKER);
                object = expectActualTracker == null ? (ExpectActualTracker)ExpectActualTracker.DoNothing.INSTANCE : expectActualTracker;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"configuration.get(CommonConfigurationKeys.EXPECT_ACTUAL_TRACKER) ?: ExpectActualTracker.DoNothing");
                Object expectActualTracker2 = object;
                LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings(configuration);
                IncrementalDataProvider incrementalDataProvider = configuration.get(JSConfigurationKeys.INCREMENTAL_DATA_PROVIDER);
                if (incrementalDataProvider == null) {
                    packageFragmentProvider = null;
                } else {
                    IncrementalDataProvider incrementalDataProvider2 = incrementalDataProvider;
                    boolean bl = false;
                    boolean bl2 = false;
                    IncrementalDataProvider it = incrementalDataProvider2;
                    boolean bl3 = false;
                    packageFragmentProvider = this.loadIncrementalCacheMetadata(it, moduleContext, lookupTracker2, languageVersionSettings);
                }
                PackageFragmentProvider packageFragment = packageFragmentProvider;
                container2 = InjectionKt.createContainerForJS(moduleContext, trace, new FileBasedDeclarationProviderFactory(moduleContext.getStorageManager(), files2), languageVersionSettings, lookupTracker2, (ExpectActualTracker)expectActualTracker2, CollectionsKt.plus((Collection)additionalPackages, (Iterable)CollectionsKt.listOfNotNull((Object)packageFragment)), targetEnvironment);
                analysisHandlerExtensions = AnalysisHandlerExtension.Companion.getInstances(project);
                $this$firstNotNullResult$iv = analysisHandlerExtensions;
                $i$f$firstNotNullResult = false;
                Iterator iterator2 = $this$firstNotNullResult$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv = iterator2.next();
                    AnalysisHandlerExtension extension = (AnalysisHandlerExtension)element$iv;
                    boolean bl = false;
                    AnalysisResult result$iv = extension.doAnalysis(project, moduleContext.getModule(), moduleContext, files2, trace, container2);
                    if (result$iv == null) continue;
                    analysisResult5 = result$iv;
                    break block8;
                }
                analysisResult5 = analysisResult3 = null;
            }
            if (analysisResult3 == null) {
                $this$firstNotNullResult$iv = this;
                $i$f$firstNotNullResult = false;
                boolean bl = false;
                AbstractTopDownAnalyzerFacadeForJS $this$analyzeFilesWithGivenTrace_u24lambda_u2d3 = (AbstractTopDownAnalyzerFacadeForJS)$this$firstNotNullResult$iv;
                boolean bl4 = false;
                Object $this$get$iv = container2;
                boolean $i$f$get = false;
                LazyTopDownAnalyzer.analyzeDeclarations$default(DslKt.getService((ComponentProvider)$this$get$iv, LazyTopDownAnalyzer.class), TopDownAnalysisMode.TopLevelDeclarations, files2, null, null, 12, null);
                $this$get$iv = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)$this$get$iv, (String)"trace.bindingContext");
                analysisResult4 = AnalysisResult.Companion.success((BindingContext)$this$get$iv, moduleContext.getModule());
            } else {
                analysisResult4 = analysisResult3;
            }
            result2 = analysisResult4;
            $this$firstNotNullResult$iv = analysisHandlerExtensions;
            $i$f$firstNotNullResult = false;
            Iterator iterator3 = $this$firstNotNullResult$iv.iterator();
            while (iterator3.hasNext()) {
                element$iv = iterator3.next();
                AnalysisHandlerExtension extension = (AnalysisHandlerExtension)element$iv;
                boolean bl = false;
                AnalysisResult result$iv = extension.analysisCompleted(project, moduleContext.getModule(), trace, files2);
                if (result$iv == null) continue;
                analysisResult2 = result$iv;
                break block9;
            }
            analysisResult2 = null;
        }
        analysisResult3 = analysisResult2;
        analysisResult3 = result2 = analysisResult3 == null ? result2 : analysisResult3;
        if (analysisResult3 instanceof JsAnalysisResult) {
            jsAnalysisResult = (JsAnalysisResult)result2;
        } else {
            DelegatingBindingTrace bindingTrace = new DelegatingBindingTrace(result2.getBindingContext(), "DelegatingBindingTrace by AnalysisHandlerExtension", false, null, false, null, 60, null);
            AnalysisResult analysisResult6 = result2;
            jsAnalysisResult = analysisResult6 instanceof AnalysisResult.RetryWithAdditionalRoots ? (JsAnalysisResult)new JsAnalysisResult.RetryWithAdditionalRoots((BindingTrace)bindingTrace, result2.getModuleDescriptor(), ((AnalysisResult.RetryWithAdditionalRoots)result2).getAdditionalKotlinRoots()) : JsAnalysisResult.Companion.success(bindingTrace, result2.getModuleDescriptor(), result2.getShouldGenerateCode());
        }
        return jsAnalysisResult;
    }

    public static /* synthetic */ JsAnalysisResult analyzeFilesWithGivenTrace$default(AbstractTopDownAnalyzerFacadeForJS abstractTopDownAnalyzerFacadeForJS, Collection collection, BindingTrace bindingTrace, ModuleContext moduleContext, CompilerConfiguration compilerConfiguration, TargetEnvironment targetEnvironment, Project project, List list2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: analyzeFilesWithGivenTrace");
        }
        if ((n & 0x40) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return abstractTopDownAnalyzerFacadeForJS.analyzeFilesWithGivenTrace(collection, bindingTrace, moduleContext, compilerConfiguration, targetEnvironment, project, list2);
    }

    public final boolean checkForErrors(@NotNull Collection<? extends KtFile> allFiles, @NotNull BindingContext bindingContext, @NotNull ErrorTolerancePolicy errorPolicy) {
        Intrinsics.checkNotNullParameter(allFiles, (String)"allFiles");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)((Object)errorPolicy), (String)"errorPolicy");
        boolean hasErrors = false;
        try {
            AnalyzingUtils.INSTANCE.throwExceptionOnErrors(bindingContext);
        }
        catch (Exception ex) {
            if (!errorPolicy.getAllowSemanticErrors()) {
                throw ex;
            }
            hasErrors = true;
        }
        try {
            for (KtFile ktFile : allFiles) {
                AnalyzingUtils.checkForSyntacticErrors(ktFile);
            }
        }
        catch (Exception ex) {
            if (!errorPolicy.getAllowSyntaxErrors()) {
                throw ex;
            }
            hasErrors = true;
        }
        return hasErrors;
    }
}

