/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.gradle.internal.tasks.TaskWithLocalState;
import org.jetbrains.kotlin.gradle.report.TaskExecutionResult;
import org.jetbrains.kotlin.gradle.report.data.TaskExecutionData;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001c2\b\u0010(\u001a\u0004\u0018\u00010)R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0013\u001a\u00020\u00148VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0013\u0010\u0015R\u000e\u0010\u0018\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\r\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/gradle/report/TaskRecord;", "Lorg/jetbrains/kotlin/gradle/report/data/TaskExecutionData;", "task", "Lorg/gradle/api/Task;", "startNs", "", "(Lorg/gradle/api/Task;J)V", "buildMetrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "getBuildMetrics", "()Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "endNs", "getEndNs", "()J", "icLogLines", "", "", "getIcLogLines", "()Ljava/util/List;", "isKotlinTask", "", "()Z", "isKotlinTask$delegate", "Lkotlin/Lazy;", "myBuildMetrics", "myEndNs", "myIcLogLines", "myTaskState", "Lorg/gradle/api/tasks/TaskState;", "resultState", "getResultState", "()Lorg/gradle/api/tasks/TaskState;", "getStartNs", "getTask", "()Lorg/gradle/api/Task;", "totalTimeNs", "getTotalTimeNs", "processResult", "", "state", "executionResult", "Lorg/jetbrains/kotlin/gradle/report/TaskExecutionResult;", "kotlin-gradle-plugin"})
final class TaskRecord
implements TaskExecutionData {
    @NotNull
    private final Task task;
    private final long startNs;
    private long myEndNs;
    private TaskState myTaskState;
    @NotNull
    private List<String> myIcLogLines;
    @NotNull
    private final BuildMetrics myBuildMetrics;
    @NotNull
    private final Lazy isKotlinTask$delegate;

    public TaskRecord(@NotNull Task task, long startNs) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        this.task = task;
        this.startNs = startNs;
        this.myIcLogLines = CollectionsKt.emptyList();
        this.myBuildMetrics = new BuildMetrics(null, null, 3, null);
        this.isKotlinTask$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ TaskRecord this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final boolean invoke() {
                String string = this.this$0.getTask().getClass().getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"task.javaClass.name");
                return StringsKt.startsWith$default((String)string, (String)"org.jetbrains.kotlin", (boolean)false, (int)2, null);
            }
        }));
    }

    @Override
    @NotNull
    public Task getTask() {
        return this.task;
    }

    @Override
    public long getStartNs() {
        return this.startNs;
    }

    @Override
    public boolean isKotlinTask() {
        Lazy lazy = this.isKotlinTask$delegate;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    @Override
    public long getEndNs() {
        return this.myEndNs;
    }

    @Override
    public long getTotalTimeNs() {
        return this.getEndNs() - this.getStartNs();
    }

    @Override
    @NotNull
    public TaskState getResultState() {
        TaskState taskState = this.myTaskState;
        if (taskState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTaskState");
            throw null;
        }
        return taskState;
    }

    @Override
    @NotNull
    public List<String> getIcLogLines() {
        return this.myIcLogLines;
    }

    @Override
    @NotNull
    public BuildMetrics getBuildMetrics() {
        return this.myBuildMetrics;
    }

    public final void processResult(@NotNull TaskState state, @Nullable TaskExecutionResult executionResult) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        this.myEndNs = System.nanoTime();
        this.myTaskState = state;
        this.myBuildMetrics.getBuildTimes().add(BuildTime.GRADLE_TASK, this.getTotalTimeNs());
        if (executionResult != null) {
            this.myBuildMetrics.addAll(executionResult.getBuildMetrics());
            this.myIcLogLines = executionResult.getIcLogLines();
        }
        if (this.getTask() instanceof TaskWithLocalState) {
            this.myBuildMetrics.addAll(((TaskWithLocalState)this.getTask()).getMetrics().getMetrics());
        }
    }
}

