/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.compilerRunner.KotlinNativeCInteropRunner;
import org.jetbrains.kotlin.compilerRunner.NativeToolRunnersKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.DefaultCInteropSettings;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTargetPresetKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.KotlinCompilationData;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.KotlinCompilationDataKt;
import org.jetbrains.kotlin.gradle.tasks.KotlinNativeTasksKt;
import org.jetbrains.kotlin.gradle.utils.KlibUtilsKt;
import org.jetbrains.kotlin.konan.target.CompilerOutputKind;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@CacheableTask
@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010;\u001a\u00020<H\u0007R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068G\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f8G\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00168\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f8G\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0011R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068G\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\tR\u0011\u0010\u001f\u001a\u00020 8G\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b$\u0010\rR\u0011\u0010%\u001a\u00020&8G\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b*\u0010\rR\u0011\u0010+\u001a\u00020 8G\u00a2\u0006\u0006\u001a\u0004\b,\u0010\"R\u0017\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f8G\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0011R\u0011\u0010/\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b0\u0010\rR\u0011\u00101\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0014R\u0011\u00103\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b4\u0010\rR\u001c\u00105\u001a\b\u0012\u0004\u0012\u00020\u00070\u00168\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u0018R\u0013\u00107\u001a\u0004\u0018\u00010\u000b8G\u00a2\u0006\u0006\u001a\u0004\b8\u0010\rR\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/CInteropProcess;", "Lorg/gradle/api/DefaultTask;", "settings", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/DefaultCInteropSettings;", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/DefaultCInteropSettings;)V", "allHeadersDirs", "", "Ljava/io/File;", "getAllHeadersDirs", "()Ljava/util/Set;", "baseKlibName", "", "getBaseKlibName", "()Ljava/lang/String;", "compilerOpts", "", "getCompilerOpts", "()Ljava/util/List;", "defFile", "getDefFile", "()Ljava/io/File;", "destinationDir", "Lorg/gradle/api/provider/Provider;", "getDestinationDir", "()Lorg/gradle/api/provider/Provider;", "setDestinationDir", "(Lorg/gradle/api/provider/Provider;)V", "extraOpts", "getExtraOpts", "headerFilterDirs", "getHeaderFilterDirs", "headers", "Lorg/gradle/api/file/FileCollection;", "getHeaders", "()Lorg/gradle/api/file/FileCollection;", "interopName", "getInteropName", "konanTarget", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "getKonanTarget", "()Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "kotlinNativeVersion", "getKotlinNativeVersion", "libraries", "getLibraries", "linkerOpts", "getLinkerOpts", "moduleName", "getModuleName", "outputFile", "getOutputFile", "outputFileName", "getOutputFileName", "outputFileProvider", "getOutputFileProvider", "packageName", "getPackageName", "getSettings", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/DefaultCInteropSettings;", "processInterop", "", "kotlin-gradle-plugin"})
public class CInteropProcess
extends DefaultTask {
    @NotNull
    private final DefaultCInteropSettings settings;
    @Internal
    public Provider<File> destinationDir;
    @OutputFile
    @NotNull
    private final Provider<File> outputFileProvider;

    @Inject
    public CInteropProcess(@NotNull DefaultCInteropSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        this.settings = settings;
        Provider provider = this.getProject().provider((Callable)new Callable<File>(this){
            final /* synthetic */ CInteropProcess this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final File call() {
                Object object = this.this$0.getDestinationDir().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"destinationDir.get()");
                return FilesKt.resolve((File)((File)object), (String)this.this$0.getOutputFileName());
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)provider, (String)"project.provider { destinationDir.get().resolve(outputFileName) }");
        this.outputFileProvider = provider;
    }

    @Internal
    @NotNull
    public final DefaultCInteropSettings getSettings() {
        return this.settings;
    }

    @NotNull
    public final Provider<File> getDestinationDir() {
        Provider<File> provider = this.destinationDir;
        if (provider != null) {
            return provider;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"destinationDir");
        throw null;
    }

    public final void setDestinationDir(@NotNull Provider<File> provider) {
        Intrinsics.checkParameterIsNotNull(provider, (String)"<set-?>");
        this.destinationDir = provider;
    }

    @Input
    @NotNull
    public final KonanTarget getKonanTarget() {
        return this.settings.getCompilation().getKonanTarget();
    }

    @Input
    @NotNull
    public final String getInteropName() {
        return this.settings.getName();
    }

    @Input
    @NotNull
    public final String getBaseKlibName() {
        KotlinCompilationData kotlinCompilationData = this.settings.getCompilation();
        boolean bl = false;
        boolean bl2 = false;
        KotlinCompilationData it = kotlinCompilationData;
        boolean bl3 = false;
        String compilationPrefix = KotlinCompilationDataKt.isMainCompilationData(it) ? this.getProject().getName() : it.getCompilationPurpose();
        return compilationPrefix + "-cinterop-" + this.getInteropName();
    }

    @Internal
    @NotNull
    public final String getOutputFileName() {
        CompilerOutputKind compilerOutputKind = CompilerOutputKind.LIBRARY;
        boolean bl = false;
        boolean bl2 = false;
        CompilerOutputKind $this$_get_outputFileName__u24lambda_u2d1 = compilerOutputKind;
        boolean bl3 = false;
        return Intrinsics.stringPlus((String)this.getBaseKlibName(), (Object)$this$_get_outputFileName__u24lambda_u2d1.suffix(this.getKonanTarget()));
    }

    @Input
    @NotNull
    public final String getModuleName() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        return KlibUtilsKt.klibModuleName(project, this.getBaseKlibName());
    }

    @Internal
    @NotNull
    public final File getOutputFile() {
        Object object = this.outputFileProvider.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"outputFileProvider.get()");
        return (File)object;
    }

    @NotNull
    public final Provider<File> getOutputFileProvider() {
        return this.outputFileProvider;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final File getDefFile() {
        Object object = this.settings.getDefFileProperty().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"settings.defFileProperty.get()");
        return (File)object;
    }

    @Optional
    @Input
    @Nullable
    public final String getPackageName() {
        return this.settings.getPackageName();
    }

    @Input
    @NotNull
    public final List<String> getCompilerOpts() {
        return this.settings.getCompilerOpts();
    }

    @Input
    @NotNull
    public final List<String> getLinkerOpts() {
        return this.settings.getLinkerOpts();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final FileCollection getHeaders() {
        return this.settings.getHeaders();
    }

    @Input
    @NotNull
    public final Set<File> getAllHeadersDirs() {
        Set set2 = this.settings.getIncludeDirs().getAllHeadersDirs().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"settings.includeDirs.allHeadersDirs.files");
        return set2;
    }

    @Input
    @NotNull
    public final Set<File> getHeaderFilterDirs() {
        Set set2 = this.settings.getIncludeDirs().getHeaderFilterDirs().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"settings.includeDirs.headerFilterDirs.files");
        return set2;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final FileCollection getLibraries() {
        FileCollection fileCollection2 = this.settings.getDependencyFiles();
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        return KotlinNativeTasksKt.access$filterOutPublishableInteropLibs(fileCollection2, project);
    }

    @Input
    @NotNull
    public final List<String> getExtraOpts() {
        return this.settings.getExtraOpts();
    }

    @Input
    @NotNull
    public final String getKotlinNativeVersion() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        return NativeToolRunnersKt.getKonanVersion(project).toString();
    }

    @TaskAction
    public final void processInterop() {
        String string;
        File it;
        Collection<String> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        String it2;
        boolean bl = false;
        List list2 = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $this$processInterop_u24lambda_u2d7 = list2;
        boolean bl4 = false;
        String string2 = this.getOutputFile().getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"outputFile.absolutePath");
        KotlinNativeTasksKt.addArg($this$processInterop_u24lambda_u2d7, "-o", string2);
        KotlinNativeTasksKt.addArgIfNotNull($this$processInterop_u24lambda_u2d7, "-target", this.getKonanTarget().getVisibleName());
        KotlinNativeTasksKt.addArgIfNotNull($this$processInterop_u24lambda_u2d7, "-def", this.getDefFile().getCanonicalPath());
        KotlinNativeTasksKt.addArgIfNotNull($this$processInterop_u24lambda_u2d7, "-pkg", this.getPackageName());
        KotlinNativeTasksKt.addFileArgs((List<String>)$this$processInterop_u24lambda_u2d7, "-header", this.getHeaders());
        Iterable $this$forEach$iv = this.getCompilerOpts();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (String)element$iv;
            boolean bl5 = false;
            KotlinNativeTasksKt.addArg($this$processInterop_u24lambda_u2d7, "-compiler-option", it2);
        }
        $this$forEach$iv = this.getLinkerOpts();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (String)element$iv;
            boolean bl6 = false;
            KotlinNativeTasksKt.addArg($this$processInterop_u24lambda_u2d7, "-linker-option", it2);
        }
        $this$forEach$iv = this.getLibraries().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)$this$forEach$iv, (String)"libraries.files");
        $this$forEach$iv = KotlinNativeTasksKt.access$filterKlibsPassedToCompiler((Collection)$this$forEach$iv);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File library2 = (File)element$iv;
            boolean bl7 = false;
            String string3 = library2.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"library.absolutePath");
            KotlinNativeTasksKt.addArg($this$processInterop_u24lambda_u2d7, "-library", string3);
        }
        $this$forEach$iv = this.getAllHeadersDirs();
        String string4 = "-compiler-option";
        List list3 = $this$processInterop_u24lambda_u2d7;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl8 = false;
            string = Intrinsics.stringPlus((String)"-I", (Object)it.getAbsolutePath());
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        KotlinNativeTasksKt.addArgs(list3, string4, (Iterable<String>)collection);
        $this$map$iv = this.getHeaderFilterDirs();
        string4 = "-headerFilterAdditionalSearchPrefix";
        list3 = $this$processInterop_u24lambda_u2d7;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl9 = false;
            string = it.getAbsolutePath();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        KotlinNativeTasksKt.addArgs(list3, string4, (Iterable<String>)collection);
        string2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"project");
        if (KotlinNativeTargetPresetKt.isAtLeast(NativeToolRunnersKt.getKonanVersion((Project)string2), 1, 4, 0)) {
            KotlinNativeTasksKt.addArg($this$processInterop_u24lambda_u2d7, "-Xmodule-name", this.getModuleName());
        }
        $this$processInterop_u24lambda_u2d7.addAll((Collection)this.getExtraOpts());
        List args = list2;
        this.getOutputFile().getParentFile().mkdirs();
        list2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"project");
        new KotlinNativeCInteropRunner((Project)list2).run(args);
    }
}

