/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u0003J\u0010\u0010\u0019\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u0003J\u0010\u0010\u001a\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u0003J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u001c\u001a\u00020\u0003R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lorg/openrewrite/gradle/GradleSourceSetSpec;", "", "name", "", "(Ljava/lang/String;)V", "groovyClassses", "", "getGroovyClassses", "()Ljava/util/List;", "javaSources", "getJavaSources", "kotlinSources", "getKotlinSources", "getName", "()Ljava/lang/String;", "propertiesFiles", "", "getPropertiesFiles", "()Ljava/util/Map;", "build", "dir", "Ljava/io/File;", "groovyClass", "", "source", "java", "kotlin", "propertiesFile", "text", "plugin"})
public final class GradleSourceSetSpec {
    @NotNull
    private final String name;
    @NotNull
    private final List<String> javaSources;
    @NotNull
    private final List<String> kotlinSources;
    @NotNull
    private final Map<String, String> propertiesFiles;
    @NotNull
    private final List<String> groovyClassses;

    public GradleSourceSetSpec(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.javaSources = new ArrayList();
        this.kotlinSources = new ArrayList();
        this.propertiesFiles = new LinkedHashMap();
        this.groovyClassses = new ArrayList();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<String> getJavaSources() {
        return this.javaSources;
    }

    public final void java(@Language(value="java") @NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.javaSources.add(StringsKt.trimIndent((String)source));
    }

    @NotNull
    public final List<String> getKotlinSources() {
        return this.kotlinSources;
    }

    public final void kotlin(@Language(value="kotlin") @NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.kotlinSources.add(StringsKt.trimIndent((String)source));
    }

    @NotNull
    public final Map<String, String> getPropertiesFiles() {
        return this.propertiesFiles;
    }

    public final void propertiesFile(@NotNull String name, @Language(value="properties") @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.propertiesFiles.put(name, text);
    }

    @NotNull
    public final List<String> getGroovyClassses() {
        return this.groovyClassses;
    }

    public final void groovyClass(@Language(value="groovy") @NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.groovyClassses.add(StringsKt.trimIndent((String)source));
    }

    @NotNull
    public final GradleSourceSetSpec build(@NotNull File dir) {
        boolean bl;
        File file;
        String path;
        String clazz;
        String peckage;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        dir.mkdirs();
        for (String string : this.javaSources) {
            String string2;
            if (StringsKt.startsWith$default((String)string, (String)"package", (boolean)false, (int)2, null)) {
                MatchResult matchResult = Regex.find$default((Regex)new Regex("package\\s+([a-zA-Z0-9.]+);", RegexOption.MULTILINE), (CharSequence)string, (int)0, (int)2, null);
                Intrinsics.checkNotNull((Object)matchResult);
                string2 = (String)matchResult.getGroupValues().get(1);
            } else {
                string2 = "";
            }
            peckage = StringsKt.replace$default((String)string2, (String)".", (String)"/", (boolean)false, (int)4, null);
            MatchResult matchResult = Regex.find$default((Regex)new Regex(".*(class|interface|enum)\\s+([a-zA-Z0-9-_]+)", RegexOption.MULTILINE), (CharSequence)string, (int)0, (int)2, null);
            Intrinsics.checkNotNull((Object)matchResult);
            clazz = (String)matchResult.getGroupValues().get(2);
            path = ((CharSequence)peckage).length() == 0 ? this.name + "/java/" + clazz + ".java" : this.name + "/java/" + peckage + '/' + clazz + ".java";
            File $this$build_u24lambda_u240 = file = new File(dir, path);
            bl = false;
            $this$build_u24lambda_u240.getParentFile().mkdirs();
            FilesKt.writeText$default((File)$this$build_u24lambda_u240, (String)string, null, (int)2, null);
        }
        for (String string : this.kotlinSources) {
            String string3;
            if (StringsKt.startsWith$default((String)string, (String)"package", (boolean)false, (int)2, null)) {
                MatchResult matchResult = Regex.find$default((Regex)new Regex("package\\s+([a-zA-Z0-9.]+)", RegexOption.MULTILINE), (CharSequence)string, (int)0, (int)2, null);
                Intrinsics.checkNotNull((Object)matchResult);
                string3 = (String)matchResult.getGroupValues().get(1);
            } else {
                string3 = "";
            }
            peckage = StringsKt.replace$default((String)string3, (String)".", (String)"/", (boolean)false, (int)4, null);
            MatchResult matchResult = Regex.find$default((Regex)new Regex(".*(class|interface|enum)\\s+([a-zA-Z0-9-_]+)", RegexOption.MULTILINE), (CharSequence)string, (int)0, (int)2, null);
            Intrinsics.checkNotNull((Object)matchResult);
            clazz = (String)matchResult.getGroupValues().get(2);
            path = ((CharSequence)peckage).length() == 0 ? this.name + "/kotlin/" + clazz + ".kt" : this.name + "/kotlin/" + peckage + '/' + clazz + ".kt";
            File $this$build_u24lambda_u241 = file = new File(dir, path);
            bl = false;
            $this$build_u24lambda_u241.getParentFile().mkdirs();
            FilesKt.writeText$default((File)$this$build_u24lambda_u241, (String)string, null, (int)2, null);
        }
        for (String string : this.groovyClassses) {
            String string4;
            if (StringsKt.startsWith$default((String)string, (String)"package", (boolean)false, (int)2, null)) {
                MatchResult matchResult = Regex.find$default((Regex)new Regex("package\\s+([a-zA-Z0-9.]+);?", RegexOption.MULTILINE), (CharSequence)string, (int)0, (int)2, null);
                Intrinsics.checkNotNull((Object)matchResult);
                string4 = (String)matchResult.getGroupValues().get(1);
            } else {
                string4 = "";
            }
            peckage = StringsKt.replace$default((String)string4, (String)".", (String)"/", (boolean)false, (int)4, null);
            MatchResult matchResult = Regex.find$default((Regex)new Regex(".*(class|interface|enum)\\s+([a-zA-Z0-9-_]+)", RegexOption.MULTILINE), (CharSequence)string, (int)0, (int)2, null);
            Intrinsics.checkNotNull((Object)matchResult);
            clazz = (String)matchResult.getGroupValues().get(2);
            path = ((CharSequence)peckage).length() == 0 ? this.name + "/groovy/" + clazz + ".groovy" : this.name + "/groovy/" + peckage + '/' + clazz + ".groovy";
            File $this$build_u24lambda_u242 = file = new File(dir, path);
            bl = false;
            $this$build_u24lambda_u242.getParentFile().mkdirs();
            FilesKt.writeText$default((File)$this$build_u24lambda_u242, (String)string, null, (int)2, null);
        }
        if (!this.propertiesFiles.isEmpty()) {
            for (Map.Entry entry : this.propertiesFiles.entrySet()) {
                File file2;
                File $this$build_u24lambda_u243 = file2 = new File(dir, this.name + "/resources/" + (String)entry.getKey());
                boolean bl2 = false;
                $this$build_u24lambda_u243.getParentFile().mkdirs();
                FilesKt.writeText$default((File)$this$build_u24lambda_u243, (String)((String)entry.getValue()), null, (int)2, null);
            }
        }
        return this;
    }
}

