/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class RewriteClassLoader
extends URLClassLoader {
    private static final List<String> PARENT_LOADED_PACKAGES = Arrays.asList("org.openrewrite.gradle.GradleProjectParser", "org.openrewrite.gradle.DefaultRewriteExtension", "org.openrewrite.gradle.RewriteExtension", "org.slf4j", "org.gradle", "groovy", "org.codehaus.groovy");
    private static final List<String> PLUGIN_LOADED_PACKAGES = Arrays.asList("com.android");
    private final ClassLoader pluginClassLoader;

    public RewriteClassLoader(Collection<URL> artifacts) {
        this(artifacts, RewriteClassLoader.class.getClassLoader());
    }

    public RewriteClassLoader(Collection<URL> artifacts, ClassLoader pluginClassLoader) {
        super(artifacts.toArray(new URL[0]), RewriteClassLoader.class.getClassLoader());
        this.pluginClassLoader = pluginClassLoader;
        this.setDefaultAssertionStatus(true);
    }

    public ClassLoader getPluginClassLoader() {
        return this.pluginClassLoader;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> foundClass = this.findLoadedClass(name);
        if (foundClass == null) {
            try {
                foundClass = this.shouldBeParentLoaded(name) ? super.loadClass(name, resolve) : (this.shouldBePluginLoaded(name) ? Class.forName(name, resolve, this.pluginClassLoader) : this.findClass(name));
            }
            catch (ClassNotFoundException e) {
                foundClass = super.loadClass(name, resolve);
            }
        }
        if (resolve) {
            this.resolveClass(foundClass);
        }
        return foundClass;
    }

    protected boolean shouldBeParentLoaded(String name) {
        return this.shouldBeLoaded(name, PARENT_LOADED_PACKAGES);
    }

    protected boolean shouldBePluginLoaded(String name) {
        return this.shouldBeLoaded(name, PLUGIN_LOADED_PACKAGES);
    }

    private boolean shouldBeLoaded(String name, List<String> packagesToLoad) {
        for (String pkg : packagesToLoad) {
            if (!name.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }
}

