/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.isolated;

import com.android.build.gradle.BaseExtension;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import org.gradle.api.JavaVersion;

class AndroidProjectCompileOptions {
    private final Charset encoding;
    private final String sourceCompatibility;
    private final String targetCompatibility;

    AndroidProjectCompileOptions(Charset encoding, String sourceCompatibility, String targetCompatibility) {
        this.encoding = encoding;
        this.sourceCompatibility = sourceCompatibility;
        this.targetCompatibility = targetCompatibility;
    }

    static AndroidProjectCompileOptions fromBaseExtension(BaseExtension baseExtension) throws ReflectiveOperationException {
        Object compileOptions = AndroidProjectCompileOptions.callMethod(baseExtension, "getCompileOptions");
        String fileEncoding = (String)AndroidProjectCompileOptions.callMethod(compileOptions, "getEncoding");
        JavaVersion sourceCompatibilityVersion = (JavaVersion)AndroidProjectCompileOptions.callMethod(compileOptions, "getSourceCompatibility");
        JavaVersion targetCompatibilityVersion = (JavaVersion)AndroidProjectCompileOptions.callMethod(compileOptions, "getTargetCompatibility");
        return new AndroidProjectCompileOptions(Charset.forName(fileEncoding), sourceCompatibilityVersion.toString(), targetCompatibilityVersion.toString());
    }

    private static <T> T callMethod(Object obj, String methodName) throws ReflectiveOperationException {
        Method method = obj.getClass().getMethod(methodName, new Class[0]);
        return (T)method.invoke(obj, new Object[0]);
    }

    Charset getEncoding() {
        return this.encoding;
    }

    String getSourceCompatibility() {
        return this.sourceCompatibility;
    }

    String getTargetCompatibility() {
        return this.targetCompatibility;
    }
}

