/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.api;

import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.api.HS2ClientWrapper;
import com.cloudera.impala.jdbc.oauth.OAuthFactory;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCancelDelegationTokenReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCancelDelegationTokenResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCancelOperationReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseOperationReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseOperationResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseSessionReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseSessionResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TExecuteStatementReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TExecuteStatementResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TFetchResultsReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TFetchResultsResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetCatalogsReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetCatalogsResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetColumnsReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetColumnsResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetDelegationTokenReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetDelegationTokenResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetFunctionsReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetFunctionsResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetInfoReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetInfoResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetOperationStatusReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetOperationStatusResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetResultSetMetadataReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetResultSetMetadataResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetSchemasReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetSchemasResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTableTypesReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTableTypesResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTablesReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTablesResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTypeInfoReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTypeInfoResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TOpenSessionReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TOpenSessionResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TRenewDelegationTokenReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TRenewDelegationTokenResp;
import com.cloudera.impala.jdbc42.internal.apache.thrift.TException;
import com.cloudera.impala.jdbc42.internal.apache.thrift.protocol.TProtocol;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.THttpClient;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ErrorException;

public class HS2OAuthClientWrapper
extends HS2ClientWrapper {
    private static final String HTTP_BAD_REQUEST_ERROR = "HTTP Response code: 400";
    public static final String AUTHORIZATION_KEY = "Authorization";
    public static final String TOKEN_TYPE_BEARER = "Bearer ";
    private ILogger m_logger;
    private HiveJDBCSettings m_settings;
    private String m_accessToken;

    public HS2OAuthClientWrapper(TProtocol tProtocol, ILogger iLogger, HiveJDBCSettings hiveJDBCSettings) {
        super(tProtocol, iLogger);
        LogUtilities.logFunctionEntrance(iLogger, tProtocol, iLogger, hiveJDBCSettings);
        this.m_logger = iLogger;
        this.m_settings = hiveJDBCSettings;
    }

    @Override
    public TCancelDelegationTokenResp CancelDelegationToken(TCancelDelegationTokenReq tCancelDelegationTokenReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tCancelDelegationTokenReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.CancelDelegationToken(tCancelDelegationTokenReq);
            }
            catch (Exception exception) {
                if (this.shouldCallWithNewToken(exception)) {
                    return super.CancelDelegationToken(tCancelDelegationTokenReq);
                }
                throw (TException)exception;
            }
        }
    }

    @Override
    public TCloseOperationResp CloseOperation(TCloseOperationReq tCloseOperationReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tCloseOperationReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.CloseOperation(tCloseOperationReq);
            }
            catch (Exception exception) {
                if (this.shouldCallWithNewToken(exception)) {
                    return super.CloseOperation(tCloseOperationReq);
                }
                throw (TException)exception;
            }
        }
    }

    @Override
    public TCloseSessionResp CloseSession(TCloseSessionReq tCloseSessionReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tCloseSessionReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.CloseSession(tCloseSessionReq);
            }
            catch (Exception exception) {
                if (this.shouldCallWithNewToken(exception)) {
                    return super.CloseSession(tCloseSessionReq);
                }
                throw (TException)exception;
            }
        }
    }

    @Override
    public TExecuteStatementResp ExecuteStatement(TExecuteStatementReq tExecuteStatementReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tExecuteStatementReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.ExecuteStatement(tExecuteStatementReq);
            }
            catch (Exception exception) {
                if (this.shouldCallWithNewToken(exception)) {
                    return super.ExecuteStatement(tExecuteStatementReq);
                }
                throw (TException)exception;
            }
        }
    }

    @Override
    public TFetchResultsResp FetchResults(TFetchResultsReq tFetchResultsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tFetchResultsReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.FetchResults(tFetchResultsReq);
            }
            catch (Exception exception) {
                if (this.shouldCallWithNewToken(exception)) {
                    return super.FetchResults(tFetchResultsReq);
                }
                throw (TException)exception;
            }
        }
    }

    @Override
    public TGetCatalogsResp GetCatalogs(TGetCatalogsReq tGetCatalogsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetCatalogsReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.GetCatalogs(tGetCatalogsReq);
            }
            catch (Exception exception) {
                if (this.shouldCallWithNewToken(exception)) {
                    return super.GetCatalogs(tGetCatalogsReq);
                }
                throw (TException)exception;
            }
        }
    }

    @Override
    public TGetColumnsResp GetColumns(TGetColumnsReq tGetColumnsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetColumnsReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.GetColumns(tGetColumnsReq);
            }
            catch (Exception exception) {
                if (this.shouldCallWithNewToken(exception)) {
                    return super.GetColumns(tGetColumnsReq);
                }
                throw (TException)exception;
            }
        }
    }

    @Override
    public TGetDelegationTokenResp GetDelegationToken(TGetDelegationTokenReq tGetDelegationTokenReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetDelegationTokenReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.GetDelegationToken(tGetDelegationTokenReq);
            }
            catch (Exception exception) {
                if (this.shouldCallWithNewToken(exception)) {
                    return super.GetDelegationToken(tGetDelegationTokenReq);
                }
                throw (TException)exception;
            }
        }
    }

    @Override
    public TGetFunctionsResp GetFunctions(TGetFunctionsReq tGetFunctionsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetFunctionsReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.GetFunctions(tGetFunctionsReq);
            }
            catch (Exception exception) {
                if (this.shouldCallWithNewToken(exception)) {
                    return super.GetFunctions(tGetFunctionsReq);
                }
                throw (TException)exception;
            }
        }
    }

    @Override
    public TGetInfoResp GetInfo(TGetInfoReq tGetInfoReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetInfoReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.GetInfo(tGetInfoReq);
            }
            catch (Exception exception) {
                if (this.shouldCallWithNewToken(exception)) {
                    return super.GetInfo(tGetInfoReq);
                }
                throw (TException)exception;
            }
        }
    }

    @Override
    public TGetOperationStatusResp GetOperationStatus(TGetOperationStatusReq tGetOperationStatusReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetOperationStatusReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.GetOperationStatus(tGetOperationStatusReq);
            }
            catch (Exception exception) {
                if (this.shouldCallWithNewToken(exception)) {
                    return super.GetOperationStatus(tGetOperationStatusReq);
                }
                throw (TException)exception;
            }
        }
    }

    @Override
    public TGetResultSetMetadataResp GetResultSetMetadata(TGetResultSetMetadataReq tGetResultSetMetadataReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetResultSetMetadataReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.GetResultSetMetadata(tGetResultSetMetadataReq);
            }
            catch (Exception exception) {
                if (this.shouldCallWithNewToken(exception)) {
                    return super.GetResultSetMetadata(tGetResultSetMetadataReq);
                }
                throw (TException)exception;
            }
        }
    }

    @Override
    public TGetSchemasResp GetSchemas(TGetSchemasReq tGetSchemasReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetSchemasReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.GetSchemas(tGetSchemasReq);
            }
            catch (Exception exception) {
                if (this.shouldCallWithNewToken(exception)) {
                    return super.GetSchemas(tGetSchemasReq);
                }
                throw (TException)exception;
            }
        }
    }

    @Override
    public TGetTableTypesResp GetTableTypes(TGetTableTypesReq tGetTableTypesReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetTableTypesReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.GetTableTypes(tGetTableTypesReq);
            }
            catch (Exception exception) {
                if (this.shouldCallWithNewToken(exception)) {
                    return super.GetTableTypes(tGetTableTypesReq);
                }
                throw (TException)exception;
            }
        }
    }

    @Override
    public TGetTablesResp GetTables(TGetTablesReq tGetTablesReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetTablesReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.GetTables(tGetTablesReq);
            }
            catch (Exception exception) {
                if (this.shouldCallWithNewToken(exception)) {
                    return super.GetTables(tGetTablesReq);
                }
                throw (TException)exception;
            }
        }
    }

    @Override
    public TGetTypeInfoResp GetTypeInfo(TGetTypeInfoReq tGetTypeInfoReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetTypeInfoReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.GetTypeInfo(tGetTypeInfoReq);
            }
            catch (Exception exception) {
                if (this.shouldCallWithNewToken(exception)) {
                    return super.GetTypeInfo(tGetTypeInfoReq);
                }
                throw (TException)exception;
            }
        }
    }

    @Override
    public TOpenSessionResp OpenSession(TOpenSessionReq tOpenSessionReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tOpenSessionReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.OpenSession(tOpenSessionReq);
            }
            catch (TException tException) {
                if (this.shouldCallWithNewToken(tException)) {
                    return super.OpenSession(tOpenSessionReq);
                }
                throw tException;
            }
        }
    }

    @Override
    public TRenewDelegationTokenResp RenewDelegationToken(TRenewDelegationTokenReq tRenewDelegationTokenReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tRenewDelegationTokenReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.RenewDelegationToken(tRenewDelegationTokenReq);
            }
            catch (Exception exception) {
                if (this.shouldCallWithNewToken(exception)) {
                    return super.RenewDelegationToken(tRenewDelegationTokenReq);
                }
                throw (TException)exception;
            }
        }
    }

    @Override
    public void send_CancelDelegationToken(TCancelDelegationTokenReq tCancelDelegationTokenReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateAccessToken();
        super.send_CancelDelegationToken(tCancelDelegationTokenReq);
    }

    @Override
    public void send_CancelOperation(TCancelOperationReq tCancelOperationReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateAccessToken();
        super.send_CancelOperation(tCancelOperationReq);
    }

    @Override
    public void send_CloseOperation(TCloseOperationReq tCloseOperationReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateAccessToken();
        super.send_CloseOperation(tCloseOperationReq);
    }

    @Override
    public void send_CloseSession(TCloseSessionReq tCloseSessionReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateAccessToken();
        super.send_CloseSession(tCloseSessionReq);
    }

    @Override
    public void send_ExecuteStatement(TExecuteStatementReq tExecuteStatementReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateAccessToken();
        super.send_ExecuteStatement(tExecuteStatementReq);
    }

    @Override
    public void send_FetchResults(TFetchResultsReq tFetchResultsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateAccessToken();
        super.send_FetchResults(tFetchResultsReq);
    }

    @Override
    public void send_GetCatalogs(TGetCatalogsReq tGetCatalogsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateAccessToken();
        super.send_GetCatalogs(tGetCatalogsReq);
    }

    @Override
    public void send_GetColumns(TGetColumnsReq tGetColumnsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateAccessToken();
        super.send_GetColumns(tGetColumnsReq);
    }

    @Override
    public void send_GetDelegationToken(TGetDelegationTokenReq tGetDelegationTokenReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateAccessToken();
        super.send_GetDelegationToken(tGetDelegationTokenReq);
    }

    @Override
    public void send_GetFunctions(TGetFunctionsReq tGetFunctionsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateAccessToken();
        super.send_GetFunctions(tGetFunctionsReq);
    }

    @Override
    public void send_GetInfo(TGetInfoReq tGetInfoReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateAccessToken();
        super.send_GetInfo(tGetInfoReq);
    }

    @Override
    public void send_GetOperationStatus(TGetOperationStatusReq tGetOperationStatusReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateAccessToken();
        super.send_GetOperationStatus(tGetOperationStatusReq);
    }

    @Override
    public void send_GetResultSetMetadata(TGetResultSetMetadataReq tGetResultSetMetadataReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateAccessToken();
        super.send_GetResultSetMetadata(tGetResultSetMetadataReq);
    }

    @Override
    public void send_GetSchemas(TGetSchemasReq tGetSchemasReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateAccessToken();
        super.send_GetSchemas(tGetSchemasReq);
    }

    @Override
    public void send_GetTableTypes(TGetTableTypesReq tGetTableTypesReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateAccessToken();
        super.send_GetTableTypes(tGetTableTypesReq);
    }

    @Override
    public void send_GetTables(TGetTablesReq tGetTablesReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateAccessToken();
        super.send_GetTables(tGetTablesReq);
    }

    @Override
    public void send_GetTypeInfo(TGetTypeInfoReq tGetTypeInfoReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateAccessToken();
        super.send_GetTypeInfo(tGetTypeInfoReq);
    }

    @Override
    public void send_OpenSession(TOpenSessionReq tOpenSessionReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateAccessToken();
        super.send_OpenSession(tOpenSessionReq);
    }

    @Override
    public void send_RenewDelegationToken(TRenewDelegationTokenReq tRenewDelegationTokenReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateAccessToken();
        super.send_RenewDelegationToken(tRenewDelegationTokenReq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateAccessToken() throws TException {
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            if (null == this.m_accessToken || null != this.m_settings && null != this.m_settings.m_oAuthSettings && System.currentTimeMillis() >= this.m_settings.m_oAuthSettings.m_expiryTime) {
                try {
                    this.m_accessToken = OAuthFactory.clientCredentialOAuth(this.m_settings.m_oAuthSettings, this.m_settings.m_oAuthSettings.m_tokenEndpointSSLSettings, this.m_logger);
                }
                catch (ErrorException errorException) {
                    TException tException = new TException(errorException.getCause());
                    throw tException;
                }
                if (this.getOutputProtocol().getTransport() instanceof THttpClient) {
                    ((THttpClient)this.getOutputProtocol().getTransport()).setCustomHeader(AUTHORIZATION_KEY, TOKEN_TYPE_BEARER + this.m_accessToken);
                }
                return true;
            }
            return false;
        }
    }

    private boolean shouldCallWithNewToken(Exception exception) throws TException {
        if (exception.getMessage().contains(HTTP_BAD_REQUEST_ERROR)) {
            boolean bl = this.validateAccessToken();
            if (bl) {
                LogUtilities.logInfo("Trying again as previous call failed beacuse access token was expired.", this.m_logger);
            }
            return bl;
        }
        return false;
    }
}

