/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.api;

import com.cloudera.impala.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.impala.hivecommon.AuthMech;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.KrbAuthType;
import com.cloudera.impala.hivecommon.ServiceDiscoveryMode;
import com.cloudera.impala.hivecommon.TransportMode;
import com.cloudera.impala.hivecommon.api.DelegationToken;
import com.cloudera.impala.hivecommon.api.HS2Client;
import com.cloudera.impala.hivecommon.api.HiveServerPrivilegedAction;
import com.cloudera.impala.hivecommon.api.IHiveClient;
import com.cloudera.impala.hivecommon.api.IHiveClientFactory;
import com.cloudera.impala.hivecommon.api.SaslCallbackHandler;
import com.cloudera.impala.hivecommon.api.TETSSLTransportFactory;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.hivecommon.utils.kerberos.KerberosHttpInterceptor;
import com.cloudera.impala.jdbc.common.SSLTransportParameters;
import com.cloudera.impala.jdbc.http.extention.ExtendedHttpClient;
import com.cloudera.impala.jdbc.kerberos.Kerberos;
import com.cloudera.impala.jdbc.rpc.CustomDnsResolverLoader;
import com.cloudera.impala.jdbc.rpc.HttpClientFactory;
import com.cloudera.impala.jdbc.utils.rpc.CustomNetworkHooks;
import com.cloudera.impala.jdbc42.internal.apache.commons.codec.binary.Base64;
import com.cloudera.impala.jdbc42.internal.apache.http.conn.DnsResolver;
import com.cloudera.impala.jdbc42.internal.apache.http.impl.client.HttpClientBuilder;
import com.cloudera.impala.jdbc42.internal.apache.thrift.protocol.TBinaryProtocol;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.THttpClient;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TSaslClientTransport;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TSocket;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TTransport;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TTransportException;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.IMessageSource;
import com.cloudera.impala.support.IWarningListener;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Locale;
import javax.net.SocketFactory;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;

public class HiveServer2ClientFactory
implements IHiveClientFactory {
    @Override
    public IHiveClient createClient(HiveJDBCSettings hiveJDBCSettings, ILogger iLogger, IWarningListener iWarningListener) throws ErrorException {
        TTransport tTransport = HiveServer2ClientFactory.createTransport(hiveJDBCSettings, iWarningListener.getMessageSource(), iWarningListener.getLocale(), iLogger);
        return new HS2Client(hiveJDBCSettings, new TBinaryProtocol(tTransport), iLogger, iWarningListener);
    }

    @Override
    public boolean supportServiceDiscoveryMode(ServiceDiscoveryMode serviceDiscoveryMode, ILogger iLogger) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[]{serviceDiscoveryMode, iLogger});
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SERVICE_DISCOVERY_MODE_NOT_SUPPORTED.name(), new String[]{serviceDiscoveryMode.name(), "Platform does not support Service discovery, defaulting to NoServiceDiscovery"});
        errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
        LogUtilities.logWarning(errorException, iLogger);
        return false;
    }

    protected static TTransport createTransport(HiveJDBCSettings hiveJDBCSettings, IMessageSource iMessageSource, Locale locale, ILogger iLogger) throws ErrorException {
        Object object = null;
        TSocket tSocket = null;
        HttpClientBuilder httpClientBuilder = null;
        SocketFactory socketFactory = CustomNetworkHooks.getCustomSocketFactory(hiveJDBCSettings.m_customNetworkHooksSettings, iLogger);
        DnsResolver dnsResolver = CustomDnsResolverLoader.getDnsResolver(hiveJDBCSettings.m_customNetworkHooksSettings, iLogger);
        hiveJDBCSettings.m_customNetworkHooksSettings.m_resolvedHost = CustomDnsResolverLoader.getResolvedHost(dnsResolver, hiveJDBCSettings.m_host, iLogger);
        try {
            Object object2;
            if (TransportMode.HTTP != hiveJDBCSettings.m_transportMode) {
                if (hiveJDBCSettings.m_serverSSLSettings.m_enableSSL) {
                    object2 = HiveServer2ClientFactory.createTETSSLTransportParams(hiveJDBCSettings);
                    tSocket = TETSSLTransportFactory.getClientSocket(hiveJDBCSettings, (SSLTransportParameters)object2, socketFactory, iLogger);
                } else {
                    if (null == socketFactory) {
                        socketFactory = SocketFactory.getDefault();
                    }
                    object2 = socketFactory.createSocket();
                    ((Socket)object2).connect(new InetSocketAddress(hiveJDBCSettings.m_customNetworkHooksSettings.m_resolvedHost, hiveJDBCSettings.m_port));
                    tSocket = new TSocket((Socket)object2);
                    tSocket.setTimeout(hiveJDBCSettings.m_timeout);
                }
            } else {
                if (null == hiveJDBCSettings.m_httpPath || 0 == hiveJDBCSettings.m_httpPath.length()) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_HTTP_PATH_ERR.name());
                    throw errorException;
                }
                if (hiveJDBCSettings.m_serverSSLSettings.m_enableSSL) {
                    object2 = HiveServer2ClientFactory.createTETSSLTransportParams(hiveJDBCSettings);
                    httpClientBuilder = TETSSLTransportFactory.getHttpsClient(hiveJDBCSettings, (SSLTransportParameters)object2, socketFactory, dnsResolver, iLogger);
                } else {
                    httpClientBuilder = HttpClientFactory.createHttpClient(socketFactory, dnsResolver, iLogger);
                }
                httpClientBuilder.setDnsResolver(dnsResolver);
            }
            switch (hiveJDBCSettings.m_authMech) {
                case NOAUTH: {
                    if (hiveJDBCSettings.m_transportMode == TransportMode.HTTP && hiveJDBCSettings.m_platformVersionUtils.supportsHttp(hiveJDBCSettings.m_authMech)) {
                        object2 = new THttpClient(HiveServer2ClientFactory.getFullHttpPath(hiveJDBCSettings), new ExtendedHttpClient(httpClientBuilder.build()));
                        if (null != hiveJDBCSettings.m_username) {
                            HiveServer2ClientFactory.addCredentialsToHeader(hiveJDBCSettings, (THttpClient)object2);
                        }
                        object = object2;
                        break;
                    }
                    object = tSocket;
                    break;
                }
                case DELEGATION_TOKEN: {
                    object2 = null;
                    if (hiveJDBCSettings.m_delegationToken != null) {
                        try {
                            object2 = DelegationToken.decodeToken(hiveJDBCSettings.m_delegationToken);
                        }
                        catch (Exception exception) {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DELEGATION_TOKEN_DECODE_FAILED.name());
                            errorException.initCause(exception);
                            errorException.loadMessage(iMessageSource, locale);
                            ErrorException errorException2 = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DELEGATION_TOKEN_FAILED.name(), errorException.getMessage());
                            errorException2.initCause(errorException);
                            throw errorException2;
                        }
                        try {
                            object = new TSaslClientTransport("DIGEST-MD5", null, null, "default", null, new SaslCallbackHandler((DelegationToken)object2), tSocket);
                            break;
                        }
                        catch (Exception exception) {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DELEGATION_TOKEN_FAILED.name(), exception.getMessage());
                            errorException.initCause(exception);
                            throw errorException;
                        }
                    }
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DELEGATION_TOKEN_FAILED.name(), "Unable to obtain the token from the connection string");
                    throw errorException;
                }
                case SASL_KERBEROS: {
                    if (KrbAuthType.JAAS == hiveJDBCSettings.m_krbAuthType) {
                        try {
                            object2 = Kerberos.getSubjectViaJAASConfig(hiveJDBCSettings.m_krbJaasConfigFile, iLogger);
                        }
                        catch (LoginException loginException) {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_KERBEROS_AUTHENTICATION_ERROR_GET_JAASCONFIGURE.name(), loginException.getMessage());
                            errorException.initCause(loginException);
                            throw errorException;
                        }
                        if (iLogger.isEnabled() && null != object2) {
                            LogUtilities.logDebug("Kerberos subject retrieved via JAAS config", iLogger);
                        }
                    } else if (KrbAuthType.TICKET_CACHE == hiveJDBCSettings.m_krbAuthType) {
                        try {
                            object2 = Kerberos.getSubjectViaTicketCache(iLogger);
                        }
                        catch (LoginException loginException) {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_KERBEROS_AUTHENTICATION_ERROR_GET_TICKETCACHE.name(), loginException.getMessage());
                            errorException.initCause(loginException);
                            throw errorException;
                        }
                        if (iLogger.isEnabled() && null != object2) {
                            LogUtilities.logDebug("Kerberos subject retrieved via ticket cache lookup", iLogger);
                        }
                    } else {
                        object2 = Kerberos.getSubjectViaAccessControlContext(iLogger);
                        if (iLogger.isEnabled() && null != object2) {
                            LogUtilities.logDebug("Kerberos subject retrieved via AccessControlContext", iLogger);
                        }
                        if (null == object2) {
                            boolean bl = false;
                            try {
                                object2 = Kerberos.getSubjectViaJAASConfig(hiveJDBCSettings.m_krbJaasConfigFile, iLogger);
                            }
                            catch (LoginException loginException) {
                                LogUtilities.logWarning(loginException, iLogger);
                                bl = true;
                            }
                            if (iLogger.isEnabled() && null != object2) {
                                LogUtilities.logDebug("Kerberos subject retrieved via JAAS config", iLogger);
                            }
                            if (null == object2 || bl) {
                                try {
                                    object2 = Kerberos.getSubjectViaTicketCache(iLogger);
                                }
                                catch (LoginException loginException) {
                                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_KERBEROS_AUTHENTICATION_ERROR_GET_TICKETCACHE.name(), loginException.getMessage());
                                    errorException.initCause(loginException);
                                    throw errorException;
                                }
                                if (iLogger.isEnabled() && null != object2) {
                                    LogUtilities.logDebug("Kerberos subject retrieved via ticket cache lookup", iLogger);
                                }
                            }
                        }
                    }
                    if (null == object2) {
                        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SASL_KERSEROS_ERR.name(), "Cannot setup Kerberos authentication");
                        throw errorException;
                    }
                    if (null == hiveJDBCSettings.m_krbServiceName || null == hiveJDBCSettings.m_krbHostFQDN) {
                        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SASL_KERSEROS_ERR.name(), "Kerberos service name error");
                        throw errorException;
                    }
                    if (TransportMode.HTTP != hiveJDBCSettings.m_transportMode) {
                        HiveServerPrivilegedAction hiveServerPrivilegedAction = new HiveServerPrivilegedAction(null, tSocket, hiveJDBCSettings.m_krbServiceName, hiveJDBCSettings.m_krbHostFQDN, iMessageSource, locale, hiveJDBCSettings.m_userGSSCredential);
                        Subject.doAs((Subject)object2, hiveServerPrivilegedAction);
                        return hiveServerPrivilegedAction.getTransKerberos();
                    }
                    httpClientBuilder.addInterceptorLast(new KerberosHttpInterceptor(hiveJDBCSettings.m_krbServiceName, hiveJDBCSettings.m_krbHostFQDN, (Subject)object2));
                    THttpClient tHttpClient = new THttpClient(HiveServer2ClientFactory.getFullHttpPath(hiveJDBCSettings), new ExtendedHttpClient(httpClientBuilder.build()));
                    object = tHttpClient;
                    break;
                }
                case SASL_PLAIN_UID: {
                    object = new TSaslClientTransport("PLAIN", null, null, null, null, new SaslCallbackHandler(hiveJDBCSettings), tSocket);
                    break;
                }
                case UIDPWD: {
                    if (TransportMode.HTTP == hiveJDBCSettings.m_transportMode) {
                        object2 = new THttpClient(HiveServer2ClientFactory.getFullHttpPath(hiveJDBCSettings), new ExtendedHttpClient(httpClientBuilder.build()));
                        HiveServer2ClientFactory.addCredentialsToHeader(hiveJDBCSettings, (THttpClient)object2);
                        object = object2;
                        break;
                    }
                    if (TransportMode.BINARY == hiveJDBCSettings.m_transportMode) {
                        object = tSocket;
                        break;
                    }
                    object = new TSaslClientTransport("PLAIN", null, null, null, null, new SaslCallbackHandler(hiveJDBCSettings), tSocket);
                    break;
                }
                case O_AUTH_CLIENT_CREDENTIALS: {
                    object = object2 = new THttpClient(HiveServer2ClientFactory.getFullHttpPath(hiveJDBCSettings), new ExtendedHttpClient(httpClientBuilder.build()));
                    break;
                }
                default: {
                    object2 = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CREATE_AUTHENTICATION_TRANSPORT_ERR.name(), "Unexpected authentication mechanism selected!");
                    throw object2;
                }
            }
            if (!(hiveJDBCSettings.m_transportMode == TransportMode.BINARY && hiveJDBCSettings.m_serverSSLSettings.m_enableSSL || ((TTransport)object).isOpen())) {
                ((TTransport)object).open();
            }
        }
        catch (Exception exception) {
            if (object != null) {
                ((TTransport)object).close();
            }
            if (tSocket != null) {
                tSocket.close();
            }
            if (exception instanceof TTransportException && exception.getCause() != null && exception.getCause() instanceof SocketTimeoutException) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_HS2_CLIENT_SOCKET_ERR.name());
                errorException.initCause(exception);
                throw errorException;
            }
            if (exception instanceof ErrorException) {
                throw (ErrorException)exception;
            }
            if (AuthMech.DELEGATION_TOKEN == hiveJDBCSettings.m_authMech) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DELEGATION_TOKEN_FAILED.name(), exception.getMessage());
                errorException.initCause(exception);
                throw errorException;
            }
            String string = exception.getMessage();
            if (null == string) {
                string = iMessageSource.loadMessage(locale, 101, HiveJDBCMessageKey.CONN_AUTHENTICATION_FAILED.name());
            }
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CREATE_AUTHENTICATION_TRANSPORT_ERR.name(), string);
            errorException.initCause(exception);
            throw errorException;
        }
        return object;
    }

    private static void addCredentialsToHeader(HiveJDBCSettings hiveJDBCSettings, THttpClient tHttpClient) {
        byte[] byArray = Base64.encodeBase64((hiveJDBCSettings.m_username + ":" + hiveJDBCSettings.m_password).getBytes());
        tHttpClient.setCustomHeader("Authorization", "Basic " + new String(byArray));
    }

    private static SSLTransportParameters createTETSSLTransportParams(HiveJDBCSettings hiveJDBCSettings) {
        SSLTransportParameters sSLTransportParameters = new SSLTransportParameters();
        if (null != hiveJDBCSettings.m_serverSSLSettings.m_sslKeyStore) {
            sSLTransportParameters.setKeyStore(hiveJDBCSettings.m_serverSSLSettings.m_sslKeyStore, hiveJDBCSettings.m_serverSSLSettings.m_sslKeyStorePwd);
        }
        if (null != hiveJDBCSettings.m_serverSSLSettings.m_sslTrustStore) {
            sSLTransportParameters.setTrustStore(hiveJDBCSettings.m_serverSSLSettings.m_sslTrustStore, hiveJDBCSettings.m_serverSSLSettings.m_sslTrustStorePwd);
        }
        sSLTransportParameters.requireClientAuth(false);
        sSLTransportParameters.allowSelfSigned(hiveJDBCSettings.m_serverSSLSettings.m_allowSelfSigned);
        sSLTransportParameters.certNamesMismatch(hiveJDBCSettings.m_serverSSLSettings.m_certNamesMismatch);
        sSLTransportParameters.hostNameInSAN(hiveJDBCSettings.m_serverSSLSettings.m_hostNameInSAN);
        return sSLTransportParameters;
    }

    private static String getFullHttpPath(HiveJDBCSettings hiveJDBCSettings) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(hiveJDBCSettings.m_serverSSLSettings.m_enableSSL ? "https://" : "http://");
        if (hiveJDBCSettings.m_useResolvedHostname) {
            stringBuilder.append(hiveJDBCSettings.m_customNetworkHooksSettings.m_resolvedHost);
        } else {
            stringBuilder.append(hiveJDBCSettings.m_host);
        }
        stringBuilder.append(":");
        stringBuilder.append(hiveJDBCSettings.m_port);
        stringBuilder.append(hiveJDBCSettings.m_httpPath.startsWith("/") ? "" : "/");
        stringBuilder.append(hiveJDBCSettings.m_httpPath);
        return stringBuilder.toString();
    }
}

