/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.api;

import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.jdbc.common.DSTrustManager;
import com.cloudera.impala.jdbc.common.SSLTransportParameters;
import com.cloudera.impala.jdbc.rpc.HttpClientFactory;
import com.cloudera.impala.jdbc42.internal.apache.http.conn.DnsResolver;
import com.cloudera.impala.jdbc42.internal.apache.http.impl.client.HttpClientBuilder;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TSocket;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyStore;
import java.util.ArrayList;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class TETSSLTransportFactory {
    private static final String PROTOCOL_SSL = "SSL";

    public static TSocket getClientSocket(HiveJDBCSettings hiveJDBCSettings, SSLTransportParameters sSLTransportParameters, SocketFactory socketFactory, ILogger iLogger) throws ErrorException, IOException {
        LogUtilities.logFunctionEntrance(iLogger, hiveJDBCSettings, sSLTransportParameters, socketFactory);
        if (null == sSLTransportParameters) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SSL_PARAMS_NOT_SET.name());
            throw errorException;
        }
        SSLContext sSLContext = TETSSLTransportFactory.createSSLContext(sSLTransportParameters, hiveJDBCSettings.m_host);
        return TETSSLTransportFactory.createClient(hiveJDBCSettings, sSLContext, socketFactory);
    }

    public static HttpClientBuilder getHttpsClient(HiveJDBCSettings hiveJDBCSettings, SSLTransportParameters sSLTransportParameters, SocketFactory socketFactory, DnsResolver dnsResolver, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, hiveJDBCSettings, sSLTransportParameters, socketFactory, dnsResolver);
        if (null == sSLTransportParameters) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SSL_PARAMS_NOT_SET.name());
            throw errorException;
        }
        SSLContext sSLContext = TETSSLTransportFactory.createSSLContext(sSLTransportParameters, hiveJDBCSettings.m_host);
        return HttpClientFactory.createHttpsClient(socketFactory, sSLContext, dnsResolver, sSLTransportParameters.getCertNamesMismatch() || sSLTransportParameters.getAllowSelfSigned(), iLogger);
    }

    private static String[] removeSSLProtocols(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Input protocols = '");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            stringBuffer.append(string);
            stringBuffer.append(",");
            if (null == string || string.toUpperCase().contains(PROTOCOL_SSL)) continue;
            arrayList.add(string);
        }
        stringBuffer.append("', enabled protocols = '");
        for (String string : arrayList) {
            stringBuffer.append(string);
            stringBuffer.append(",");
        }
        stringBuffer.append("'");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static SSLContext createSSLContext(SSLTransportParameters sSLTransportParameters, String string) throws ErrorException {
        SSLContext sSLContext;
        try {
            Object object;
            TrustManager[] trustManagerArray;
            sSLContext = SSLContext.getInstance(sSLTransportParameters.getProtocol());
            KeyManager[] keyManagerArray = null;
            if (sSLTransportParameters.isKeyStoreSet) {
                trustManagerArray = KeyManagerFactory.getInstance(sSLTransportParameters.getKeyManagerType());
                object = KeyStore.getInstance(sSLTransportParameters.getKeyStoreType());
                char[] cArray = null;
                if (null != sSLTransportParameters.getKeyPass()) {
                    cArray = sSLTransportParameters.getKeyPass().toCharArray();
                }
                ((KeyStore)object).load(new FileInputStream(sSLTransportParameters.getKeyStore()), cArray);
                trustManagerArray.init((KeyStore)object, cArray);
                keyManagerArray = trustManagerArray.getKeyManagers();
            }
            trustManagerArray = new TrustManager[]{new DSTrustManager(sSLTransportParameters, string)};
            sSLContext.init(keyManagerArray, trustManagerArray, null);
            object = sSLContext.createSSLEngine();
            ((SSLEngine)object).setEnabledProtocols(TETSSLTransportFactory.removeSSLProtocols(((SSLEngine)object).getEnabledProtocols()));
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CREATE_AUTHENTICATION_TRANSPORT_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
        return sSLContext;
    }

    private static TSocket createClient(HiveJDBCSettings hiveJDBCSettings, SSLContext sSLContext, SocketFactory socketFactory) throws ErrorException, IOException {
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        try {
            Closeable closeable;
            SSLSocket sSLSocket;
            if (null == socketFactory) {
                sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(hiveJDBCSettings.m_customNetworkHooksSettings.m_resolvedHost, hiveJDBCSettings.m_port);
            } else {
                closeable = socketFactory.createSocket();
                ((Socket)closeable).connect(new InetSocketAddress(hiveJDBCSettings.m_customNetworkHooksSettings.m_resolvedHost, hiveJDBCSettings.m_port));
                sSLSocket = (SSLSocket)sSLSocketFactory.createSocket((Socket)closeable, hiveJDBCSettings.m_host, hiveJDBCSettings.m_port, true);
            }
            sSLSocket.setSoTimeout(hiveJDBCSettings.m_timeout);
            sSLSocket.setEnabledProtocols(TETSSLTransportFactory.removeSSLProtocols(sSLSocket.getEnabledProtocols()));
            closeable = new TSocket(sSLSocket);
            ((TSocket)closeable).setTimeout(hiveJDBCSettings.m_timeout);
            return closeable;
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_THRIFT_COULD_NOT_CONNECT.name(), new String[]{hiveJDBCSettings.m_customNetworkHooksSettings.m_resolvedHost, String.valueOf(hiveJDBCSettings.m_port)});
            errorException.initCause(exception);
            throw errorException;
        }
    }
}

