/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.dataengine.metadata;

import com.cloudera.impala.dsi.dataengine.interfaces.IMetadataSource;
import com.cloudera.impala.dsi.dataengine.utilities.DSITypeUtilities;
import com.cloudera.impala.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.impala.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.cloudera.impala.hivecommon.api.IHiveClient;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.ArrayList;

public class HiveJDBCCatalogSchemaOnlyMetadataSource
implements IMetadataSource {
    private ILogger m_logger;
    private boolean m_hasStartedFetch = false;
    private final IHiveClient m_hiveClient;
    private ArrayList<String> m_schemas = null;
    private String m_currentCatalog;
    private int m_currentIndex = -1;

    public HiveJDBCCatalogSchemaOnlyMetadataSource(ILogger iLogger, IHiveClient iHiveClient) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, iLogger);
        this.m_logger = iLogger;
        this.m_hiveClient = iHiveClient;
        this.m_currentCatalog = null;
        this.initSchemas();
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_hasStartedFetch = false;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentCatalog, dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_schemas.get(this.m_currentIndex), dataWrapper, l, l2);
            }
        }
        throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return !this.m_hasStartedFetch;
    }

    private void initSchemas() throws ErrorException {
        if (this.m_schemas == null) {
            try {
                this.m_schemas = this.m_hiveClient.getSchemas();
                this.m_currentCatalog = this.m_hiveClient.getCatalogs().get(0);
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_SCHEMA_ERR.name(), "Metadata Initialization Error");
                errorException.initCause(exception);
                throw errorException;
            }
        }
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_currentIndex >= this.m_schemas.size() - 1) {
            return false;
        }
        ++this.m_currentIndex;
        if (!this.m_hasStartedFetch) {
            this.m_hasStartedFetch = true;
        }
        return true;
    }
}

