/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.impala.api;

import com.cloudera.impala.hivecommon.AuthMech;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.ServiceDiscoveryMode;
import com.cloudera.impala.hivecommon.TransportMode;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.impala.core.ImpalaJDBCDSIConnection;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TTransportException;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.AltusServiceException;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials.AltusProfileCredentialsProvider;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.client.AltusClientConfiguration;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.client.AltusClientConfigurationBuilder;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.dataware.api.DatawareClient;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.dataware.api.DatawareClientBuilder;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.dataware.model.Cluster;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.dataware.model.DescribeClusterRequest;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.dataware.model.DescribeClusterResponse;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.dataware.model.GetClusterAccessTokensRequest;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.dataware.model.GetClusterAccessTokensResponse;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.dataware.model.Instance;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.dataware.model.ListInstancesRequest;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.dataware.model.ListInstancesResponse;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.util.io.pem.PemObject;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.util.io.pem.PemReader;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.UUID;

public class AltusClusterDetails {
    public static final String NOT_FOUND = "NOT_FOUND";
    public static final String CREATED = "CREATED";
    public static final String COORDINATOR = "coordinator";
    private static final String DIRECTORY_SEPARATOR = "/";
    private static String TRUST_STORE_TYPE = "JKS";
    private static final String PUBLIC_IP_NONE = "none";
    private Cluster m_cluster;
    private String m_coordinatorEndpoint;
    private String m_user;
    private String m_password;
    private HiveJDBCSettings m_settings;
    private DatawareClient m_datawareClient;
    private ILogger m_logger;

    public AltusClusterDetails(String string, HiveJDBCSettings hiveJDBCSettings, ILogger iLogger) throws ErrorException {
        DescribeClusterResponse describeClusterResponse;
        LogUtilities.logFunctionEntrance(iLogger, string, hiveJDBCSettings);
        this.m_logger = iLogger;
        this.m_settings = hiveJDBCSettings;
        DescribeClusterRequest describeClusterRequest = new DescribeClusterRequest();
        describeClusterRequest.setClusterName(string);
        try {
            this.setDatawareClient(hiveJDBCSettings);
            describeClusterResponse = this.m_datawareClient.describeCluster(describeClusterRequest);
        }
        catch (AltusServiceException altusServiceException) {
            Exception exception = AltusClusterDetails.handleAltusServiceException(string, altusServiceException);
            if (exception instanceof ErrorException) {
                throw (ErrorException)exception;
            }
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_ERROR.name(), new String[]{String.valueOf((Object)hiveJDBCSettings.m_serviceDiscoveryMode), exception.getMessage()});
            throw errorException;
        }
        if (!describeClusterResponse.getCluster().getStatus().equals(CREATED)) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_ERROR.name(), new String[]{String.valueOf((Object)this.m_settings.m_serviceDiscoveryMode), "Altus cluster " + string + " is not in CREATED state"});
            throw errorException;
        }
        this.m_cluster = describeClusterResponse.getCluster();
        if (describeClusterResponse.getCluster().getSecured() != null && describeClusterResponse.getCluster().getSecured().booleanValue()) {
            GetClusterAccessTokensResponse getClusterAccessTokensResponse = this.getAltusClusterAccessCreds(string);
            this.m_user = getClusterAccessTokensResponse.getLdapTokenDetails().getUsername();
            this.m_password = getClusterAccessTokensResponse.getLdapTokenDetails().getPassword();
            hiveJDBCSettings.m_authMech = AuthMech.UIDPWD;
            hiveJDBCSettings.m_username = this.m_user;
            hiveJDBCSettings.m_password = this.m_password;
            hiveJDBCSettings.m_transportMode = TransportMode.SASL;
            if (!hiveJDBCSettings.m_serverSSLSettings.m_sslSpecifiedByUser) {
                LogUtilities.logInfo("Setting default ssl for secured cluster", iLogger);
                hiveJDBCSettings.m_serverSSLSettings.m_enableSSL = true;
            } else {
                LogUtilities.logInfo("ssl is specified by user to " + hiveJDBCSettings.m_serverSSLSettings.m_enableSSL, iLogger);
                if (!hiveJDBCSettings.m_serverSSLSettings.m_enableSSL) {
                    LogUtilities.logWarning("Secure cluster is detected however ssl is disabled by user", iLogger);
                }
            }
            if (!hiveJDBCSettings.m_serverSSLSettings.m_certNamesMismatchSpecifiedByUser) {
                LogUtilities.logInfo("Setting default CAIssuedCertNamesMismatch for secured cluster", iLogger);
                hiveJDBCSettings.m_serverSSLSettings.m_certNamesMismatch = true;
            } else {
                LogUtilities.logInfo("CAIssuedCertNamesMismatch is specified by user to " + hiveJDBCSettings.m_serverSSLSettings.m_certNamesMismatch, iLogger);
                if (!hiveJDBCSettings.m_serverSSLSettings.m_certNamesMismatch) {
                    LogUtilities.logWarning("Secure cluster is detected however CAIssuedCertNamesMismatch is disabled by user", iLogger);
                }
            }
            if (null == this.m_settings.m_serverSSLSettings.m_sslTrustStore) {
                try {
                    this.setupTrustStore(hiveJDBCSettings, iLogger);
                    this.m_settings.m_serverSSLSettings.m_deleteTrustStoreAtConnectionClose = true;
                }
                catch (Exception exception) {
                    if (exception instanceof ErrorException) {
                        throw (ErrorException)exception;
                    }
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_ERROR.name(), new String[]{String.valueOf((Object)hiveJDBCSettings.m_serviceDiscoveryMode), "Failed to set trust store for altus cluster: " + string});
                    errorException.initCause(exception);
                    throw errorException;
                }
            }
        }
    }

    public String getCoordinatorEndpoint() throws ErrorException {
        Object object;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null == this.m_coordinatorEndpoint) {
            object = new ListInstancesRequest();
            ((ListInstancesRequest)object).setClusterName(this.m_cluster.getClusterName());
            try {
                ListInstancesResponse listInstancesResponse = this.m_datawareClient.listInstances((ListInstancesRequest)object);
                for (Instance instance : listInstancesResponse.getInstances()) {
                    if (!instance.getRole().equalsIgnoreCase(COORDINATOR)) continue;
                    this.m_coordinatorEndpoint = instance.getPublicIpAddress();
                    if (this.m_settings.m_altusUsePrivateIp || null == this.m_coordinatorEndpoint || this.m_coordinatorEndpoint.isEmpty() || this.m_coordinatorEndpoint.equalsIgnoreCase(PUBLIC_IP_NONE)) {
                        LogUtilities.logInfo("Using private IP address for connection", this.m_logger);
                        this.m_coordinatorEndpoint = instance.getPrivateIpAddress();
                    }
                    break;
                }
            }
            catch (AltusServiceException altusServiceException) {
                Exception exception = AltusClusterDetails.handleAltusServiceException(this.m_cluster.getClusterName(), altusServiceException);
                if (exception instanceof ErrorException) {
                    throw (ErrorException)exception;
                }
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_ERROR.name(), new String[]{String.valueOf((Object)this.m_settings.m_serviceDiscoveryMode), "Failed to list instances of altus cluster: " + exception.getMessage()});
                errorException.initCause(exception);
                throw errorException;
            }
        }
        if (null == this.m_coordinatorEndpoint) {
            object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_ERROR.name(), new String[]{String.valueOf((Object)this.m_settings.m_serviceDiscoveryMode), "No coordinator endpoint available for cluster: " + this.m_cluster.getClusterName()});
            throw object;
        }
        return this.m_coordinatorEndpoint;
    }

    public void setupTrustStore(HiveJDBCSettings hiveJDBCSettings, ILogger iLogger) throws ErrorException {
        KeyStore keyStore;
        Object object;
        Closeable closeable;
        LogUtilities.logFunctionEntrance(iLogger, hiveJDBCSettings, iLogger);
        String string = AltusClusterDetails.createTrustDir(hiveJDBCSettings.m_altusTrustStoreDir);
        hiveJDBCSettings.m_serverSSLSettings.m_sslTrustStore = string + this.m_cluster.getClusterName() + UUID.randomUUID();
        hiveJDBCSettings.m_serverSSLSettings.m_sslTrustStorePwd = this.m_cluster.getClusterName() + UUID.randomUUID();
        LogUtilities.logInfo("Setting Altus trust store at " + hiveJDBCSettings.m_serverSSLSettings.m_sslTrustStore, iLogger);
        char[] cArray = hiveJDBCSettings.m_serverSSLSettings.m_sslTrustStorePwd.toCharArray();
        try {
            closeable = new FileOutputStream(hiveJDBCSettings.m_serverSSLSettings.m_sslTrustStore);
            object = null;
            try {
                keyStore = KeyStore.getInstance(TRUST_STORE_TYPE);
                keyStore.load(null, cArray);
                keyStore.store((OutputStream)closeable, cArray);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (closeable != null) {
                    if (object != null) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        closeable.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_ERROR.name(), new String[]{String.valueOf((Object)this.m_settings.m_serviceDiscoveryMode), "Error occured while setting up Altus trust store: " + exception.getMessage()});
            errorException.initCause(exception);
            throw errorException;
        }
        LogUtilities.logInfo("Converting root certificate in string format to X509 object.", iLogger);
        closeable = new StringReader(this.m_cluster.getRootCertificate());
        object = new PemReader((Reader)closeable);
        try (FileOutputStream fileOutputStream = new FileOutputStream(hiveJDBCSettings.m_serverSSLSettings.m_sslTrustStore);){
            PemObject pemObject = ((PemReader)object).readPemObject();
            if (pemObject == null) {
                throw new TTransportException("Could not read root certificate of Altus cluster : " + this.m_cluster.getClusterName());
            }
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            Certificate certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(pemObject.getContent()));
            LogUtilities.logInfo("Storing X509 certificate to local truststore.", iLogger);
            keyStore.setCertificateEntry(this.m_cluster.getClusterName(), certificate);
            keyStore.store(fileOutputStream, cArray);
        }
        catch (Exception exception) {
            ImpalaJDBCDSIConnection.deleteAltusTrustStore(this.m_settings.m_serverSSLSettings.m_sslTrustStore, this.m_logger);
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_ERROR.name(), new String[]{String.valueOf((Object)this.m_settings.m_serviceDiscoveryMode), "Error occured while setting up Altus trust store: " + exception.getMessage()});
            errorException.initCause(exception);
            throw errorException;
        }
        finally {
            try {
                ((BufferedReader)object).close();
            }
            catch (IOException iOException) {}
        }
    }

    private GetClusterAccessTokensResponse getAltusClusterAccessCreds(String string) throws ErrorException {
        GetClusterAccessTokensRequest getClusterAccessTokensRequest = new GetClusterAccessTokensRequest();
        getClusterAccessTokensRequest.setClusterName(string);
        try {
            return this.m_datawareClient.getClusterAccessTokens(getClusterAccessTokensRequest);
        }
        catch (AltusServiceException altusServiceException) {
            Exception exception = AltusClusterDetails.handleAltusServiceException(string, altusServiceException);
            if (exception instanceof ErrorException) {
                throw (ErrorException)exception;
            }
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_ERROR.name(), new String[]{String.valueOf((Object)this.m_settings.m_serviceDiscoveryMode), "Failed to get Altus cluster access tokens: " + exception.getMessage()});
            errorException.initCause(exception);
            throw errorException;
        }
    }

    private void setDatawareClient(HiveJDBCSettings hiveJDBCSettings) throws ErrorException {
        if (null == hiveJDBCSettings.m_altusCredFile) {
            this.m_datawareClient = DatawareClientBuilder.defaultBuilder().build();
        } else {
            AltusProfileCredentialsProvider altusProfileCredentialsProvider;
            try {
                altusProfileCredentialsProvider = new AltusProfileCredentialsProvider(hiveJDBCSettings.m_altusCredFile, hiveJDBCSettings.m_altusProfileName);
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.ALTUS_CREDENTIAL_FILE_READ_ERROR.name(), new String[]{String.valueOf((Object)hiveJDBCSettings.m_serviceDiscoveryMode), exception.getMessage()});
                errorException.initCause(exception);
                throw errorException;
            }
            AltusClientConfiguration altusClientConfiguration = AltusClientConfigurationBuilder.defaultBuilder().build();
            try {
                this.m_datawareClient = ((DatawareClientBuilder)((DatawareClientBuilder)DatawareClientBuilder.defaultBuilder().withCredentials(altusProfileCredentialsProvider)).withClientConfiguration(altusClientConfiguration)).build();
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_ERROR.name(), new String[]{String.valueOf((Object)ServiceDiscoveryMode.ALTUS), exception.getMessage()});
                errorException.initCause(exception);
                throw errorException;
            }
        }
    }

    private static Exception handleAltusServiceException(String string, AltusServiceException altusServiceException) {
        if (!altusServiceException.getStatusCode().equals(NOT_FOUND)) {
            return new Exception(altusServiceException);
        }
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_ERROR.name(), new String[]{"ALTUS", "Altus cluster " + string + " does not exist"});
        return errorException;
    }

    private static String createTrustDir(String string) throws ErrorException {
        if (null == string) {
            string = "/tmp/";
        } else if (!string.endsWith(DIRECTORY_SEPARATOR)) {
            string = string + DIRECTORY_SEPARATOR;
        }
        File file = new File(string);
        boolean bl = false;
        if (file.isDirectory()) {
            bl = true;
        } else {
            try {
                file.mkdir();
                bl = true;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_GENERAL_ERROR, exception.getMessage());
                errorException.initCause(exception);
                throw errorException;
            }
        }
        if (!bl) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_GENERAL_ERROR, "Error creating directory: " + string);
            throw errorException;
        }
        return string;
    }
}

