/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.impala.api;

import com.cloudera.impala.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.ServiceDiscoveryMode;
import com.cloudera.impala.hivecommon.api.ServiceDiscoveryFactory;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.impala.api.AltusClusterDetails;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ErrorException;

public class AltusServiceDiscoveryFactory
extends ServiceDiscoveryFactory {
    private int m_endpointIdx = 0;
    private AltusClusterDetails m_cluster;

    @Override
    public boolean supportServiceDiscoveryMode(ServiceDiscoveryMode serviceDiscoveryMode, ILogger iLogger) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[]{serviceDiscoveryMode, iLogger});
        switch (serviceDiscoveryMode) {
            case ALTUS: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void throwUnableToDiscoverServersError(ServiceDiscoveryMode serviceDiscoveryMode) throws ErrorException {
        this.m_cacheExp.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
        if (null != this.m_cacheExp) {
            throw this.m_cacheExp;
        }
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_NO_SERVERS.name(), new String[]{String.valueOf((Object)serviceDiscoveryMode)});
        throw errorException;
    }

    @Override
    protected String getNextServer(HiveJDBCSettings hiveJDBCSettings, ILogger iLogger) {
        LogUtilities.logFunctionEntrance(iLogger, hiveJDBCSettings);
        String string = this.getNextClusterName(hiveJDBCSettings);
        if (null == string) {
            return null;
        }
        try {
            this.m_cluster = new AltusClusterDetails(string, hiveJDBCSettings, iLogger);
            return this.m_cluster.getCoordinatorEndpoint() + ":" + hiveJDBCSettings.m_port;
        }
        catch (Exception exception) {
            ErrorException errorException = exception instanceof ErrorException ? (ErrorException)exception : HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_ERROR.name(), new String[]{String.valueOf((Object)hiveJDBCSettings.m_serviceDiscoveryMode), exception.getMessage()});
            this.m_cacheExp = errorException;
            this.getNextServer(hiveJDBCSettings, iLogger);
            return null;
        }
    }

    private String getNextClusterName(HiveJDBCSettings hiveJDBCSettings) {
        if (this.m_endpointIdx < hiveJDBCSettings.m_serviceDiscoveryEndpoints.length) {
            String string = hiveJDBCSettings.m_serviceDiscoveryEndpoints[this.m_endpointIdx];
            ++this.m_endpointIdx;
            return string;
        }
        return null;
    }
}

