/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc.jdbc42;

import com.cloudera.impala.dsi.dataengine.interfaces.IArray;
import com.cloudera.impala.dsi.dataengine.interfaces.IResultSet;
import com.cloudera.impala.exceptions.ExceptionConverter;
import com.cloudera.impala.exceptions.JDBCMessageKey;
import com.cloudera.impala.jdbc.common.SArray;
import com.cloudera.impala.jdbc.common.SStatement;
import com.cloudera.impala.jdbc.jdbc41.S41ForwardResultSet;
import com.cloudera.impala.jdbc.jdbc42.S42Array;
import com.cloudera.impala.jdbc.jdbc42.S42ResultSetMetaData;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.IWarningListener;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ExceptionType;
import com.cloudera.impala.utilities.JDBCVersion;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLType;

public class S42ForwardResultSet
extends S41ForwardResultSet {
    public S42ForwardResultSet(SStatement sStatement, IResultSet iResultSet, ILogger iLogger) throws SQLException {
        super(sStatement, iResultSet, iLogger);
        this.m_jdbcVersion = JDBCVersion.JDBC42;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getResultSetMetaData()) {
                this.initializeResultSetColumns();
                this.setResultSetMetadata(new S42ResultSetMetaData(this.getResultSetColumns(), this.getLogger(), this.getWarningListener()));
            }
            return this.getResultSetMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    protected SArray createArrayResult(IArray iArray) throws SQLException {
        return new S42Array(iArray, this.getParentConnection(), this.getLogger(), this.getWarningListener());
    }

    @Override
    public synchronized void updateObject(int n, Object object, SQLType sQLType) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, object, sQLType);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(n);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void updateObject(int n, Object object, SQLType sQLType, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, object, sQLType, n2);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(n);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void updateObject(String string, Object object, SQLType sQLType) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, object, sQLType);
        this.updateObject(this.findColumn(string), object, sQLType);
    }

    @Override
    public synchronized void updateObject(String string, Object object, SQLType sQLType, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, object, sQLType, n);
        this.updateObject(this.findColumn(string), object, sQLType, n);
    }
}

