/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.apache.thrift;

import com.cloudera.impala.jdbc42.internal.apache.thrift.TBase;
import com.cloudera.impala.jdbc42.internal.apache.thrift.TBaseHelper;
import com.cloudera.impala.jdbc42.internal.apache.thrift.TException;
import com.cloudera.impala.jdbc42.internal.apache.thrift.TFieldIdEnum;
import com.cloudera.impala.jdbc42.internal.apache.thrift.protocol.TField;
import com.cloudera.impala.jdbc42.internal.apache.thrift.protocol.TProtocol;
import com.cloudera.impala.jdbc42.internal.apache.thrift.protocol.TProtocolException;
import com.cloudera.impala.jdbc42.internal.apache.thrift.protocol.TStruct;
import com.cloudera.impala.jdbc42.internal.apache.thrift.scheme.IScheme;
import com.cloudera.impala.jdbc42.internal.apache.thrift.scheme.SchemeFactory;
import com.cloudera.impala.jdbc42.internal.apache.thrift.scheme.StandardScheme;
import com.cloudera.impala.jdbc42.internal.apache.thrift.scheme.TupleScheme;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class TUnion<T extends TUnion<T, F>, F extends TFieldIdEnum>
implements TBase<T, F> {
    protected Object value_;
    protected F setField_;
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();

    protected TUnion() {
        this.setField_ = null;
        this.value_ = null;
    }

    protected TUnion(F setField, Object value) {
        this.setFieldValue(setField, value);
    }

    protected TUnion(TUnion<T, F> other) {
        if (!other.getClass().equals(this.getClass())) {
            throw new ClassCastException();
        }
        this.setField_ = other.setField_;
        this.value_ = TUnion.deepCopyObject(other.value_);
    }

    private static Object deepCopyObject(Object o) {
        if (o instanceof TBase) {
            return ((TBase)o).deepCopy();
        }
        if (o instanceof ByteBuffer) {
            return TBaseHelper.copyBinary((ByteBuffer)o);
        }
        if (o instanceof List) {
            return TUnion.deepCopyList((List)o);
        }
        if (o instanceof Set) {
            return TUnion.deepCopySet((Set)o);
        }
        if (o instanceof Map) {
            return TUnion.deepCopyMap((Map)o);
        }
        return o;
    }

    private static Map deepCopyMap(Map<Object, Object> map) {
        HashMap<Object, Object> copy = new HashMap<Object, Object>();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            copy.put(TUnion.deepCopyObject(entry.getKey()), TUnion.deepCopyObject(entry.getValue()));
        }
        return copy;
    }

    private static Set deepCopySet(Set set) {
        HashSet<Object> copy = new HashSet<Object>();
        for (Object o : set) {
            copy.add(TUnion.deepCopyObject(o));
        }
        return copy;
    }

    private static List deepCopyList(List list) {
        ArrayList<Object> copy = new ArrayList<Object>(list.size());
        for (Object o : list) {
            copy.add(TUnion.deepCopyObject(o));
        }
        return copy;
    }

    public F getSetField() {
        return this.setField_;
    }

    public Object getFieldValue() {
        return this.value_;
    }

    @Override
    public Object getFieldValue(F fieldId) {
        if (fieldId != this.setField_) {
            throw new IllegalArgumentException("Cannot get the value of field " + fieldId + " because union's set field is " + this.setField_);
        }
        return this.getFieldValue();
    }

    @Override
    public Object getFieldValue(int fieldId) {
        return this.getFieldValue(this.enumForId((short)fieldId));
    }

    public boolean isSet() {
        return this.setField_ != null;
    }

    @Override
    public boolean isSet(F fieldId) {
        return this.setField_ == fieldId;
    }

    @Override
    public boolean isSet(int fieldId) {
        return this.isSet(this.enumForId((short)fieldId));
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TUnion)this);
    }

    @Override
    public void setFieldValue(F fieldId, Object value) {
        this.checkType(fieldId, value);
        this.setField_ = fieldId;
        this.value_ = value;
    }

    @Override
    public void setFieldValue(int fieldId, Object value) {
        this.setFieldValue(this.enumForId((short)fieldId), value);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TUnion)this);
    }

    protected abstract void checkType(F var1, Object var2) throws ClassCastException;

    protected abstract Object standardSchemeReadValue(TProtocol var1, TField var2) throws TException;

    protected abstract void standardSchemeWriteValue(TProtocol var1) throws TException;

    protected abstract Object tupleSchemeReadValue(TProtocol var1, short var2) throws TException;

    protected abstract void tupleSchemeWriteValue(TProtocol var1) throws TException;

    protected abstract TStruct getStructDesc();

    protected abstract TField getFieldDesc(F var1);

    protected abstract F enumForId(short var1);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(this.getClass().getSimpleName());
        sb.append(" ");
        if (this.getSetField() != null) {
            Object v = this.getFieldValue();
            sb.append(this.getFieldDesc(this.getSetField()).name);
            sb.append(":");
            if (v instanceof ByteBuffer) {
                TBaseHelper.toString((ByteBuffer)v, sb);
            } else {
                sb.append(v.toString());
            }
        }
        sb.append(">");
        return sb.toString();
    }

    @Override
    public final void clear() {
        this.setField_ = null;
        this.value_ = null;
    }

    static {
        schemes.put(StandardScheme.class, new TUnionStandardSchemeFactory());
        schemes.put(TupleScheme.class, new TUnionTupleSchemeFactory());
    }

    private static class TUnionTupleScheme
    extends TupleScheme<TUnion> {
        private TUnionTupleScheme() {
        }

        @Override
        public void read(TProtocol iprot, TUnion struct) throws TException {
            struct.setField_ = null;
            struct.value_ = null;
            short fieldID = iprot.readI16();
            struct.value_ = struct.tupleSchemeReadValue(iprot, fieldID);
            if (struct.value_ != null) {
                struct.setField_ = struct.enumForId(fieldID);
            }
        }

        @Override
        public void write(TProtocol oprot, TUnion struct) throws TException {
            if (struct.getSetField() == null || struct.getFieldValue() == null) {
                throw new TProtocolException("Cannot write a TUnion with no set value!");
            }
            oprot.writeI16(struct.setField_.getThriftFieldId());
            struct.tupleSchemeWriteValue(oprot);
        }
    }

    private static class TUnionTupleSchemeFactory
    implements SchemeFactory {
        private TUnionTupleSchemeFactory() {
        }

        public TUnionTupleScheme getScheme() {
            return new TUnionTupleScheme();
        }
    }

    private static class TUnionStandardScheme
    extends StandardScheme<TUnion> {
        private TUnionStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, TUnion struct) throws TException {
            struct.setField_ = null;
            struct.value_ = null;
            iprot.readStructBegin();
            TField field = iprot.readFieldBegin();
            struct.value_ = struct.standardSchemeReadValue(iprot, field);
            if (struct.value_ != null) {
                struct.setField_ = struct.enumForId(field.id);
            }
            iprot.readFieldEnd();
            iprot.readFieldBegin();
            iprot.readStructEnd();
        }

        @Override
        public void write(TProtocol oprot, TUnion struct) throws TException {
            if (struct.getSetField() == null || struct.getFieldValue() == null) {
                throw new TProtocolException("Cannot write a TUnion with no set value!");
            }
            oprot.writeStructBegin(struct.getStructDesc());
            oprot.writeFieldBegin(struct.getFieldDesc(struct.setField_));
            struct.standardSchemeWriteValue(oprot);
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TUnionStandardSchemeFactory
    implements SchemeFactory {
        private TUnionStandardSchemeFactory() {
        }

        public TUnionStandardScheme getScheme() {
            return new TUnionStandardScheme();
        }
    }
}

