/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.apache.thrift.transport;

import com.cloudera.impala.jdbc42.internal.apache.thrift.TByteArrayOutputStream;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TMemoryInputTransport;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TTransport;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TTransportException;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TTransportFactory;

public class TFramedTransport
extends TTransport {
    protected static final int DEFAULT_MAX_LENGTH = 0xFA0000;
    private int maxLength_;
    private TTransport transport_ = null;
    private final TByteArrayOutputStream writeBuffer_ = new TByteArrayOutputStream(1024);
    private final TMemoryInputTransport readBuffer_ = new TMemoryInputTransport(new byte[0]);
    private final byte[] i32buf = new byte[4];

    public TFramedTransport(TTransport transport, int maxLength) {
        this.transport_ = transport;
        this.maxLength_ = maxLength;
    }

    public TFramedTransport(TTransport transport) {
        this.transport_ = transport;
        this.maxLength_ = 0xFA0000;
    }

    @Override
    public void open() throws TTransportException {
        this.transport_.open();
    }

    @Override
    public boolean isOpen() {
        return this.transport_.isOpen();
    }

    @Override
    public void close() {
        this.transport_.close();
    }

    @Override
    public int read(byte[] buf, int off, int len) throws TTransportException {
        int got = this.readBuffer_.read(buf, off, len);
        if (got > 0) {
            return got;
        }
        this.readFrame();
        return this.readBuffer_.read(buf, off, len);
    }

    @Override
    public byte[] getBuffer() {
        return this.readBuffer_.getBuffer();
    }

    @Override
    public int getBufferPosition() {
        return this.readBuffer_.getBufferPosition();
    }

    @Override
    public int getBytesRemainingInBuffer() {
        return this.readBuffer_.getBytesRemainingInBuffer();
    }

    @Override
    public void consumeBuffer(int len) {
        this.readBuffer_.consumeBuffer(len);
    }

    public void clear() {
        this.readBuffer_.clear();
    }

    private void readFrame() throws TTransportException {
        this.transport_.readAll(this.i32buf, 0, 4);
        int size = TFramedTransport.decodeFrameSize(this.i32buf);
        if (size < 0) {
            this.close();
            throw new TTransportException(5, "Read a negative frame size (" + size + ")!");
        }
        if (size > this.maxLength_) {
            this.close();
            throw new TTransportException(5, "Frame size (" + size + ") larger than max length (" + this.maxLength_ + ")!");
        }
        byte[] buff = new byte[size];
        this.transport_.readAll(buff, 0, size);
        this.readBuffer_.reset(buff);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws TTransportException {
        this.writeBuffer_.write(buf, off, len);
    }

    @Override
    public void flush() throws TTransportException {
        byte[] buf = this.writeBuffer_.get();
        int len = this.writeBuffer_.len();
        this.writeBuffer_.reset();
        TFramedTransport.encodeFrameSize(len, this.i32buf);
        this.transport_.write(this.i32buf, 0, 4);
        this.transport_.write(buf, 0, len);
        this.transport_.flush();
    }

    public static final void encodeFrameSize(int frameSize, byte[] buf) {
        buf[0] = (byte)(0xFF & frameSize >> 24);
        buf[1] = (byte)(0xFF & frameSize >> 16);
        buf[2] = (byte)(0xFF & frameSize >> 8);
        buf[3] = (byte)(0xFF & frameSize);
    }

    public static final int decodeFrameSize(byte[] buf) {
        return (buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF;
    }

    public static class Factory
    extends TTransportFactory {
        private int maxLength_;

        public Factory() {
            this.maxLength_ = 0xFA0000;
        }

        public Factory(int maxLength) {
            this.maxLength_ = maxLength;
        }

        @Override
        public TTransport getTransport(TTransport base) {
            return new TFramedTransport(base, this.maxLength_);
        }
    }
}

