/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.apache.zookeeper.server;

import com.cloudera.impala.jdbc42.internal.apache.jute.InputArchive;
import com.cloudera.impala.jdbc42.internal.apache.jute.OutputArchive;
import com.cloudera.impala.jdbc42.internal.apache.jute.Record;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.data.Stat;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.data.StatPersisted;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DataNode
implements Record {
    DataNode parent;
    byte[] data;
    Long acl;
    public StatPersisted stat;
    private Set<String> children = null;
    private static final Set<String> EMPTY_SET = Collections.emptySet();

    DataNode() {
    }

    public DataNode(DataNode parent, byte[] data, Long acl, StatPersisted stat) {
        this.parent = parent;
        this.data = data;
        this.acl = acl;
        this.stat = stat;
    }

    public synchronized boolean addChild(String child) {
        if (this.children == null) {
            this.children = new HashSet<String>(8);
        }
        return this.children.add(child);
    }

    public synchronized boolean removeChild(String child) {
        if (this.children == null) {
            return false;
        }
        return this.children.remove(child);
    }

    public synchronized void setChildren(HashSet<String> children) {
        this.children = children;
    }

    public synchronized Set<String> getChildren() {
        if (this.children == null) {
            return EMPTY_SET;
        }
        return Collections.unmodifiableSet(this.children);
    }

    public synchronized void copyStat(Stat to) {
        to.setAversion(this.stat.getAversion());
        to.setCtime(this.stat.getCtime());
        to.setCzxid(this.stat.getCzxid());
        to.setMtime(this.stat.getMtime());
        to.setMzxid(this.stat.getMzxid());
        to.setPzxid(this.stat.getPzxid());
        to.setVersion(this.stat.getVersion());
        to.setEphemeralOwner(this.stat.getEphemeralOwner());
        to.setDataLength(this.data == null ? 0 : this.data.length);
        int numChildren = 0;
        if (this.children != null) {
            numChildren = this.children.size();
        }
        to.setCversion(this.stat.getCversion() * 2 - numChildren);
        to.setNumChildren(numChildren);
    }

    @Override
    public synchronized void deserialize(InputArchive archive, String tag) throws IOException {
        archive.startRecord("node");
        this.data = archive.readBuffer("data");
        this.acl = archive.readLong("acl");
        this.stat = new StatPersisted();
        this.stat.deserialize(archive, "statpersisted");
        archive.endRecord("node");
    }

    @Override
    public synchronized void serialize(OutputArchive archive, String tag) throws IOException {
        archive.startRecord(this, "node");
        archive.writeBuffer(this.data, "data");
        archive.writeLong(this.acl, "acl");
        this.stat.serialize(archive, "statpersisted");
        archive.endRecord(this, "node");
    }
}

