/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.quorum;

import com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.Request;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.RequestProcessor;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.quorum.Learner;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.quorum.QuorumPacket;
import com.cloudera.impala.jdbc42.internal.slf4j.Logger;
import com.cloudera.impala.jdbc42.internal.slf4j.LoggerFactory;
import java.io.Flushable;
import java.io.IOException;

public class SendAckRequestProcessor
implements RequestProcessor,
Flushable {
    private static final Logger LOG = LoggerFactory.getLogger(SendAckRequestProcessor.class);
    Learner learner;

    SendAckRequestProcessor(Learner peer) {
        this.learner = peer;
    }

    @Override
    public void processRequest(Request si) {
        if (si.type != 9) {
            QuorumPacket qp = new QuorumPacket(3, si.hdr.getZxid(), null, null);
            try {
                this.learner.writePacket(qp, false);
            }
            catch (IOException e) {
                LOG.warn("Closing connection to leader, exception during packet send", e);
                try {
                    if (!this.learner.sock.isClosed()) {
                        this.learner.sock.close();
                    }
                }
                catch (IOException e1) {
                    LOG.debug("Ignoring error closing the connection", e1);
                }
            }
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.learner.writePacket(null, true);
        }
        catch (IOException e) {
            LOG.warn("Closing connection to leader, exception during packet send", e);
            try {
                if (!this.learner.sock.isClosed()) {
                    this.learner.sock.close();
                }
            }
            catch (IOException e1) {
                LOG.debug("Ignoring error closing the connection", e1);
            }
        }
    }

    @Override
    public void shutdown() {
    }
}

