/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.com.cloudera.altus;

import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.AltusHTTPException;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.ValidationUtils;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class AltusServiceException
extends AltusHTTPException {
    private static final long serialVersionUID = -875642837484022999L;
    private final Map<String, List<String>> responseHeaders;
    private final String statusCode;
    private final String statusMessage;
    private final String requestId;

    public AltusServiceException(String requestId, int httpCode, Map<String, List<String>> responseHeaders, String statusCode, String statusMessage) {
        super(httpCode, statusMessage);
        ValidationUtils.checkNotNullAndThrow(requestId);
        ValidationUtils.checkNotNullAndThrow(responseHeaders);
        ValidationUtils.checkNotNullAndThrow(statusCode);
        ValidationUtils.checkNotNullAndThrow(statusMessage);
        this.responseHeaders = ImmutableMap.copyOf(responseHeaders);
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.requestId = requestId;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public String toString() {
        return String.format("%s: %d: %s: %s %s", this.getClass().getName(), this.getHttpCode(), this.statusCode, this.statusMessage, this.requestId);
    }

    @Override
    public String getMessage() {
        return this.toString();
    }
}

