/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials;

import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.AltusClientException;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials.AltusCredentials;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials.AltusCredentialsProvider;
import com.cloudera.impala.jdbc42.internal.slf4j.Logger;
import com.cloudera.impala.jdbc42.internal.slf4j.LoggerFactory;
import java.util.LinkedList;
import java.util.List;

public class AltusCredentialsProviderChain
implements AltusCredentialsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AltusCredentialsProviderChain.class);
    private final List<AltusCredentialsProvider> altusCredentialProviders = new LinkedList<AltusCredentialsProvider>();

    public AltusCredentialsProviderChain(AltusCredentialsProvider ... altusCredentialProviders) {
        if (altusCredentialProviders == null || altusCredentialProviders.length == 0) {
            throw new IllegalArgumentException("No Altus credentials providers specified");
        }
        for (AltusCredentialsProvider credentialsProvider : altusCredentialProviders) {
            this.altusCredentialProviders.add(credentialsProvider);
        }
    }

    @Override
    public AltusCredentials getCredentials() {
        for (AltusCredentialsProvider provider : this.altusCredentialProviders) {
            LOG.debug("trying to load credentials profile for provider " + provider.toString());
            try {
                AltusCredentials credentials = provider.getCredentials();
                if (credentials.getAccessKeyId() == null || credentials.getPrivateKey() == null) continue;
                return credentials;
            }
            catch (Exception e) {
                LOG.debug("Unable to load credentials for provider " + provider.toString() + ": " + e.getMessage());
            }
        }
        throw new AltusClientException("Unable to load credentials from provider files");
    }
}

