/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials;

import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials.AltusCredentials;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials.AltusCredentialsProvider;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials.BasicAltusCredentials;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.apache.commons.lang3.StringUtils;

public class AltusEnvironmentVariableCredentialsProvider
implements AltusCredentialsProvider {
    public static final String ALTUS_ACCESS_KEY_ID = "ALTUS_ACCESS_KEY_ID";
    public static final String ALTUS_PRIVATE_KEY = "ALTUS_PRIVATE_KEY";

    @Override
    public AltusCredentials getCredentials() {
        String accessKeyId = System.getenv(ALTUS_ACCESS_KEY_ID);
        String privateKey = System.getenv(ALTUS_PRIVATE_KEY);
        accessKeyId = StringUtils.trim(accessKeyId);
        privateKey = StringUtils.trim(privateKey);
        if (StringUtils.isBlank(accessKeyId) || StringUtils.isBlank(privateKey)) {
            throw new IllegalArgumentException("Invalid values for Altus credentials environment variables ALTUS_ACCESS_KEY_ID and ALTUS_PRIVATE_KEY");
        }
        return new BasicAltusCredentials(accessKeyId, privateKey);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

